/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.validate;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.papyrus.gmf.internal.validate.AbstractValidator;
import org.eclipse.papyrus.gmf.internal.validate.ExpressionCache;
import org.eclipse.papyrus.gmf.internal.validate.ExternModelImport;

public class AnnotatedOclValidator
extends AbstractValidator
implements EValidator {
    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (eObject instanceof EAnnotation) {
            return this.handleEAnnotation((EAnnotation)eObject, diagnostics, context);
        }
        if (eClass.getEPackage() != EcorePackage.eINSTANCE) {
            return this.handleMetaModel(eClass, eObject, diagnostics, context);
        }
        return true;
    }

    private boolean handleEAnnotation(EAnnotation annotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ExternModelImport importer = ExternModelImport.getImporter(context);
        ExpressionCache.Validator validator = ExpressionCache.get(annotation, diagnostics, importer);
        if (validator == null) {
            return true;
        }
        return validator.checkConstraints(diagnostics);
    }

    private boolean handleMetaModel(EClass eClass, EObject modelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ExternModelImport importer;
        ExpressionCache.Validator allExpressions;
        ExpressionCache cacheAccess = (ExpressionCache)context.get(ExpressionCache.class);
        if (cacheAccess == null) {
            cacheAccess = new ExpressionCache();
            context.put(ExpressionCache.class, cacheAccess);
        }
        if ((allExpressions = cacheAccess.get(eClass, diagnostics, importer = ExternModelImport.getImporter(context))) == null) {
            return true;
        }
        return allExpressions.validate(modelElement, diagnostics, AnnotatedOclValidator.getOptions(context));
    }
}

