/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.gmf.template2structure.internal.mapping;

import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.model2doc.core.builtintypes.ImageFormat;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.accessors.IOutputFileAccessor;
import org.eclipse.papyrus.model2doc.core.logger.IModel2DocLogger;
import org.eclipse.papyrus.model2doc.integration.gmf.template2structure.internal.mapping.CustomCopyToImageUtils;

public class GMFDiagramImageUtils {
    public static void generateImageOfDiagram(Diagram diagram, URI uri, IOutputFileAccessor accessor, int margin, ImageFormat format, IModel2DocLogger logger) {
        URL url = accessor.convertToURL(uri);
        String pathRoot = accessor.urlToPathString(url, true);
        if (uri.segmentCount() > 1) {
            URI folderURI = uri.trimSegments(1);
            String folderPath = folderURI.toPlatformString(true);
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(folderPath));
            GMFDiagramImageUtils.createFolders((IContainer)folder, logger);
        }
        CustomCopyToImageUtils copyImageUtil = new CustomCopyToImageUtils(margin);
        try {
            copyImageUtil.copyToImage(diagram, (IPath)new Path(pathRoot), GMFDiagramImageUtils.getFileFormat(format), (IProgressMonitor)new NullProgressMonitor(), PreferencesHint.USE_DEFAULTS);
        }
        catch (CoreException e) {
            logger.error((Throwable)e);
        }
    }

    private static void createFolders(IContainer folder, IModel2DocLogger logger) {
        if (!folder.exists()) {
            try {
                if (!folder.getParent().exists()) {
                    GMFDiagramImageUtils.createFolders(folder.getParent(), logger);
                }
                if (folder instanceof IFolder) {
                    ((IFolder)folder).create(true, true, (IProgressMonitor)new NullProgressMonitor());
                } else if (folder instanceof IProject) {
                    ((IProject)folder).create((IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                logger.error((Throwable)e);
            }
        }
    }

    private static ImageFileFormat getFileFormat(ImageFormat format) {
        switch (format) {
            case PNG: {
                return ImageFileFormat.PNG;
            }
        }
        return ImageFileFormat.SVG;
    }
}

