/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.architecture;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.core.utils.EditorNameInitializer;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.model2doc.core.logger.IModel2DocLogger;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentStructureTemplatePackage;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplatePrototype;
import org.eclipse.papyrus.model2doc.integration.architecture.internal.messages.Messages;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.PapyrusDocumentPrototype;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.architecture.AbstractCreateDocumentTemplateEditorCommand;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.command.ICreateDocumentTemplateEditorCommand;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.internal.viewpoint.PapyrusDocumentTemplateViewPrototype;

public class CreatePapyrusDocumentTemplateEditorCommand
extends AbstractCreateDocumentTemplateEditorCommand
implements ICreateDocumentTemplateEditorCommand {
    private String askName(ViewPrototype prototype, EObject semanticContext) {
        String defaultName = this.getDefaultName(prototype, semanticContext);
        return this.askDocumentName(Messages.CreatePapyrusDocumentTemplateEditorCommand_CreateDocumentTemplateDialogTitle, defaultName);
    }

    private String getDefaultName(ViewPrototype prototype, EObject semanticContext) {
        StringBuilder nameBuilder = new StringBuilder("New");
        nameBuilder.append(prototype.getLabel().replaceAll(" ", ""));
        String nameWithIncrement = EditorNameInitializer.getNameWithIncrement((EClass)DocumentStructureTemplatePackage.eINSTANCE.getTextDocumentTemplate(), (EStructuralFeature)DocumentStructureTemplatePackage.eINSTANCE.getDocumentTemplate_Name(), (String)nameBuilder.toString(), (EObject)semanticContext);
        return nameWithIncrement;
    }

    public DocumentTemplate execute(ViewPrototype prototype, String name, EObject semanticContext, boolean openAfterCreation, IModel2DocLogger logger) {
        return this.execute(prototype, name, semanticContext, semanticContext, openAfterCreation, logger);
    }

    public DocumentTemplate execute(ViewPrototype prototype, String name, EObject semanticContext, EObject graphicalContext, boolean openAfterCreation, IModel2DocLogger logger) {
        if (prototype instanceof PapyrusDocumentTemplateViewPrototype) {
            String documentName;
            PapyrusRepresentationKind representation = prototype.getRepresentationKind();
            Assert.isTrue((boolean)(representation instanceof PapyrusDocumentPrototype), (String)"The representation associated to the PapyrusDocumentTemplateViewPrototype must be an instanceof PapyrusDocumentPrototype.");
            PapyrusDocumentPrototype docProto = (PapyrusDocumentPrototype)representation;
            DocumentTemplatePrototype docTemplateProto = docProto.getDocumentTemplatePrototype();
            String string = documentName = name == null || name.isEmpty() ? this.askName(prototype, semanticContext) : name;
            if (documentName == null) {
                return null;
            }
            return super.execute(docTemplateProto, documentName, semanticContext, graphicalContext, openAfterCreation, logger);
        }
        return null;
    }
}

