/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.generator;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.model2doc.core.status.GenerationStatus;
import org.eclipse.papyrus.model2doc.core.status.IGenerationStatus;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Document;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.command.Template2StructureCommandFactory;
import org.eclipse.papyrus.model2doc.emf.template2structure.helpers.DocumentStructureVersionHelper;

public final class Template2StructureGeneratorWrapper {
    private final DocumentTemplate documentTemplate;
    private final DocumentStructureVersionHelper versionHelper;

    public Template2StructureGeneratorWrapper(DocumentTemplate documentTemplate) {
        this(documentTemplate, new DocumentStructureVersionHelper(documentTemplate));
    }

    public Template2StructureGeneratorWrapper(DocumentTemplate documentTemplate, DocumentStructureVersionHelper versionhelper) {
        this.documentTemplate = documentTemplate;
        this.versionHelper = versionhelper;
    }

    public IGenerationStatus generateDocumentStructure() {
        Object tmp;
        Collection commandResult;
        Iterator iter;
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.documentTemplate);
        if (domain == null) {
            return new GenerationStatus(4, "org.eclipse.papyrus.model2doc.emf.template2structure", "The editing domain can't be found.");
        }
        String version = this.versionHelper.getDocumentVersion();
        if (version == null) {
            return new GenerationStatus(8, "org.eclipse.papyrus.model2doc.emf.template2structure", "The creation has been cancelled.");
        }
        Command generatorCommand = Template2StructureCommandFactory.eINSTANCE.getGenerateDocumentStructureCommand(domain, this.documentTemplate, version);
        if (generatorCommand == null) {
            return new GenerationStatus(4, "org.eclipse.papyrus.model2doc.emf.template2structure", "The Template to Stucture Command has not been found.");
        }
        if (!generatorCommand.canExecute()) {
            return new GenerationStatus(4, "org.eclipse.papyrus.model2doc.emf.template2structure", "The Template to Stucture Command can't be executed.");
        }
        domain.getCommandStack().execute(generatorCommand);
        if (version != null && !version.isEmpty()) {
            this.versionHelper.saveLastGeneratedDocumentVersion(version);
        }
        if ((iter = (commandResult = generatorCommand.getResult()).iterator()).hasNext() && (tmp = iter.next()) instanceof Document) {
            GenerationStatus result = new GenerationStatus(0, "org.eclipse.papyrus.model2doc.emf.template2structure", "The generation of the DocumentStructure is now finished.");
            result.setResult(tmp);
            return result;
        }
        return new GenerationStatus(4, "org.eclipse.papyrus.model2doc.emf.template2structure", "The creation of the document structure failed for an unknown reason.");
    }
}

