/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.datavisualization.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForIEvaluationContext;
import org.eclipse.papyrus.moka.datavisualization.profile.DataSource;
import org.eclipse.papyrus.moka.datavisualization.profile.ValueSeries;
import org.eclipse.papyrus.moka.datavisualization.service.DataVisualizationService;
import org.eclipse.papyrus.moka.datavisualization.ui.GraphBuilderHelper;
import org.eclipse.papyrus.moka.xygraph.common.model.XYGraphDescriptorModel;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.XYGraphDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class CreateXYGraphFromDataSourceCommand
extends RecordingCommand {
    private IEvaluationContext evaluationContext;
    protected DataSource dataSource;

    public CreateXYGraphFromDataSourceCommand(TransactionalEditingDomain domain, DataSource dataSource, IEvaluationContext context) {
        super(domain);
        this.evaluationContext = context;
        this.dataSource = dataSource;
    }

    public boolean canExecute() {
        return true;
    }

    protected void doExecute() {
        ListSelectionDialog ldg = new ListSelectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (Object)this.dataSource, (IStructuredContentProvider)new DataSeriesContentProvider(), (ILabelProvider)new LabelSeriesContentProvider(), "Select the series");
        if (ldg.open() == 0) {
            Object[] selected = ldg.getResult();
            ArrayList<ValueSeries> series = new ArrayList<ValueSeries>(selected.length);
            int i = 0;
            while (i < selected.length) {
                series.add((ValueSeries)selected[i]);
                ++i;
            }
            DataVisualizationService.getInstance().fixDependencies(this.dataSource);
            try {
                XYGraphDescriptor desc = this.createDataValueSetGraph(ServiceUtilsForIEvaluationContext.getInstance().getModelSet((Object)this.evaluationContext), series);
                desc.setDataSource((EObject)this.dataSource);
                IPageManager pageMngr = ServiceUtilsForIEvaluationContext.getInstance().getIPageManager((Object)this.evaluationContext);
                pageMngr.openPage((Object)desc);
            }
            catch (NotFoundException | ServiceException e) {
                e.printStackTrace();
            }
        }
    }

    protected XYGraphDescriptor createDataValueSetGraph(ModelSet modelSet, List<ValueSeries> visibles) throws NotFoundException {
        XYGraphDescriptor xyGraph = GraphBuilderHelper.buildFromSeries(this.dataSource, visibles);
        XYGraphDescriptorModel model = (XYGraphDescriptorModel)modelSet.getModelChecked("org.eclipse.papyrus.moka.xygraph.model.XYGraphDescriptorModel");
        xyGraph.setContext(this.dataSource.getBase_DataType().eContainer());
        model.addXYGraphDescriptor(xyGraph);
        return xyGraph;
    }

    class DataSeriesContentProvider
    implements IStructuredContentProvider {
        DataSeriesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (!(inputElement instanceof DataSource)) {
                return null;
            }
            DataSource set = (DataSource)inputElement;
            Object[] objects = new Object[set.getSeries().size()];
            int i = 0;
            for (ValueSeries serie : set.getSeries()) {
                objects[i] = serie;
                ++i;
            }
            return objects;
        }
    }

    class LabelSeriesContentProvider
    extends LabelProvider {
        LabelSeriesContentProvider() {
        }

        public String getText(Object element) {
            if (!(element instanceof ValueSeries)) {
                return super.getText(element);
            }
            ValueSeries serie = (ValueSeries)element;
            return serie.getBase_Property().getLabel();
        }
    }
}

