/*******************************************************************************
 * Copyright (c) 2009, 2018 SAP AG and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     SAP AG - initial API and implementation
 ******************************************************************************
 */
package dataaccess.expressions.collectionexpressions.util;

import data.classes.InScope;
import data.classes.TypedElement;

import dataaccess.expressions.Expression;
import dataaccess.expressions.ExpressionWithArgument;
import dataaccess.expressions.WithArgument;

import dataaccess.expressions.collectionexpressions.*;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see dataaccess.expressions.collectionexpressions.CollectionexpressionsPackage
 * @generated
 */
public class CollectionexpressionsAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static CollectionexpressionsPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CollectionexpressionsAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = CollectionexpressionsPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CollectionexpressionsSwitch<Adapter> modelSwitch =
		new CollectionexpressionsSwitch<Adapter>() {
			@Override
			public Adapter caseIncluding(Including object) {
				return createIncludingAdapter();
			}
			@Override
			public Adapter caseExcluding(Excluding object) {
				return createExcludingAdapter();
			}
			@Override
			public Adapter caseIncludingAt(IncludingAt object) {
				return createIncludingAtAdapter();
			}
			@Override
			public Adapter caseIterate(Iterate object) {
				return createIterateAdapter();
			}
			@Override
			public Adapter caseCollectionExpression(CollectionExpression object) {
				return createCollectionExpressionAdapter();
			}
			@Override
			public Adapter caseExcludingAt(ExcludingAt object) {
				return createExcludingAtAdapter();
			}
			@Override
			public Adapter caseWithPosition(WithPosition object) {
				return createWithPositionAdapter();
			}
			@Override
			public Adapter caseCollectionExpressionWithArgument(CollectionExpressionWithArgument object) {
				return createCollectionExpressionWithArgumentAdapter();
			}
			@Override
			public Adapter caseTypedElement(TypedElement object) {
				return createTypedElementAdapter();
			}
			@Override
			public Adapter caseInScope(InScope object) {
				return createInScopeAdapter();
			}
			@Override
			public Adapter caseExpression(Expression object) {
				return createExpressionAdapter();
			}
			@Override
			public Adapter caseWithArgument(WithArgument object) {
				return createWithArgumentAdapter();
			}
			@Override
			public Adapter caseExpressionWithArgument(ExpressionWithArgument object) {
				return createExpressionWithArgumentAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link dataaccess.expressions.collectionexpressions.Including <em>Including</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see dataaccess.expressions.collectionexpressions.Including
	 * @generated
	 */
	public Adapter createIncludingAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link dataaccess.expressions.collectionexpressions.Excluding <em>Excluding</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see dataaccess.expressions.collectionexpressions.Excluding
	 * @generated
	 */
	public Adapter createExcludingAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link dataaccess.expressions.collectionexpressions.IncludingAt <em>Including At</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see dataaccess.expressions.collectionexpressions.IncludingAt
	 * @generated
	 */
	public Adapter createIncludingAtAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link dataaccess.expressions.collectionexpressions.Iterate <em>Iterate</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see dataaccess.expressions.collectionexpressions.Iterate
	 * @generated
	 */
	public Adapter createIterateAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link dataaccess.expressions.collectionexpressions.CollectionExpression <em>Collection Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see dataaccess.expressions.collectionexpressions.CollectionExpression
	 * @generated
	 */
	public Adapter createCollectionExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link dataaccess.expressions.collectionexpressions.ExcludingAt <em>Excluding At</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see dataaccess.expressions.collectionexpressions.ExcludingAt
	 * @generated
	 */
	public Adapter createExcludingAtAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link dataaccess.expressions.collectionexpressions.WithPosition <em>With Position</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see dataaccess.expressions.collectionexpressions.WithPosition
	 * @generated
	 */
	public Adapter createWithPositionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link dataaccess.expressions.collectionexpressions.CollectionExpressionWithArgument <em>Collection Expression With Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see dataaccess.expressions.collectionexpressions.CollectionExpressionWithArgument
	 * @generated
	 */
	public Adapter createCollectionExpressionWithArgumentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link data.classes.TypedElement <em>Typed Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see data.classes.TypedElement
	 * @generated
	 */
	public Adapter createTypedElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link data.classes.InScope <em>In Scope</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see data.classes.InScope
	 * @generated
	 */
	public Adapter createInScopeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link dataaccess.expressions.Expression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see dataaccess.expressions.Expression
	 * @generated
	 */
	public Adapter createExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link dataaccess.expressions.WithArgument <em>With Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see dataaccess.expressions.WithArgument
	 * @generated
	 */
	public Adapter createWithArgumentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link dataaccess.expressions.ExpressionWithArgument <em>Expression With Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see dataaccess.expressions.ExpressionWithArgument
	 * @generated
	 */
	public Adapter createExpressionWithArgumentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //CollectionexpressionsAdapterFactory
