/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.internal.values.SequenceValueImpl;
import org.eclipse.ocl.pivot.internal.values.SparseSequenceValueImpl;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerRange;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.SequenceValue;
import org.eclipse.ocl.pivot.values.Value;

public class RangeSequenceValueImpl
extends SequenceValueImpl {
    public RangeSequenceValueImpl(@NonNull CollectionTypeId typeId, @NonNull IntegerRange range) {
        super(typeId, range);
    }

    @Override
    public @NonNull SequenceValue append(@Nullable Object value) {
        IntegerRange theElements = this.getElements();
        IntegerValue nextValue = theElements.getLast().addInteger(ONE_VALUE);
        if (nextValue.equals(value)) {
            IntegerRange range = RangeSequenceValueImpl.createRange(theElements.getFirst(), nextValue);
            return new RangeSequenceValueImpl(this.getTypeId(), range);
        }
        List<Object> elements = this.createElements();
        elements.add(value);
        return new SparseSequenceValueImpl(this.getTypeId(), elements);
    }

    @Override
    public @NonNull IntegerValue count(@Nullable Object value) {
        IntegerValue integerValue = ValueUtil.isIntegerValue(value);
        if (integerValue != null && this.elements.contains(integerValue)) {
            return ONE_VALUE;
        }
        return ZERO_VALUE;
    }

    protected @NonNull List<Object> createElements() {
        ArrayList<Object> elements = new ArrayList<Object>(this.intSize());
        for (Object object : this.iterable()) {
            elements.add(object);
        }
        return elements;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RangeSequenceValueImpl) {
            RangeSequenceValueImpl that = (RangeSequenceValueImpl)obj;
            return this.elements.equals(that.elements);
        }
        return super.equals(obj);
    }

    @Override
    public @Nullable Value first() {
        return this.getElements().getFirst();
    }

    @Override
    public @NonNull SequenceValue flatten() {
        return this;
    }

    @Override
    public @NonNull IntegerRange getElements() {
        return (IntegerRange)this.elements;
    }

    @Override
    public @NonNull SequenceValue including(@Nullable Object value) {
        return this.append(value);
    }

    @Override
    public @Nullable Value last() {
        return this.getElements().getLast();
    }

    @Override
    public @NonNull SequenceValue prepend(@Nullable Object value) {
        IntegerRange theElements = this.getElements();
        IntegerValue previousValue = theElements.getFirst().subtractInteger(ONE_VALUE);
        if (previousValue.equals(value)) {
            IntegerRange range = RangeSequenceValueImpl.createRange(previousValue, theElements.getLast());
            return new RangeSequenceValueImpl(this.getTypeId(), range);
        }
        List<Object> elements = this.createElements();
        elements.add(0, value);
        return new SparseSequenceValueImpl(this.getTypeId(), elements);
    }

    @Override
    public void toString(@NonNull StringBuilder s, int lengthLimit) {
        s.append("Sequence{");
        IntegerRange theElements = this.getElements();
        s.append(theElements.getFirst());
        s.append("..");
        s.append(theElements.getLast());
        s.append("}");
        s.toString();
    }
}

