/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.ecore.EcoreASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryContribution;
import org.eclipse.ocl.pivot.internal.resource.EnvironmentFactoryAdapter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotEnvironmentFactory;
import org.eclipse.ocl.pivot.internal.utilities.Technology;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;

public class ASResourceFactoryRegistry {
    public static final @NonNull ASResourceFactoryRegistry INSTANCE = new ASResourceFactoryRegistry();
    protected final @NonNull Map<@NonNull String, @NonNull ASResourceFactoryContribution> contentType2resourceFactory = new HashMap<String, ASResourceFactoryContribution>();
    protected final @NonNull Map<@NonNull String, @NonNull ASResourceFactoryContribution> extension2resourceFactory = new HashMap<String, ASResourceFactoryContribution>();
    protected final @NonNull Map<@NonNull String, @NonNull ASResourceFactoryContribution> resourceClassName2resourceFactory = new HashMap<String, ASResourceFactoryContribution>();

    public synchronized Object addASResourceFactory(@Nullable String contentType, @Nullable String nonASextension, @Nullable String resourceClassName, @NonNull ASResourceFactoryContribution asResourceFactory) {
        ASResourceFactoryContribution oldASResourceFactory1 = null;
        if (contentType != null) {
            oldASResourceFactory1 = this.contentType2resourceFactory.put(contentType, asResourceFactory);
            assert (oldASResourceFactory1 == null || oldASResourceFactory1 == asResourceFactory || oldASResourceFactory1.basicGetASResourceFactory() == asResourceFactory || oldASResourceFactory1.basicGetASResourceFactory() == null);
        }
        if (nonASextension != null) {
            ASResourceFactoryContribution oldASResourceFactory2 = this.extension2resourceFactory.put(nonASextension, asResourceFactory);
            assert (oldASResourceFactory2 == null || oldASResourceFactory2 == asResourceFactory || oldASResourceFactory2.basicGetASResourceFactory() == asResourceFactory || oldASResourceFactory2.basicGetASResourceFactory() == null);
        }
        if (resourceClassName != null) {
            ASResourceFactoryContribution oldASResourceFactory3 = this.resourceClassName2resourceFactory.put(resourceClassName, asResourceFactory);
            assert (oldASResourceFactory3 == null || oldASResourceFactory3 == asResourceFactory || oldASResourceFactory3.basicGetASResourceFactory() == asResourceFactory || oldASResourceFactory3.basicGetASResourceFactory() == null);
        }
        return oldASResourceFactory1;
    }

    @Deprecated
    public void configureResourceSet(@NonNull ResourceSet resourceSet) {
        this.configureResourceSets(null, resourceSet);
    }

    public synchronized void configureResourceSets(@Nullable ResourceSet asResourceSet, @NonNull ResourceSet csResourceSet) {
        for (ASResourceFactoryContribution asResourceFactoryContribution : this.contentType2resourceFactory.values()) {
            ASResourceFactory asResourceFactory = asResourceFactoryContribution.basicGetASResourceFactory();
            if (asResourceFactory != null) {
                asResourceFactory.configureResourceSets(asResourceSet, csResourceSet);
                continue;
            }
            if (asResourceFactoryContribution.getPriority() == null) continue;
            asResourceFactoryContribution.getASResourceFactory().configureResourceSets(asResourceSet, csResourceSet);
        }
    }

    public void configureResourceFactoryRegistry(@NonNull ResourceSet resourceSet) {
        for (ASResourceFactoryContribution asResourceFactoryContribution : this.contentType2resourceFactory.values()) {
            ASResourceFactory asResourceFactory = asResourceFactoryContribution.basicGetASResourceFactory();
            if (asResourceFactory == null) continue;
            asResourceFactory.configureResourceFactoryRegistry(resourceSet);
        }
    }

    public @NonNull EnvironmentFactoryInternal createEnvironmentFactory(@NonNull ProjectManager projectManager, @Nullable ResourceSet externalResourceSet) {
        EnvironmentFactoryAdapter environmentFactoryAdapter;
        if (externalResourceSet != null && (environmentFactoryAdapter = EnvironmentFactoryAdapter.find((Notifier)externalResourceSet)) != null) {
            return environmentFactoryAdapter.getEnvironmentFactory();
        }
        return new PivotEnvironmentFactory(projectManager, externalResourceSet, null);
    }

    public @NonNull EnvironmentFactoryInternal createEnvironmentFactory(@NonNull ProjectManager projectManager, @Nullable ResourceSet csResourceSet, @Nullable ResourceSet asResourceSet) {
        EnvironmentFactoryAdapter environmentFactoryAdapter;
        if (csResourceSet != null && (environmentFactoryAdapter = EnvironmentFactoryAdapter.find((Notifier)csResourceSet)) != null) {
            return environmentFactoryAdapter.getEnvironmentFactory();
        }
        return new PivotEnvironmentFactory(projectManager, csResourceSet, asResourceSet);
    }

    public @Nullable ASResourceFactoryContribution get(@NonNull String contentType) {
        return this.contentType2resourceFactory.get(contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable ASResourceFactory getASResourceFactory(@NonNull Resource resource) {
        if (resource instanceof ASResource) {
            return ((ASResource)resource).getASResourceFactory();
        }
        if (resource instanceof CSResource) {
            return ((CSResource)resource).getASResourceFactory();
        }
        ASResourceFactoryRegistry aSResourceFactoryRegistry = this;
        synchronized (aSResourceFactoryRegistry) {
            Class<?> resourceClass = resource.getClass();
            String resourceClassName = resourceClass.getName();
            assert (resourceClassName != null);
            ASResourceFactoryContribution asResourceFactoryContribution = this.resourceClassName2resourceFactory.get(resourceClassName);
            if (asResourceFactoryContribution != null) {
                return asResourceFactoryContribution.getASResourceFactory();
            }
            Class<?> aClass = resourceClass;
            while (aClass != null) {
                String aClassName = aClass.getName();
                assert (aClassName != null);
                asResourceFactoryContribution = this.resourceClassName2resourceFactory.get(aClassName);
                if (asResourceFactoryContribution != null) {
                    ASResourceFactory asResourceFactory = asResourceFactoryContribution.getASResourceFactory();
                    this.resourceClassName2resourceFactory.put(resourceClassName, asResourceFactory);
                    return asResourceFactory;
                }
                Class<?>[] classArray = aClass.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> anInterface = classArray[n2];
                    String anInterfaceName = anInterface.getName();
                    assert (anInterfaceName != null);
                    asResourceFactoryContribution = this.resourceClassName2resourceFactory.get(anInterfaceName);
                    if (asResourceFactoryContribution != null) {
                        ASResourceFactory asResourceFactory = asResourceFactoryContribution.getASResourceFactory();
                        this.resourceClassName2resourceFactory.put(resourceClassName, asResourceFactory);
                        return asResourceFactory;
                    }
                    ++n2;
                }
                aClass = aClass.getSuperclass();
            }
            EcoreASResourceFactory asResourceFactory = EcoreASResourceFactory.getInstance();
            this.resourceClassName2resourceFactory.put(resourceClassName, asResourceFactory);
            return asResourceFactory;
        }
    }

    public @Nullable ASResourceFactory getASResourceFactoryForExtension(@Nullable String nonASextension) {
        ASResourceFactoryContribution asResourceFactoryContribution = this.extension2resourceFactory.get(nonASextension);
        return asResourceFactoryContribution != null ? asResourceFactoryContribution.getASResourceFactory() : null;
    }

    public Iterable<@NonNull ASResourceFactory> getExternalResourceFactories() {
        return Iterables.transform((Iterable)Iterables.filter(this.contentType2resourceFactory.values(), (Predicate)ExternalResourcePredicate.INSTANCE), (Function)ContributionFunction.INSTANCE);
    }

    public Iterable<@NonNull ASResourceFactory> getLoadedResourceFactories() {
        return Iterables.transform((Iterable)Iterables.filter(this.contentType2resourceFactory.values(), (Predicate)LoadedResourcePredicate.INSTANCE), (Function)ContributionFunction.INSTANCE);
    }

    public @NonNull Technology getTechnology() {
        Integer bestPriority = null;
        ASResourceFactory bestASResourceFactory = null;
        for (ASResourceFactory asResourceFactory : this.getExternalResourceFactories()) {
            Integer priority = asResourceFactory.getPriority();
            if (bestPriority != null && (priority == null || priority <= bestPriority)) continue;
            bestPriority = priority;
            bestASResourceFactory = asResourceFactory;
        }
        if (bestASResourceFactory == null) {
            bestASResourceFactory = EcoreASResourceFactory.getInstance();
        }
        return bestASResourceFactory.getTechnology();
    }

    public synchronized void remove(@Nullable String contentType, @Nullable String nonASextension, @Nullable String resourceClassName) {
        if (contentType != null) {
            this.contentType2resourceFactory.remove(contentType);
        }
        if (nonASextension != null) {
            this.extension2resourceFactory.remove(nonASextension);
        }
        if (resourceClassName != null) {
            this.resourceClassName2resourceFactory.remove(resourceClassName);
        }
    }

    public static final class ContributionFunction
    implements Function<ASResourceFactoryContribution, ASResourceFactory> {
        public static final @NonNull ContributionFunction INSTANCE = new ContributionFunction();

        public @NonNull ASResourceFactory apply(@NonNull ASResourceFactoryContribution asResourceFactoryContribution) {
            return asResourceFactoryContribution.getASResourceFactory();
        }
    }

    public static final class ExternalResourcePredicate
    implements Predicate<ASResourceFactoryContribution> {
        public static final @NonNull ExternalResourcePredicate INSTANCE = new ExternalResourcePredicate();

        public boolean apply(@NonNull ASResourceFactoryContribution asResourceFactoryContribution) {
            return asResourceFactoryContribution.getPriority() != null;
        }
    }

    public static final class LoadedResourcePredicate
    implements Predicate<ASResourceFactoryContribution> {
        public static final @NonNull LoadedResourcePredicate INSTANCE = new LoadedResourcePredicate();

        public boolean apply(@NonNull ASResourceFactoryContribution asResourceFactoryContribution) {
            return asResourceFactoryContribution.getPriority() != null || asResourceFactoryContribution.basicGetASResourceFactory() != null;
        }
    }
}

