/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet;

import org.eclipse.jet.taglib.TagInfo;

public final class ContextLogEntry {
    private static final ContextLogEntry[] EMPTY_ENTRIES_ARRAY = new ContextLogEntry[0];
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 4;
    public static final int CANCEL = 8;
    private final int severity;
    private final ContextLogEntry[] children;
    private final String message;
    private final Throwable exception;
    private final String templatePath;
    private final int line;
    private final int col;
    private final TagInfo tagInfo;

    private ContextLogEntry(Builder builder) {
        this.severity = builder.severity;
        if (builder.children.length > 0) {
            this.children = new ContextLogEntry[builder.children.length];
            System.arraycopy(builder.children, 0, this.children, 0, builder.children.length);
        } else if (builder.exception != null && builder.exception.getCause() != null) {
            Builder childEntryBuilder = new Builder(builder.getSeverity());
            childEntryBuilder.exception(builder.exception.getCause());
            this.children = new ContextLogEntry[]{childEntryBuilder.build()};
        } else {
            this.children = EMPTY_ENTRIES_ARRAY;
        }
        this.message = builder.message == null ? "" : builder.message;
        this.exception = builder.exception;
        this.templatePath = builder.templatePath;
        this.line = builder.line;
        this.col = builder.col;
        this.tagInfo = builder.tagInfo;
    }

    public ContextLogEntry[] getChildren() {
        ContextLogEntry[] copy = new ContextLogEntry[this.children.length];
        System.arraycopy(this.children, 0, copy, 0, this.children.length);
        return copy;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public int getCol() {
        return this.col;
    }

    public int getLine() {
        return this.line;
    }

    public TagInfo getTagInfo() {
        return this.tagInfo;
    }

    /* synthetic */ ContextLogEntry(Builder builder, ContextLogEntry contextLogEntry) {
        this(builder);
    }

    public static final class Builder {
        private final int severity;
        private final ContextLogEntry[] children;
        private String message;
        private Throwable exception;
        private String templatePath;
        private TagInfo tagInfo;
        private int line;
        private int col;

        public Builder(ContextLogEntry[] children) {
            if (children == null) {
                throw new NullPointerException();
            }
            this.children = children;
            int severity = 0;
            int i = 0;
            while (i < children.length) {
                if (children[i] == null) {
                    throw new NullPointerException(String.valueOf(i));
                }
                severity = Math.max(severity, children[i].getSeverity());
                ++i;
            }
            this.severity = severity;
        }

        public Builder(int severity) {
            if (severity != 0 && severity != 1 && severity != 2 && severity != 4 && severity != 8) {
                throw new IllegalArgumentException();
            }
            this.severity = severity;
            this.children = EMPTY_ENTRIES_ARRAY;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder exception(Throwable exception) {
            this.exception = exception;
            if (this.message == null) {
                this.message(exception.getLocalizedMessage());
            }
            if (this.message == null) {
                this.message(exception.toString());
            }
            return this;
        }

        public Builder templatePath(String templatePath) {
            this.templatePath = templatePath;
            return this;
        }

        public Builder location(int line, int col) {
            this.line = line;
            this.col = col;
            return this;
        }

        public Builder tagInfo(TagInfo tagInfo) {
            if (tagInfo == null) {
                throw new NullPointerException();
            }
            this.tagInfo = tagInfo;
            this.location(tagInfo.getLine(), tagInfo.getCol());
            return this;
        }

        public ContextLogEntry build() {
            return new ContextLogEntry(this, null);
        }

        public int getSeverity() {
            return this.severity;
        }
    }
}

