/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.typesystem.Type;
import org.eclipse.xtend.typesystem.emf.EDataTypeType;
import org.eclipse.xtend.typesystem.emf.EmfRegistryMetaModel;
import org.eclipse.xtend.typesystem.xsd.XSDMetaModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLTypeMapper {
    private HashMap<EClassifier, BasicType> emap = new HashMap();
    private HashMap<Class<?>, BasicType> jmap = new HashMap();
    private static XMLTypeMapper instance;

    private XMLTypeMapper() {
        this.createEMap();
        this.createJMap();
    }

    public BasicType getBasicTypeFromAllMaps(Object clazz) {
        BasicType r = this.emap.get(clazz);
        if (r != null) {
            return r;
        }
        return this.jmap.get(clazz);
    }

    protected void createJMap() {
        this.jmap.put(byte[].class, BasicType.STRING);
        this.jmap.put(Boolean.TYPE, BasicType.BOOL);
        this.jmap.put(Byte.TYPE, BasicType.INT);
        this.jmap.put(Double.TYPE, BasicType.REAL);
        this.jmap.put(Float.TYPE, BasicType.REAL);
        this.jmap.put(Integer.TYPE, BasicType.INT);
        this.jmap.put(Boolean.class, BasicType.BOOL);
        this.jmap.put(Byte.class, BasicType.INT);
        this.jmap.put(Double.class, BasicType.REAL);
        this.jmap.put(Float.class, BasicType.REAL);
        this.jmap.put(Integer.class, BasicType.INT);
        this.jmap.put(Long.class, BasicType.INT);
        this.jmap.put(Object.class, BasicType.OBJECT);
        this.jmap.put(Short.class, BasicType.REAL);
        this.jmap.put(String.class, BasicType.STRING);
        this.jmap.put(BigDecimal.class, BasicType.STRING);
        this.jmap.put(BigInteger.class, BasicType.INT);
        this.jmap.put(List.class, BasicType.LIST);
        this.jmap.put(Duration.class, BasicType.DURATION);
        this.jmap.put(XMLGregorianCalendar.class, BasicType.DATE);
        this.jmap.put(QName.class, BasicType.QNAME);
        this.jmap.put(Long.TYPE, BasicType.INT);
        this.jmap.put(Attr.class, BasicType.UNHANDLED);
        this.jmap.put(Document.class, BasicType.UNHANDLED);
        this.jmap.put(Element.class, BasicType.UNHANDLED);
        this.jmap.put(Node.class, BasicType.UNHANDLED);
        this.jmap.put(Short.TYPE, BasicType.REAL);
    }

    protected void createEMap() {
        XMLTypePackage x = XMLTypePackage.eINSTANCE;
        this.emap.put((EClassifier)x.getAnySimpleType(), BasicType.OBJECT);
        this.emap.put((EClassifier)x.getAnyURI(), BasicType.STRING);
        this.emap.put((EClassifier)x.getBase64Binary(), BasicType.STRING);
        this.emap.put((EClassifier)x.getBoolean(), BasicType.BOOL);
        this.emap.put((EClassifier)x.getBooleanObject(), BasicType.BOOL);
        this.emap.put((EClassifier)x.getByte(), BasicType.INT);
        this.emap.put((EClassifier)x.getByteObject(), BasicType.INT);
        this.emap.put((EClassifier)x.getDate(), BasicType.DATE);
        this.emap.put((EClassifier)x.getDateTime(), BasicType.DATE);
        this.emap.put((EClassifier)x.getDecimal(), BasicType.INT);
        this.emap.put((EClassifier)x.getDouble(), BasicType.REAL);
        this.emap.put((EClassifier)x.getDoubleObject(), BasicType.REAL);
        this.emap.put((EClassifier)x.getDuration(), BasicType.DURATION);
        this.emap.put((EClassifier)x.getENTITIES(), BasicType.LIST);
        this.emap.put((EClassifier)x.getENTITIESBase(), BasicType.LIST);
        this.emap.put((EClassifier)x.getENTITY(), BasicType.STRING);
        this.emap.put((EClassifier)x.getFloat(), BasicType.REAL);
        this.emap.put((EClassifier)x.getFloatObject(), BasicType.REAL);
        this.emap.put((EClassifier)x.getGDay(), BasicType.DATE);
        this.emap.put((EClassifier)x.getGMonth(), BasicType.DATE);
        this.emap.put((EClassifier)x.getGMonthDay(), BasicType.DATE);
        this.emap.put((EClassifier)x.getGYear(), BasicType.DATE);
        this.emap.put((EClassifier)x.getGYearMonth(), BasicType.DATE);
        this.emap.put((EClassifier)x.getHexBinary(), BasicType.STRING);
        this.emap.put((EClassifier)x.getID(), BasicType.STRING);
        this.emap.put((EClassifier)x.getIDREF(), BasicType.STRING);
        this.emap.put((EClassifier)x.getIDREFS(), BasicType.LIST);
        this.emap.put((EClassifier)x.getIDREFSBase(), BasicType.LIST);
        this.emap.put((EClassifier)x.getInt(), BasicType.INT);
        this.emap.put((EClassifier)x.getInteger(), BasicType.INT);
        this.emap.put((EClassifier)x.getIntObject(), BasicType.INT);
        this.emap.put((EClassifier)x.getLanguage(), BasicType.STRING);
        this.emap.put((EClassifier)x.getLong(), BasicType.INT);
        this.emap.put((EClassifier)x.getLongObject(), BasicType.INT);
        this.emap.put((EClassifier)x.getName_(), BasicType.STRING);
        this.emap.put((EClassifier)x.getNCName(), BasicType.STRING);
        this.emap.put((EClassifier)x.getNegativeInteger(), BasicType.INT);
        this.emap.put((EClassifier)x.getNMTOKEN(), BasicType.STRING);
        this.emap.put((EClassifier)x.getNMTOKENS(), BasicType.LIST);
        this.emap.put((EClassifier)x.getNMTOKENSBase(), BasicType.LIST);
        this.emap.put((EClassifier)x.getNonNegativeInteger(), BasicType.INT);
        this.emap.put((EClassifier)x.getNonPositiveInteger(), BasicType.INT);
        this.emap.put((EClassifier)x.getNormalizedString(), BasicType.STRING);
        this.emap.put((EClassifier)x.getNOTATION(), BasicType.STRING);
        this.emap.put((EClassifier)x.getPositiveInteger(), BasicType.INT);
        this.emap.put((EClassifier)x.getQName(), BasicType.QNAME);
        this.emap.put((EClassifier)x.getShort(), BasicType.INT);
        this.emap.put((EClassifier)x.getShortObject(), BasicType.INT);
        this.emap.put((EClassifier)x.getString(), BasicType.STRING);
        this.emap.put((EClassifier)x.getTime(), BasicType.DATE);
        this.emap.put((EClassifier)x.getToken(), BasicType.STRING);
        this.emap.put((EClassifier)x.getUnsignedByte(), BasicType.INT);
        this.emap.put((EClassifier)x.getUnsignedByteObject(), BasicType.INT);
        this.emap.put((EClassifier)x.getUnsignedInt(), BasicType.INT);
        this.emap.put((EClassifier)x.getUnsignedIntObject(), BasicType.INT);
        this.emap.put((EClassifier)x.getUnsignedLong(), BasicType.INT);
        this.emap.put((EClassifier)x.getUnsignedShort(), BasicType.INT);
        this.emap.put((EClassifier)x.getUnsignedShortObject(), BasicType.INT);
    }

    public static XMLTypeMapper instance() {
        if (instance == null) {
            instance = new XMLTypeMapper();
        }
        return instance;
    }

    public Type get(XSDMetaModel mm, EClassifier classifier, TypeSystem typesystem) {
        if (classifier == null) {
            return null;
        }
        BasicType type = this.emap.get(classifier);
        if (type == null && classifier.getInstanceClass() != null && (type = this.jmap.get(classifier.getInstanceClass())) == null && classifier.getInstanceClass().isEnum()) {
            type = BasicType.UNHANDLED;
        }
        if (type == null) {
            return null;
        }
        switch (type) {
            case BOOL: {
                return typesystem.getBooleanType();
            }
            case INT: {
                return typesystem.getIntegerType();
            }
            case REAL: {
                return typesystem.getRealType();
            }
            case STRING: {
                return typesystem.getStringType();
            }
            case OBJECT: {
                return typesystem.getObjectType();
            }
            case QNAME: {
                return mm.getQNameType();
            }
            case DATE: 
            case DURATION: 
            case LIST: 
            case UNHANDLED: {
                if (!(classifier instanceof EDataType)) break;
                return new EDataTypeType((EmfRegistryMetaModel)mm, XSDMetaModel.getFullyQualifiedName((ENamedElement)classifier), (EDataType)classifier);
            }
        }
        return typesystem.getObjectType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BasicType {
        STRING,
        INT,
        REAL,
        BOOL,
        OBJECT,
        DATE,
        DURATION,
        QNAME,
        LIST,
        UNHANDLED;

    }
}

