/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages.simple;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.internal.bridge.resolver.ContainmentClosure;
import org.eclipse.gmf.internal.bridge.resolver.NodePattern;
import org.eclipse.gmf.internal.bridge.resolver.StructureResolver;
import org.eclipse.gmf.internal.bridge.resolver.TypeLinkPattern;
import org.eclipse.gmf.internal.bridge.resolver.TypePattern;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.DomainModelSource;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.Resolution;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.ResolvedItem;

public class StructureBuilder {
    private final StructureResolver resolver;
    private final boolean withLabels;
    private final ContainmentClosure containmentClosure;

    public StructureBuilder(StructureResolver resolver, boolean withLabels) {
        this.resolver = resolver;
        this.withLabels = withLabels;
        this.containmentClosure = Plugin.getDefault().getContaintmentClosure();
    }

    public final boolean isWithLabels() {
        return this.withLabels;
    }

    public ResolvedItem process(DomainModelSource dms) {
        ResolvedItem item = new ResolvedItem(null, dms.getContents(), null, ResolvedItem.NO_RESOLUTIONS, false);
        TreeIterator it = dms.getContents().eAllContents();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof EClass)) continue;
            item.addChild(this.process((EClass)next, dms));
        }
        return item;
    }

    protected ResolvedItem process(EClass domainClass, DomainModelSource dms) {
        Resolution resolution;
        EClass diagramClass = dms.getDiagramElement();
        EPackage domainPackage = dms.getContents();
        Resolution[] resolutions = ResolvedItem.NODE_LINK_RESOLUTIONS;
        TypePattern pattern = this.resolver.resolve(domainClass, domainPackage);
        if (pattern instanceof NodePattern) {
            resolution = Resolution.NODE;
            if (diagramClass != null && !this.containmentClosure.contains(diagramClass, domainClass, domainPackage)) {
                resolution = null;
            }
        } else if (pattern instanceof TypeLinkPattern) {
            resolution = Resolution.LINK;
            if (diagramClass != null) {
                TypeLinkPattern linkPattern = (TypeLinkPattern)pattern;
                if (linkPattern.getSource() != null && !this.containmentClosure.contains(diagramClass, linkPattern.getSource().getEReferenceType(), domainPackage)) {
                    resolution = null;
                }
                if (linkPattern.getTarget() != null && !this.containmentClosure.contains(diagramClass, linkPattern.getTarget().getEReferenceType(), domainPackage)) {
                    resolution = null;
                }
            }
        } else {
            resolution = null;
            if (domainClass.isAbstract() || domainClass.isInterface()) {
                resolutions = ResolvedItem.NO_RESOLUTIONS;
            }
        }
        ResolvedItem item = new ResolvedItem(resolution, domainClass, pattern, resolutions, dms.isDisabled((EObject)domainClass));
        this.addLabels(item, domainClass, dms);
        this.addRefLinks(item, domainClass, dms);
        return item;
    }

    protected void addLabels(ResolvedItem typeItem, EClass type, DomainModelSource dms) {
        if (!this.withLabels) {
            return;
        }
        Resolution baseResolution = typeItem.getResolution() == null ? null : Resolution.LABEL;
        Collection resolvedAttrs = Collections.emptyList();
        if (typeItem.getPattern() != null) {
            resolvedAttrs = Arrays.asList(typeItem.getPattern().getLabels());
        }
        Resolution[] possibleResolutions = Arrays.equals(typeItem.getPossibleResolutions(), ResolvedItem.NO_RESOLUTIONS) ? ResolvedItem.NO_RESOLUTIONS : ResolvedItem.LABEL_RESOLUTIONS;
        for (EAttribute attribute : type.getEAllAttributes()) {
            Resolution resolution = resolvedAttrs.contains(attribute) ? baseResolution : null;
            typeItem.addChild(new ResolvedItem(resolution, attribute, null, possibleResolutions, dms.isDisabled((EObject)attribute)));
        }
    }

    protected void addRefLinks(ResolvedItem typeItem, EClass type, DomainModelSource dms) {
        Resolution baseResolution = typeItem.getResolution() != Resolution.NODE ? null : Resolution.LINK;
        Collection resolvedRefs = Collections.emptyList();
        if (typeItem.getPattern() instanceof NodePattern) {
            resolvedRefs = Arrays.asList(((NodePattern)typeItem.getPattern()).getRefLinks());
        }
        Resolution[] possibleResolutions = Arrays.equals(typeItem.getPossibleResolutions(), ResolvedItem.NO_RESOLUTIONS) ? ResolvedItem.NO_RESOLUTIONS : ResolvedItem.LINK_RESOLUTIONS;
        for (EReference reference : type.getEAllReferences()) {
            Resolution resolution = resolvedRefs.contains(reference) ? baseResolution : null;
            typeItem.addChild(new ResolvedItem(resolution, reference, null, possibleResolutions, dms.isDisabled((EObject)reference)));
        }
    }
}

