/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.utils.printer.actions;

import java.io.File;
import nestedcondition.NestedConstraint;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.henshin.ocl2ac.utils.printer.CoreCommand;
import org.eclipse.emf.henshin.ocl2ac.utils.printer.NestedConditionPrinter;
import org.eclipse.emf.henshin.ocl2ac.utils.printer.ViewCommand;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class NGCPrintViewActionShortVersion
implements IObjectActionDelegate {
    protected IWorkbenchPart workbenchPart;
    protected NestedConstraint constraint;
    private CoreCommand wincmd;
    File pdfFile = null;

    public void run(IAction action) {
        this.print();
    }

    protected void print() {
        if (this.constraint != null) {
            NestedConditionPrinter nestedConditionPrinter = new NestedConditionPrinter(this.constraint, true);
            nestedConditionPrinter.printDocument();
            final String filepath = nestedConditionPrinter.getOutputFilePath();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    System.out.println("Thread Running");
                    NGCPrintViewActionShortVersion.this.compileLatex2PDF(filepath);
                    File texFile = new File(filepath);
                    int lastIndexOf = texFile.getName().lastIndexOf(".tex");
                    String pdfFileName = texFile.getName().substring(0, lastIndexOf).concat(".pdf");
                    NGCPrintViewActionShortVersion.this.pdfFile = new File(texFile.getParent(), pdfFileName);
                    System.err.println(NGCPrintViewActionShortVersion.this.pdfFile.getPath());
                }
            };
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.pdfFile != null && !this.pdfFile.exists()) {
                System.err.println("The PDF file of the generated latex is not produced.");
            } else {
                ViewCommand.openView(this.pdfFile);
            }
        }
    }

    private void compileLatex2PDF(String filePath) {
        Path p = new Path(filePath);
        this.wincmd = new CoreCommand();
        this.wincmd.executePDFLatexCommand(p.toOSString(), p.toFile().getParent());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object first;
        this.constraint = null;
        if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof NestedConstraint) {
            this.constraint = (NestedConstraint)first;
            System.out.println(String.valueOf(this.constraint.getName()) + " " + this.constraint.eClass().getEPackage().getName());
        }
        action.setEnabled(this.constraint != null);
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
    }
}

