/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.info;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;

public class RuleChangeInfo {
    private final List<Node> createdNodes = new ArrayList<Node>();
    private final List<Node> deletedNodes = new ArrayList<Node>();
    private final List<Attribute> deletedAttributes = new ArrayList<Attribute>();
    private final List<Node> preservedNodes = new ArrayList<Node>();
    private final List<Edge> createdEdges = new ArrayList<Edge>();
    private final List<Edge> deletedEdges = new ArrayList<Edge>();
    private final List<Attribute> attributeChanges = new ArrayList<Attribute>();
    private final List<Edge> indexChanges = new ArrayList<Edge>();

    public RuleChangeInfo(Rule rule) {
        for (Node node : rule.getLhs().getNodes()) {
            if (rule.getMultiMappings().getOrigin(node) != null) continue;
            Node image = rule.getMappings().getImage(node, rule.getRhs());
            if (image == null) {
                this.deletedNodes.add(node);
                continue;
            }
            for (Attribute attribute : node.getAttributes()) {
                boolean attributeDeleted;
                boolean bl = attributeDeleted = image.getAttribute(attribute.getType()) == null;
                if (!attributeDeleted) continue;
                if (attribute.getType().isUnsettable() && this.isAttributeChangeable(attribute)) {
                    this.deletedAttributes.add(attribute);
                    continue;
                }
                throw new IllegalStateException("Cannot delete attribute which is unsetable or not changeable.");
            }
        }
        for (Node node : rule.getRhs().getNodes()) {
            if (rule.getMultiMappings().getOrigin(node) != null) continue;
            Node origin = rule.getMappings().getOrigin(node);
            if (origin == null) {
                this.createdNodes.add(node);
            } else {
                this.preservedNodes.add(node);
            }
            for (Attribute attribute : node.getAttributes()) {
                boolean attributeChanged = this.hasAttributeChanged(rule, origin, attribute);
                if (!attributeChanged) continue;
                if (this.isAttributeChangeable(attribute)) {
                    this.attributeChanges.add(attribute);
                    continue;
                }
                throw new IllegalStateException("Cannot assign a value to derived or unchangeable attribute.");
            }
        }
        for (Edge edge : rule.getLhs().getEdges()) {
            if (rule.getMultiMappings().getOrigin(edge) != null || rule.getMappings().getImage(edge, rule.getRhs()) != null) continue;
            this.deletedEdges.add(edge);
        }
        for (Edge edge : rule.getRhs().getEdges()) {
            if (rule.getMultiMappings().getOrigin(edge) != null) continue;
            if (rule.getMappings().getOrigin(edge) == null) {
                this.createdEdges.add(edge);
            }
            if (edge.getIndex() == null || edge.getIndex().trim().length() <= 0) continue;
            this.indexChanges.add(edge);
        }
    }

    private boolean hasAttributeChanged(Rule rule, Node origin, Attribute attribute) {
        Attribute originAttribute;
        boolean changed = origin == null ? true : (originAttribute = origin.getAttribute(attribute.getType())) == null || !originAttribute.getValue().equals(attribute.getValue());
        return changed;
    }

    private boolean isAttributeChangeable(Attribute attribute) {
        return !attribute.getType().isDerived() && attribute.getType().isChangeable();
    }

    public List<Node> getCreatedNodes() {
        return this.createdNodes;
    }

    public List<Node> getPreservedNodes() {
        return this.preservedNodes;
    }

    public List<Edge> getCreatedEdges() {
        return this.createdEdges;
    }

    public List<Edge> getDeletedEdges() {
        return this.deletedEdges;
    }

    public List<Attribute> getDeletedAttributes() {
        return this.deletedAttributes;
    }

    public List<Attribute> getAttributeChanges() {
        return this.attributeChanges;
    }

    public List<Node> getDeletedNodes() {
        return this.deletedNodes;
    }

    public List<Edge> getIndexChanges() {
        return this.indexChanges;
    }
}

