/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.debug;

import java.util.Arrays;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugElement;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugTarget;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugThread;

public class HenshinStackFrame
extends HenshinDebugElement
implements IStackFrame {
    private HenshinDebugThread debugThread;
    private IVariable[] variables;
    private String label;
    private int id;

    public HenshinStackFrame(HenshinDebugThread debugThread, IVariable[] variables, String label, int id) {
        super(debugThread == null ? null : (HenshinDebugTarget)debugThread.getDebugTarget());
        this.debugThread = debugThread;
        this.variables = variables;
        this.label = label;
        this.id = id;
    }

    public boolean canStepInto() {
        return this.debugThread.canStepInto();
    }

    public boolean canStepOver() {
        return this.debugThread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.debugThread.canStepReturn();
    }

    public boolean isStepping() {
        return this.debugThread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.debugThread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.debugThread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.debugThread.stepReturn();
    }

    public boolean canResume() {
        return this.debugThread.canResume();
    }

    public boolean canSuspend() {
        return this.debugThread.canSuspend();
    }

    public boolean isSuspended() {
        return this.debugThread.isSuspended();
    }

    public void resume() throws DebugException {
        this.debugThread.resume();
    }

    public void suspend() throws DebugException {
        this.debugThread.suspend();
    }

    public boolean canTerminate() {
        return this.debugThread.canTerminate();
    }

    public boolean isTerminated() {
        return this.debugThread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.debugThread.terminate();
    }

    public IThread getThread() {
        return this.debugThread;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.variables;
    }

    public boolean hasVariables() throws DebugException {
        return this.variables != null && this.variables.length != 0;
    }

    public int getLineNumber() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.label;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + Arrays.hashCode(this.variables);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        HenshinStackFrame other = (HenshinStackFrame)((Object)obj);
        if (this.id != other.id) {
            return false;
        }
        return Arrays.equals(this.variables, other.variables);
    }
}

