/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.editors.pages;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.eef.runtime.ui.widgets.masterdetails.AbstractEEFMasterDetailsBlock;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEEFMDFormPage
extends FormPage {
    public static final String PAGE_ID = "EEF-md-form-page";
    private FormEditor editor;
    private EditingDomain editingDomain;
    private AdapterFactory adapterFactory;
    protected AbstractEEFMasterDetailsBlock block;
    private ScrolledForm form;
    private IManagedForm managedForm;

    public AbstractEEFMDFormPage(FormEditor editor, String pageTitle) {
        super(editor, PAGE_ID, pageTitle);
        this.editor = editor;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.block = this.createMasterDetailsBlock();
        this.block.setEditingDomain(this.editingDomain);
        this.managedForm = managedForm;
        this.form = managedForm.getForm();
        managedForm.getToolkit().decorateFormHeading(this.form.getForm());
        this.block.createContent(managedForm);
        this.block.getMasterPart().addSelectionChangeListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractEEFMDFormPage.this.getManagedForm().fireSelectionChanged((IFormPart)AbstractEEFMDFormPage.this.block.getMasterPart(), event.getSelection());
            }
        });
        this.createContextMenuFor(this.block.getMasterPart().getModelViewer());
    }

    protected abstract AbstractEEFMasterDetailsBlock createMasterDetailsBlock();

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this.editor);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter(this.editingDomain, (Viewer)viewer));
    }

    public IManagedForm getManagedForm() {
        return this.managedForm;
    }

    public StructuredViewer getModelViewer() {
        return this.block.getMasterPart().getModelViewer();
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setEditingDomain(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public void setPageTitle(String title) {
        if (title != null && this.form != null) {
            this.form.setText(title);
        }
    }

    public void setInput(Object input) {
        this.block.setAdapterFactory(this.adapterFactory);
        this.block.setEditingDomain(this.editingDomain);
        this.block.setInput(input);
        if (input instanceof ResourceSet) {
            Resource resource = (Resource)((ResourceSet)input).getResources().get(0);
            this.setPageTitle(resource.getURI().toString());
            this.form.setImage(new AdapterFactoryLabelProvider(this.adapterFactory).getImage((Object)resource));
        }
    }

    public void addFilter(ViewerFilter filter) {
        this.block.addFilter(filter);
    }

    protected List<Action> additionalPageUserActions() {
        return null;
    }
}

