/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.impl.components;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionListener;
import org.eclipse.emf.eef.runtime.api.parts.IPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.impl.parts.NullCompositePropertiesEditionPart;
import org.eclipse.emf.eef.runtime.impl.utils.EEFRuntimeMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComposedPropertiesEditionComponent
implements IPropertiesEditionComponent {
    protected List<IPropertiesEditionComponent> subComponents;
    private List<IPropertiesEditionListener> listeners;

    public ComposedPropertiesEditionComponent(String mode) {
        this.subComponents = new ArrayList<IPropertiesEditionComponent>();
        this.listeners = new ArrayList<IPropertiesEditionListener>();
    }

    public ComposedPropertiesEditionComponent(List<IPropertiesEditionComponent> subComponents) {
        this.subComponents = subComponents;
        this.listeners = new ArrayList<IPropertiesEditionListener>();
        for (IPropertiesEditionComponent component : subComponents) {
            this.listeners.add(component);
            component.addListener(this);
        }
    }

    @Override
    public void setLiveEditingDomain(EditingDomain editingDomain) {
        for (IPropertiesEditionComponent component : this.subComponents) {
            component.setLiveEditingDomain(editingDomain);
        }
    }

    @Override
    public String[] partsList() {
        ArrayList<String> partsList = new ArrayList<String>();
        for (IPropertiesEditionComponent component : this.subComponents) {
            String[] partsList2 = component.partsList();
            int i = 0;
            while (i < partsList2.length) {
                String string = partsList2[i];
                if (!partsList.contains(string)) {
                    partsList.add(string);
                }
                ++i;
            }
        }
        String[] result = new String[partsList.size()];
        int i = 0;
        for (String nextPart : partsList) {
            result[i++] = nextPart;
        }
        return result;
    }

    @Override
    public void initPart(Class key, int kind, EObject element, ResourceSet allResource) {
        for (IPropertiesEditionComponent component : this.subComponents) {
            component.initPart(key, kind, element, allResource);
        }
    }

    @Override
    public void initPart(Class key, int kind, EObject element) {
        this.initPart(key, kind, element, element.eResource().getResourceSet());
    }

    @Override
    public IPropertiesEditionPart getPropertiesEditionPart(int kind, String key) {
        for (IPropertiesEditionComponent component : this.subComponents) {
            IPropertiesEditionPart propertiesEditionPart = component.getPropertiesEditionPart(kind, key);
            if (propertiesEditionPart == null || propertiesEditionPart instanceof NullCompositePropertiesEditionPart) continue;
            return propertiesEditionPart;
        }
        return new NullCompositePropertiesEditionPart(this);
    }

    @Override
    public CompoundCommand getPropertiesEditionCommand(EditingDomain editingDomain) {
        CompoundCommand cc = new CompoundCommand();
        for (IPropertiesEditionComponent component : this.subComponents) {
            CompoundCommand command = component.getPropertiesEditionCommand(editingDomain);
            if (command != null && command.canExecute()) {
                cc.append((Command)command);
                continue;
            }
            EEFRuntimePlugin.getDefault().logError(EEFRuntimeMessages.ComposedPropertiesEditionComponent_cmd_not_performed, null);
        }
        if (cc.isEmpty()) {
            cc.append((Command)IdentityCommand.INSTANCE);
        }
        return cc;
    }

    @Override
    public EObject getPropertiesEditionObject(EObject source) {
        for (IPropertiesEditionComponent component : this.subComponents) {
            source = component.getPropertiesEditionObject(source);
        }
        return source;
    }

    @Override
    public void firePropertiesChanged(IPropertiesEditionEvent event) {
        event.addHolder(this);
        for (IPropertiesEditionListener listener : this.listeners) {
            if (event.hold(listener)) continue;
            listener.firePropertiesChanged(event);
        }
    }

    public void addSubComponent(IPropertiesEditionComponent component) {
        if (this.subComponents != null && this.listeners != null) {
            this.subComponents.add(component);
            this.listeners.add(component);
            component.addListener(this);
        }
    }

    public void removeSubComponent(IPropertiesEditionComponent component) {
        if (this.subComponents != null && this.listeners != null) {
            component.removeListener(this);
            this.subComponents.remove(component);
            this.listeners.remove(component);
        }
    }

    @Override
    public void addListener(IPropertiesEditionListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IPropertiesEditionListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IPropertiesEditionListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public Diagnostic validateValue(IPropertiesEditionEvent event) {
        BasicDiagnostic diagnostic = new BasicDiagnostic(0, EEFRuntimeMessages.ComposedPropertiesEditionComponent_eef_validation_diagnostic, 0, EEFRuntimeMessages.ComposedPropertiesEditionComponent_no_problem, null);
        for (IPropertiesEditionComponent component : this.subComponents) {
            Diagnostic validateValue = component.validateValue(event);
            if (validateValue == null) continue;
            diagnostic.add(validateValue);
        }
        diagnostic.recomputeSeverity();
        return diagnostic;
    }

    @Override
    public Diagnostic validate() {
        BasicDiagnostic diagnostic = new BasicDiagnostic(0, EEFRuntimeMessages.ComposedPropertiesEditionComponent_eef_validation_diagnostic, 0, EEFRuntimeMessages.ComposedPropertiesEditionComponent_no_problem, null);
        for (IPropertiesEditionComponent component : this.subComponents) {
            diagnostic.getChildren().add(component.validate());
        }
        return diagnostic;
    }

    @Override
    public void dispose() {
        for (IPropertiesEditionComponent component : this.subComponents) {
            component.dispose();
        }
    }

    @Override
    public boolean mustBeComposed(Class key, int kind) {
        for (IPropertiesEditionComponent component : this.subComponents) {
            if (component.mustBeComposed(key, kind)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRequired(String key, int kind) {
        for (IPropertiesEditionComponent component : this.subComponents) {
            if (!component.isRequired(key, kind)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getHelpContent(String key, int kind) {
        for (IPropertiesEditionComponent component : this.subComponents) {
            if (component.getHelpContent(key, kind) == "") continue;
            return component.getHelpContent(key, kind);
        }
        return null;
    }

    @Override
    public Class translatePart(String key) {
        for (IPropertiesEditionComponent component : this.subComponents) {
            if (component.translatePart(key) == null) continue;
            return component.translatePart(key);
        }
        return null;
    }

    @Override
    public void setPropertiesEditionPart(Class key, int kind, IPropertiesEditionPart propertiesEditionPart) {
        for (IPropertiesEditionComponent component : this.subComponents) {
            component.setPropertiesEditionPart(key, kind, propertiesEditionPart);
        }
    }

    @Override
    public String getTabText(String key) {
        for (IPropertiesEditionComponent component : this.subComponents) {
            IPropertiesEditionPart part = component.getPropertiesEditionPart(0, key);
            if (part == null) continue;
            return part.getTitle();
        }
        return key;
    }
}

