/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.api.parts;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.IMessagePrefixProvider;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.forms.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEFMessageManager
implements IMessageManager {
    private static final DefaultPrefixProvider DEFAULT_PREFIX_PROVIDER = new DefaultPrefixProvider();
    private ArrayList<Message> messages = new ArrayList();
    private Hashtable<Control, ControlDecorator> decorators = new Hashtable();
    private boolean autoUpdate = true;
    private ScrolledForm scrolledForm;
    private IMessagePrefixProvider prefixProvider = DEFAULT_PREFIX_PROVIDER;
    private int decorationPosition = 17408;
    private static FieldDecoration standardError = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
    private static FieldDecoration standardWarning = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
    private static FieldDecoration standardInformation = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
    private static final String[] SINGLE_MESSAGE_SUMMARY_KEYS = new String[]{Messages.MessageManager_sMessageSummary, Messages.MessageManager_sMessageSummary, Messages.MessageManager_sWarningSummary, Messages.MessageManager_sErrorSummary};
    private static final String[] MULTIPLE_MESSAGE_SUMMARY_KEYS = new String[]{Messages.MessageManager_pMessageSummary, Messages.MessageManager_pMessageSummary, Messages.MessageManager_pWarningSummary, Messages.MessageManager_pErrorSummary};

    public EEFMessageManager(ScrolledForm scrolledForm, FormToolkit toolkit) {
        this.scrolledForm = scrolledForm;
        toolkit.decorateFormHeading(this.scrolledForm.getForm());
    }

    public void addMessage(Object key, String messageText, Object data, int type) {
        this.addMessage(null, key, messageText, data, type, this.messages);
        if (this.isAutoUpdate()) {
            this.updateForm();
        }
    }

    public void addMessage(Object key, String messageText, Object data, int type, Control control) {
        ControlDecorator dec = this.decorators.get(control);
        if (dec == null) {
            dec = new ControlDecorator(control);
            this.decorators.put(control, dec);
        }
        dec.addMessage(key, messageText, data, type);
        if (this.isAutoUpdate()) {
            this.updateForm();
        }
    }

    public void removeMessage(Object key) {
        Message message = this.findMessage(key, this.messages);
        if (message != null) {
            this.messages.remove(message);
            if (this.isAutoUpdate()) {
                this.updateForm();
            }
        }
    }

    public void removeMessages() {
        if (!this.messages.isEmpty()) {
            this.messages.clear();
            if (this.isAutoUpdate()) {
                this.updateForm();
            }
        }
    }

    public void removeMessage(Object key, Control control) {
        ControlDecorator dec = this.decorators.get(control);
        if (dec == null) {
            return;
        }
        if (dec.removeMessage(key) && this.isAutoUpdate()) {
            this.updateForm();
        }
    }

    public void removeMessages(Control control) {
        ControlDecorator dec = this.decorators.get(control);
        if (dec != null && dec.removeMessages() && this.isAutoUpdate()) {
            this.updateForm();
        }
    }

    public void removeAllMessages() {
        boolean needsUpdate = false;
        Enumeration<ControlDecorator> enm = this.decorators.elements();
        while (enm.hasMoreElements()) {
            ControlDecorator control = enm.nextElement();
            if (!control.removeMessages()) continue;
            needsUpdate = true;
        }
        if (!this.messages.isEmpty()) {
            this.messages.clear();
            needsUpdate = true;
        }
        if (needsUpdate && this.isAutoUpdate()) {
            this.updateForm();
        }
    }

    private Message addMessage(String prefix, Object key, String messageText, Object data, int type, ArrayList<Message> list) {
        Message message = this.findMessage(key, list);
        if (message == null) {
            message = new Message(key, messageText, type, data);
            message.prefix = prefix;
            list.add(message);
        } else {
            message.message = messageText;
            message.type = type;
            message.data = data;
        }
        return message;
    }

    private Message findMessage(Object key, ArrayList<Message> list) {
        int i = 0;
        while (i < list.size()) {
            Message message = list.get(i);
            if (message.getKey().equals(key)) {
                return message;
            }
            ++i;
        }
        return null;
    }

    public void update() {
        for (ControlDecorator dec : this.decorators.values()) {
            dec.update();
        }
        this.updateForm();
    }

    private void updateForm() {
        ArrayList<Message> mergedList = new ArrayList<Message>();
        mergedList.addAll(this.messages);
        Enumeration<ControlDecorator> enm = this.decorators.elements();
        while (enm.hasMoreElements()) {
            ControlDecorator dec = enm.nextElement();
            dec.addAll(mergedList);
        }
        this.update(mergedList);
    }

    private void update(ArrayList<Message> mergedList) {
        this.pruneControlDecorators();
        if (mergedList == null || mergedList.isEmpty()) {
            this.scrolledForm.setMessage(null, 0);
            return;
        }
        ArrayList<Message> peers = this.createPeers(mergedList);
        int maxType = peers.get(0).getMessageType();
        IMessage[] array = peers.toArray(new IMessage[peers.size()]);
        if (peers.size() == 1 && peers.get((int)0).prefix == null) {
            IMessage message = peers.get(0);
            String messageText = message.getMessage();
            this.scrolledForm.setMessage(messageText, maxType, array);
        } else {
            String messageText = peers.size() > 1 ? Messages.bind((String)MULTIPLE_MESSAGE_SUMMARY_KEYS[maxType], (Object[])new String[]{String.valueOf(peers.size())}) : SINGLE_MESSAGE_SUMMARY_KEYS[maxType];
            this.scrolledForm.setMessage(messageText, maxType, array);
        }
    }

    private static String getFullMessage(IMessage message) {
        if (message.getPrefix() == null) {
            return message.getMessage();
        }
        return String.valueOf(message.getPrefix()) + message.getMessage();
    }

    private ArrayList<Message> createPeers(ArrayList<Message> messages) {
        ArrayList<Message> peers = new ArrayList<Message>();
        int maxType = 0;
        int i = 0;
        while (i < messages.size()) {
            Message message = messages.get(i);
            if (message.type > maxType) {
                peers.clear();
                maxType = message.type;
            }
            if (message.type == maxType) {
                peers.add(message);
            }
            ++i;
        }
        return peers;
    }

    private String createDetails(ArrayList<Message> messages, boolean excludePrefix) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        int i = 0;
        while (i < messages.size()) {
            if (i > 0) {
                out.println();
            }
            IMessage m = messages.get(i);
            out.print(excludePrefix ? m.getMessage() : EEFMessageManager.getFullMessage(m));
            ++i;
        }
        out.flush();
        return sw.toString();
    }

    public static String createDetails(IMessage[] messages) {
        if (messages == null || messages.length == 0) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        int i = 0;
        while (i < messages.length) {
            if (i > 0) {
                out.println();
            }
            out.print(EEFMessageManager.getFullMessage(messages[i]));
            ++i;
        }
        out.flush();
        return sw.toString();
    }

    public String createSummary(IMessage[] messages) {
        return EEFMessageManager.createDetails(messages);
    }

    private void pruneControlDecorators() {
        Iterator<ControlDecorator> iter = this.decorators.values().iterator();
        while (iter.hasNext()) {
            ControlDecorator dec = iter.next();
            if (!dec.isDisposed()) continue;
            iter.remove();
        }
    }

    public IMessagePrefixProvider getMessagePrefixProvider() {
        return this.prefixProvider;
    }

    public void setMessagePrefixProvider(IMessagePrefixProvider provider) {
        this.prefixProvider = provider;
        for (ControlDecorator dec : this.decorators.values()) {
            dec.updatePrefix();
        }
    }

    public int getDecorationPosition() {
        return this.decorationPosition;
    }

    public void setDecorationPosition(int position) {
        this.decorationPosition = position;
        for (ControlDecorator dec : this.decorators.values()) {
            dec.updatePosition();
        }
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        boolean needsUpdate = !this.autoUpdate && autoUpdate;
        this.autoUpdate = autoUpdate;
        if (needsUpdate) {
            this.update();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ControlDecorator {
        private ControlDecoration decoration;
        private ArrayList<Message> controlMessages = new ArrayList();
        private String prefix;

        ControlDecorator(Control control) {
            this.decoration = new ControlDecoration(control, EEFMessageManager.this.decorationPosition, EEFMessageManager.this.scrolledForm.getBody());
        }

        public boolean isDisposed() {
            return this.decoration.getControl() == null;
        }

        void updatePrefix() {
            this.prefix = null;
        }

        void updatePosition() {
            Control control = this.decoration.getControl();
            this.decoration.dispose();
            this.decoration = new ControlDecoration(control, EEFMessageManager.this.decorationPosition, EEFMessageManager.this.scrolledForm.getBody());
            this.update();
        }

        String getPrefix() {
            if (this.prefix == null) {
                this.createPrefix();
            }
            return this.prefix;
        }

        private void createPrefix() {
            if (EEFMessageManager.this.prefixProvider == null) {
                this.prefix = "";
                return;
            }
            this.prefix = EEFMessageManager.this.prefixProvider.getPrefix(this.decoration.getControl());
            if (this.prefix == null) {
                this.prefix = "";
            }
        }

        void addAll(ArrayList<Message> target) {
            target.addAll(this.controlMessages);
        }

        void addMessage(Object key, String text, Object data, int type) {
            Message message = EEFMessageManager.this.addMessage(this.getPrefix(), key, text, data, type, this.controlMessages);
            message.control = this.decoration.getControl();
            if (EEFMessageManager.this.isAutoUpdate()) {
                this.update();
            }
        }

        boolean removeMessage(Object key) {
            Message message = EEFMessageManager.this.findMessage(key, this.controlMessages);
            if (message != null) {
                this.controlMessages.remove(message);
                if (EEFMessageManager.this.isAutoUpdate()) {
                    this.update();
                }
            }
            return message != null;
        }

        boolean removeMessages() {
            if (this.controlMessages.isEmpty()) {
                return false;
            }
            this.controlMessages.clear();
            if (EEFMessageManager.this.isAutoUpdate()) {
                this.update();
            }
            return true;
        }

        public void update() {
            if (this.controlMessages.isEmpty()) {
                this.decoration.setDescriptionText(null);
                this.decoration.hide();
            } else {
                ArrayList peers = EEFMessageManager.this.createPeers(this.controlMessages);
                int type = ((Message)peers.get(0)).getMessageType();
                String description = EEFMessageManager.this.createDetails(EEFMessageManager.this.createPeers(peers), true);
                if (type == 3) {
                    this.decoration.setImage(standardError.getImage());
                } else if (type == 2) {
                    this.decoration.setImage(standardWarning.getImage());
                } else if (type == 1) {
                    this.decoration.setImage(standardInformation.getImage());
                }
                this.decoration.setDescriptionText(description);
                this.decoration.show();
            }
        }
    }

    static class DefaultPrefixProvider
    implements IMessagePrefixProvider {
        DefaultPrefixProvider() {
        }

        public String getPrefix(Control c) {
            Composite parent = c.getParent();
            Control[] siblings = parent.getChildren();
            int i = 0;
            while (i < siblings.length) {
                if (siblings[i] == c) {
                    int j = i - 1;
                    while (j >= 0) {
                        Control label = siblings[j];
                        String ltext = null;
                        if (label instanceof Label) {
                            ltext = ((Label)label).getText();
                        } else if (label instanceof Hyperlink) {
                            ltext = ((Hyperlink)label).getText();
                        } else if (label instanceof CLabel) {
                            ltext = ((CLabel)label).getText();
                        }
                        if (ltext != null) {
                            if (!ltext.endsWith(":")) {
                                return String.valueOf(ltext) + ": ";
                            }
                            return String.valueOf(ltext) + " ";
                        }
                        --j;
                    }
                    break;
                }
                ++i;
            }
            return null;
        }
    }

    static class Message
    implements IMessage {
        Control control;
        Object data;
        Object key;
        String message;
        int type;
        String prefix;

        Message(Object key, String message, int type, Object data) {
            this.key = key;
            this.message = message;
            this.type = type;
            this.data = data;
        }

        public Object getKey() {
            return this.key;
        }

        public String getMessage() {
            return this.message;
        }

        public int getMessageType() {
            return this.type;
        }

        public Control getControl() {
            return this.control;
        }

        public Object getData() {
            return this.data;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

