/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.tests.fixtures;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.ICompositeOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class NonEMFCompositeOperation
extends AbstractOperation
implements ICompositeOperation {
    private final List<IUndoableOperation> children = new ArrayList<IUndoableOperation>();

    public NonEMFCompositeOperation() {
        super("Non-EMF Composite");
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        monitor.beginTask(this.getLabel(), this.children.size());
        try {
            for (IUndoableOperation next : this.children) {
                next.execute((IProgressMonitor)new SubProgressMonitor(monitor, 1), info);
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        monitor.beginTask(this.getLabel(), this.children.size());
        try {
            for (IUndoableOperation next : this.children) {
                next.redo((IProgressMonitor)new SubProgressMonitor(monitor, 1), info);
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        monitor.beginTask(this.getLabel(), this.children.size());
        try {
            ListIterator<IUndoableOperation> iter = this.children.listIterator(this.children.size());
            while (iter.hasPrevious()) {
                iter.previous().undo((IProgressMonitor)new SubProgressMonitor(monitor, 1), info);
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public void add(IUndoableOperation operation) {
        this.children.add(operation);
    }

    public void remove(IUndoableOperation operation) {
        this.children.remove(operation);
    }
}

