/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.eav;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.mapping.eav.EAVMultiValueHolder;
import org.eclipse.emf.teneo.hibernate.mapping.eav.EAVValueHolder;
import org.hibernate.HibernateException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EAVPropertyHandler
implements Getter,
Setter,
PropertyAccessor,
ExtensionPoint {
    private static final long serialVersionUID = -3712366809398761331L;

    public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this;
    }

    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this;
    }

    public Object get(Object owner) throws HibernateException {
        EObject eOwner = (EObject)owner;
        for (Adapter adapter : eOwner.eAdapters()) {
            if (!(adapter instanceof EAVObjectAdapter)) continue;
            EAVObjectAdapter eavAdapter = (EAVObjectAdapter)adapter;
            return eavAdapter.getValueList();
        }
        EAVObjectAdapter eavAdapter = new EAVObjectAdapter();
        eavAdapter.setTarget((Notifier)eOwner);
        List<EAVValueHolder> valueList = this.createValueList(eOwner);
        eavAdapter.setValueList(valueList);
        eOwner.eAdapters().add((Object)eavAdapter);
        return valueList;
    }

    public Object getForInsert(Object owner, Map mergeMap, SessionImplementor session) throws HibernateException {
        return this.get(owner);
    }

    public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
        EObject eOwner = (EObject)target;
        for (Adapter adapter : eOwner.eAdapters()) {
            if (!(adapter instanceof EAVObjectAdapter)) continue;
            EAVObjectAdapter eavAdapter = (EAVObjectAdapter)adapter;
            eavAdapter.setValueList((List)value);
            return;
        }
        this.fillTargetObject((EObject)target, (List)value);
        EAVObjectAdapter eavAdapter = new EAVObjectAdapter();
        eavAdapter.setTarget((Notifier)eOwner);
        eavAdapter.setValueList((List)value);
        eOwner.eAdapters().add((Object)eavAdapter);
    }

    public Method getMethod() {
        return null;
    }

    public String getMethodName() {
        return null;
    }

    public Class getReturnType() {
        return InternalEObject.class;
    }

    private List<EAVValueHolder> createValueList(EObject target) {
        ArrayList<EAVValueHolder> valueHolders = new ArrayList<EAVValueHolder>();
        for (EStructuralFeature eFeature : target.eClass().getEAllStructuralFeatures()) {
            if (eFeature.isDerived() || eFeature.isTransient() || eFeature.isVolatile()) continue;
            EAVValueHolder valueHolder = EAVValueHolder.create(target, eFeature);
            valueHolder.set(target.eGet(eFeature));
            if (eFeature.isUnsettable()) {
                valueHolder.setValueIsSet(target.eIsSet(eFeature));
            }
            valueHolders.add(valueHolder);
        }
        return valueHolders;
    }

    private void fillTargetObject(EObject target, List<EAVValueHolder> valueList) {
        for (EAVValueHolder valueHolder : valueList) {
            valueHolder.setValueInOwner((InternalEObject)target);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EAVObjectAdapter
    implements Adapter {
        private Notifier target;
        private List<EAVValueHolder> valueList;

        private EAVObjectAdapter() {
        }

        public Notifier getTarget() {
            return this.target;
        }

        public void setTarget(Notifier newTarget) {
            this.target = newTarget;
        }

        public List<EAVValueHolder> getValueList() {
            return this.valueList;
        }

        public void setValueList(List<EAVValueHolder> valueList) {
            this.valueList = valueList;
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }

        private EAVValueHolder getValueHolder(EStructuralFeature eFeature) {
            for (EAVValueHolder valueHolder : this.valueList) {
                if (valueHolder.getEStructuralFeature() != eFeature) continue;
                return valueHolder;
            }
            return null;
        }

        public void notifyChanged(Notification notification) {
            EStructuralFeature eFeature = (EStructuralFeature)notification.getFeature();
            EAVValueHolder valueHolder = this.getValueHolder(eFeature);
            EAVMultiValueHolder multiValueHolder = null;
            List list = null;
            if (valueHolder instanceof EAVMultiValueHolder) {
                list = (List)valueHolder.getValue();
                multiValueHolder = (EAVMultiValueHolder)valueHolder;
            }
            if (valueHolder == null) {
                return;
            }
            switch (notification.getEventType()) {
                case 3: {
                    if (notification.getPosition() != -1) {
                        list.add(notification.getPosition(), multiValueHolder.getElement(notification.getNewValue()));
                        break;
                    }
                    list.add(multiValueHolder.getElement(notification.getNewValue()));
                    break;
                }
                case 5: {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (Object o : (List)notification.getNewValue()) {
                        values.add(multiValueHolder.getElement(o));
                    }
                    if (notification.getPosition() != -1) {
                        list.addAll(notification.getPosition(), values);
                        break;
                    }
                    list.addAll(values);
                    break;
                }
                case 4: {
                    int removeIndex = notification.getPosition();
                    if (removeIndex == -1) {
                        Object oldValue = notification.getOldValue();
                        for (Object o : list) {
                            EAVValueHolder elemValue = (EAVValueHolder)o;
                            if (elemValue.getValue() != null && oldValue != null && elemValue.getValue().equals(oldValue)) {
                                removeIndex = list.indexOf(o);
                                break;
                            }
                            if (elemValue.getValue() != oldValue) continue;
                            removeIndex = list.indexOf(o);
                            break;
                        }
                    }
                    if (removeIndex == -1) break;
                    list.remove(removeIndex);
                    break;
                }
                case 6: {
                    List oldValues = (List)notification.getOldValue();
                    for (Object oldValue : oldValues) {
                        int removeIndex = notification.getPosition();
                        if (removeIndex == -1) {
                            for (Object o : list) {
                                EAVValueHolder elemValue = (EAVValueHolder)o;
                                if (elemValue.getValue() != null && oldValue != null && elemValue.getValue().equals(oldValue)) {
                                    removeIndex = list.indexOf(o);
                                    break;
                                }
                                if (elemValue.getValue() != oldValue) continue;
                                removeIndex = list.indexOf(o);
                                break;
                            }
                        }
                        if (removeIndex == -1) continue;
                        list.remove(removeIndex);
                    }
                    break;
                }
                case 7: {
                    if (list == null) break;
                    int oldPosition = (Integer)notification.getOldValue();
                    int newPosition = notification.getPosition();
                    Object o = list.remove(oldPosition);
                    list.add(newPosition, o);
                    break;
                }
                case 1: {
                    if (eFeature.isMany()) {
                        int position = notification.getPosition();
                        list.set(position, multiValueHolder.getElement(notification.getNewValue()));
                        break;
                    }
                    valueHolder.set(notification.getNewValue());
                    break;
                }
                case 2: {
                    if (eFeature.isMany()) break;
                    valueHolder.set(notification.getNewValue());
                }
            }
        }
    }
}

