/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.mapper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.mapper.BaseEFeatureAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.StoreMappingException;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pannotation.Basic;
import org.eclipse.emf.teneo.annotations.pannotation.EnumType;
import org.eclipse.emf.teneo.annotations.pannotation.Enumerated;
import org.eclipse.emf.teneo.annotations.pannotation.GeneratedValue;
import org.eclipse.emf.teneo.annotations.pannotation.GenerationType;
import org.eclipse.emf.teneo.annotations.pannotation.Id;
import org.eclipse.emf.teneo.annotations.pannotation.TemporalType;
import org.eclipse.emf.teneo.extension.ExtensionPoint;

public class SingleAttributeAnnotator
extends BaseEFeatureAnnotator
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(SingleAttributeAnnotator.class);
    private TemporalType optionDefaultTemporal = null;

    /*
     * Enabled aggressive block sorting
     */
    public void annotate(PAnnotatedEAttribute aAttribute) {
        EAttribute eAttribute;
        block12: {
            log.debug((Object)(" Adding default annotations for EAttribute " + aAttribute.getModelElement().getName()));
            eAttribute = (EAttribute)aAttribute.getModelElement();
            if (eAttribute.getEType() instanceof EEnum && aAttribute.getEnumerated() == null) {
                Enumerated enumerated = this.getFactory().createEnumerated();
                enumerated.setValue(EnumType.STRING);
                enumerated.setEModelElement((EModelElement)eAttribute);
                aAttribute.setEnumerated(enumerated);
            }
            if (this.getPersistenceOptions().isIDFeatureAsPrimaryKey() && eAttribute.isID() && aAttribute.getId() == null) {
                if (aAttribute.getPaEClass().getPaSuperEntity() != null && aAttribute.getPaEClass().getPaSuperEntity().getMappedSuperclass() == null) {
                    log.warn((Object)("The eclass " + aAttribute.getPaEClass().getModelEClass().getName() + " has an efeature (" + aAttribute.getModelEAttribute().getName() + ")" + " which has type ID, Teneo will not annotate this efeature with @Id because it is an efeature of a subtype"));
                    break block12;
                } else {
                    Id id = this.getFactory().createId();
                    id.setEModelElement((EModelElement)eAttribute);
                    aAttribute.setId(id);
                    this.addColumnConstraints(aAttribute);
                    if (this.getPersistenceOptions().isSetGeneratedValueOnIDFeature() && aAttribute.getGeneratedValue() == null && (Number.class.isAssignableFrom(eAttribute.getEAttributeType().getInstanceClass()) || eAttribute.getEAttributeType().getInstanceClass() == Long.TYPE || eAttribute.getEAttributeType().getInstanceClass() == Integer.TYPE)) {
                        GeneratedValue gv = this.getFactory().createGeneratedValue();
                        gv.setStrategy(GenerationType.AUTO);
                        aAttribute.setGeneratedValue(gv);
                    }
                    return;
                }
            }
            if (aAttribute.getId() != null) {
                this.addColumnConstraints(aAttribute);
                return;
            }
        }
        if (aAttribute.getTemporal() == null) {
            this.setTemporal(aAttribute, this.optionDefaultTemporal);
        }
        if (aAttribute.getBasic() == null) {
            Basic basic = this.getFactory().createBasic();
            basic.setEModelElement((EModelElement)eAttribute);
            if (aAttribute.getColumn() != null) {
                basic.setOptional(aAttribute.getColumn().isNullable());
            } else {
                basic.setOptional(!eAttribute.isRequired() || eAttribute.isUnsettable());
            }
            aAttribute.setBasic(basic);
        }
        if (aAttribute.getId() != null) {
            aAttribute.getBasic().setOptional(false);
            if (aAttribute.getColumn() != null && aAttribute.getColumn().isNullable() && log.isWarnEnabled()) {
                log.warn((Object)"The column of a primary key property is null, this will often result in database errors!");
            }
        }
        this.addColumnConstraints(aAttribute);
    }

    public void setPersistenceOptions(PersistenceOptions persistenceOptions) {
        super.setPersistenceOptions(persistenceOptions);
        this.optionDefaultTemporal = TemporalType.get((String)persistenceOptions.getDefaultTemporalValue());
        if (this.optionDefaultTemporal == null) {
            throw new StoreMappingException("Temporal value not found: " + persistenceOptions.getDefaultTemporalValue());
        }
    }
}

