/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.annotations.pannotation.AssociationOverride;
import org.eclipse.emf.teneo.annotations.pannotation.AttributeOverride;
import org.eclipse.emf.teneo.annotations.pannotation.Column;
import org.eclipse.emf.teneo.mapping.strategy.SQLNameStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractProcessingContext {
    protected static final Log log = LogFactory.getLog(AbstractProcessingContext.class);
    private Map<String, Object> currentOverrides = new HashMap<String, Object>();
    private Stack<Map<String, Object>> overrideStack = new Stack();
    private Stack<PAnnotatedEStructuralFeature> embeddingFeatureStack = new Stack();

    public void addAttributeOverrides(EList<AttributeOverride> aos) {
        if (aos != null) {
            for (AttributeOverride override : aos) {
                this.currentOverrides.put(override.getName(), override.getColumn());
            }
        }
    }

    public void addAssociationOverrides(EList<AssociationOverride> overrides) {
        if (overrides != null) {
            for (AssociationOverride override : overrides) {
                this.currentOverrides.put(override.getName(), override);
            }
        }
    }

    public void pushOverrideOnStack() {
        this.overrideStack.push(new HashMap<String, Object>(this.currentOverrides));
    }

    public void popOverrideStack() {
        this.currentOverrides = this.overrideStack.pop();
    }

    public void pushEmbeddingFeature(PAnnotatedEStructuralFeature er) {
        this.embeddingFeatureStack.push(er);
    }

    public void popEmbeddingFeature() {
        this.embeddingFeatureStack.pop();
    }

    public PAnnotatedEStructuralFeature getEmbeddingFeature() {
        if (this.embeddingFeatureStack.isEmpty()) {
            return null;
        }
        return this.embeddingFeatureStack.peek();
    }

    public void clearOverrides() {
        this.currentOverrides.clear();
    }

    public Column getAttributeOverride(PAnnotatedEStructuralFeature paFeature) {
        return this.getAttributeOverride(paFeature.getModelElement().getName());
    }

    public Column getAttributeOverride(String featureName) {
        return this.getAttributeOverride(featureName, -1);
    }

    public Column getAttributeOverride(String featureName, int embeddingFeatureIndex) {
        Column c = (Column)this.currentOverrides.get(featureName);
        if (c == null) {
            Object o = this.getFromStack(featureName);
            if (o != null && o instanceof Column) {
                return (Column)o;
            }
            if (embeddingFeatureIndex == -1 && !this.embeddingFeatureStack.isEmpty()) {
                String newFeatureName = String.valueOf(this.embeddingFeatureStack.peek().getModelElement().getName()) + "." + featureName;
                return this.getAttributeOverride(newFeatureName, this.embeddingFeatureStack.size() - 1);
            }
            if (embeddingFeatureIndex > 0) {
                String newFeatureName = String.valueOf(((PAnnotatedEStructuralFeature)this.embeddingFeatureStack.get(embeddingFeatureIndex - 1)).getModelElement().getName()) + "." + featureName;
                return this.getAttributeOverride(newFeatureName, embeddingFeatureIndex - 1);
            }
        }
        return c;
    }

    public AssociationOverride getAssociationOverrides(PAnnotatedEReference paReference) {
        return this.getAssociationOverrides(paReference.getModelEReference().getName());
    }

    public AssociationOverride getAssociationOverrides(String featureName) {
        return this.getAssociationOverrides(featureName, -1);
    }

    public AssociationOverride getAssociationOverrides(String featureName, int embeddingFeatureIndex) {
        AssociationOverride jcs = (AssociationOverride)this.currentOverrides.get(featureName);
        if (jcs == null) {
            Object o = this.getFromStack(featureName);
            if (o instanceof List) {
                return (AssociationOverride)o;
            }
            if (embeddingFeatureIndex == -1 && !this.embeddingFeatureStack.isEmpty()) {
                String newFeatureName = String.valueOf(this.embeddingFeatureStack.peek().getModelElement().getName()) + "." + featureName;
                return this.getAssociationOverrides(newFeatureName, this.embeddingFeatureStack.size() - 1);
            }
            if (embeddingFeatureIndex > 0) {
                String newFeatureName = String.valueOf(((PAnnotatedEStructuralFeature)this.embeddingFeatureStack.get(embeddingFeatureIndex - 1)).getModelElement().getName()) + "." + featureName;
                return this.getAssociationOverrides(newFeatureName, embeddingFeatureIndex - 1);
            }
        }
        return jcs;
    }

    private Object getFromStack(String name) {
        int i = this.overrideStack.size() - 1;
        while (i >= 0) {
            Map checkOverride = (Map)this.overrideStack.get(i);
            Object o = checkOverride.get(name);
            if (o != null) {
                return o;
            }
            --i;
        }
        return null;
    }

    public List<PAnnotatedEStructuralFeature> getInheritedFeatures(PAnnotatedEClass aClass) {
        EClass eclass = aClass.getModelEClass();
        if (eclass.getESuperTypes().size() == 0) {
            return new ArrayList<PAnnotatedEStructuralFeature>();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Determining inherited features which are mapped locally for " + aClass.getModelEClass().getName()));
        }
        ArrayList<EStructuralFeature> inheritedFeatures = new ArrayList<EStructuralFeature>((Collection<EStructuralFeature>)eclass.getEAllStructuralFeatures());
        inheritedFeatures.removeAll((Collection<?>)eclass.getEStructuralFeatures());
        if (aClass.getPaSuperEntity() != null) {
            inheritedFeatures.removeAll((Collection<?>)aClass.getPaSuperEntity().getModelEClass().getEAllStructuralFeatures());
        }
        this.removeIdFeatures(aClass, inheritedFeatures);
        PAnnotatedModel paModel = aClass.getPaModel();
        ArrayList<PAnnotatedEStructuralFeature> result = new ArrayList<PAnnotatedEStructuralFeature>();
        for (EStructuralFeature esf : inheritedFeatures) {
            result.add(paModel.getPAnnotated(esf));
        }
        for (PAnnotatedEStructuralFeature paFeature : result) {
            if (paFeature.getForeignKey() == null || !paFeature.getForeignKey().isGenerated()) continue;
            paFeature.getForeignKey().setName(this.getSqlNameStrategy().getForeignKeyName(aClass, paFeature));
        }
        return result;
    }

    public SQLNameStrategy getSqlNameStrategy() {
        throw new UnsupportedOperationException();
    }

    private void removeIdFeatures(PAnnotatedEClass aClass, List<EStructuralFeature> inheritedFeatures) {
        ArrayList<EClass> mappedSuperEClasses = new ArrayList<EClass>();
        for (EClass superEClass : aClass.getModelEClass().getESuperTypes()) {
            PAnnotatedEClass superPAClass = aClass.getPaModel().getPAnnotated(superEClass);
            if (superPAClass == null || superPAClass.getMappedSuperclass() == null) continue;
            mappedSuperEClasses.add(superPAClass.getModelEClass());
        }
        ArrayList mappedSuperFeatures = new ArrayList();
        if (aClass.getPaSuperEntity() == null || aClass.getPaSuperEntity().getMappedSuperclass() != null) {
            for (EClass mappedSuperEClass : mappedSuperEClasses) {
                mappedSuperFeatures.removeAll((Collection<?>)mappedSuperEClass.getEAllStructuralFeatures());
                mappedSuperFeatures.addAll(mappedSuperEClass.getEAllStructuralFeatures());
            }
        }
        ArrayList<EStructuralFeature> toRemove = new ArrayList<EStructuralFeature>();
        for (EStructuralFeature esf : inheritedFeatures) {
            PAnnotatedEStructuralFeature pef = aClass.getPaModel().getPAnnotated(esf);
            if (!(pef instanceof PAnnotatedEAttribute) || ((PAnnotatedEAttribute)pef).getId() == null || mappedSuperFeatures.contains(esf)) continue;
            toRemove.add(esf);
        }
        inheritedFeatures.removeAll(toRemove);
    }

    public boolean mustAddSyntheticID(PAnnotatedEClass entity) {
        if (entity.hasIdAnnotatedFeature()) {
            return false;
        }
        for (EClass superEClass : entity.getModelEClass().getEAllSuperTypes()) {
            PAnnotatedEClass superPAClass = entity.getPaModel().getPAnnotated(superEClass);
            if (superPAClass != null && superPAClass.getMappedSuperclass() == null) {
                return false;
            }
            if (superPAClass == null || superPAClass.getMappedSuperclass() == null || !superPAClass.hasIdAnnotatedFeature()) continue;
            return false;
        }
        return true;
    }
}

