/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.impl;

import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.ResourceLocationChange;
import org.eclipse.emf.compare.impl.EquivalenceImpl;
import org.eclipse.emf.compare.impl.MatchResourceImpl;
import org.eclipse.emf.compare.internal.spec.AttributeChangeSpec;
import org.eclipse.emf.compare.internal.spec.ComparisonSpec;
import org.eclipse.emf.compare.internal.spec.ConflictSpec;
import org.eclipse.emf.compare.internal.spec.DiffSpec;
import org.eclipse.emf.compare.internal.spec.FeatureMapChangeSpec;
import org.eclipse.emf.compare.internal.spec.MatchSpec;
import org.eclipse.emf.compare.internal.spec.ReferenceChangeSpec;
import org.eclipse.emf.compare.internal.spec.ResourceAttachmentChangeSpec;
import org.eclipse.emf.compare.internal.spec.ResourceLocationChangeSpec;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class CompareFactoryImpl
extends EFactoryImpl
implements CompareFactory {
    public static final String copyright = "Copyright (c) 2012 Obeo.\r\nAll rights reserved. This program and the accompanying materials\r\nare made available under the terms of the Eclipse Public License v1.0\r\nwhich accompanies this distribution, and is available at\r\nhttp://www.eclipse.org/legal/epl-v10.html\r\n\r\nContributors:\r\n    Obeo - initial API and implementation";

    public static CompareFactory init() {
        try {
            CompareFactory theCompareFactory = (CompareFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/compare");
            if (theCompareFactory != null) {
                return theCompareFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new CompareFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createComparison();
            }
            case 1: {
                return this.createMatchResource();
            }
            case 2: {
                return this.createMatch();
            }
            case 3: {
                return this.createDiff();
            }
            case 4: {
                return this.createResourceAttachmentChange();
            }
            case 5: {
                return this.createResourceLocationChange();
            }
            case 6: {
                return this.createReferenceChange();
            }
            case 7: {
                return this.createAttributeChange();
            }
            case 8: {
                return this.createFeatureMapChange();
            }
            case 9: {
                return this.createConflict();
            }
            case 10: {
                return this.createEquivalence();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 11: {
                return this.createDifferenceKindFromString(eDataType, initialValue);
            }
            case 12: {
                return this.createDifferenceSourceFromString(eDataType, initialValue);
            }
            case 13: {
                return this.createDifferenceStateFromString(eDataType, initialValue);
            }
            case 14: {
                return this.createConflictKindFromString(eDataType, initialValue);
            }
            case 15: {
                return this.createEIterableFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 11: {
                return this.convertDifferenceKindToString(eDataType, instanceValue);
            }
            case 12: {
                return this.convertDifferenceSourceToString(eDataType, instanceValue);
            }
            case 13: {
                return this.convertDifferenceStateToString(eDataType, instanceValue);
            }
            case 14: {
                return this.convertConflictKindToString(eDataType, instanceValue);
            }
            case 15: {
                return this.convertEIterableToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Comparison createComparison() {
        return new ComparisonSpec();
    }

    @Override
    public MatchResource createMatchResource() {
        MatchResourceImpl matchResource = new MatchResourceImpl();
        return matchResource;
    }

    @Override
    public Match createMatch() {
        return new MatchSpec();
    }

    @Override
    public Diff createDiff() {
        return new DiffSpec();
    }

    @Override
    public ResourceAttachmentChange createResourceAttachmentChange() {
        return new ResourceAttachmentChangeSpec();
    }

    @Override
    public ResourceLocationChange createResourceLocationChange() {
        return new ResourceLocationChangeSpec();
    }

    @Override
    public ReferenceChange createReferenceChange() {
        return new ReferenceChangeSpec();
    }

    @Override
    public AttributeChange createAttributeChange() {
        return new AttributeChangeSpec();
    }

    @Override
    public FeatureMapChange createFeatureMapChange() {
        return new FeatureMapChangeSpec();
    }

    @Override
    public Conflict createConflict() {
        ConflictSpec conflict = new ConflictSpec();
        return conflict;
    }

    @Override
    public Equivalence createEquivalence() {
        EquivalenceImpl equivalence = new EquivalenceImpl();
        return equivalence;
    }

    public DifferenceKind createDifferenceKindFromString(EDataType eDataType, String initialValue) {
        DifferenceKind result = DifferenceKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDifferenceKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DifferenceSource createDifferenceSourceFromString(EDataType eDataType, String initialValue) {
        DifferenceSource result = DifferenceSource.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDifferenceSourceToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DifferenceState createDifferenceStateFromString(EDataType eDataType, String initialValue) {
        DifferenceState result = DifferenceState.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDifferenceStateToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ConflictKind createConflictKindFromString(EDataType eDataType, String initialValue) {
        ConflictKind result = ConflictKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertConflictKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Iterable<?> createEIterableFromString(EDataType eDataType, String initialValue) {
        return (Iterable)super.createFromString(initialValue);
    }

    public String convertEIterableToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(instanceValue);
    }

    @Override
    public ComparePackage getComparePackage() {
        return (ComparePackage)this.getEPackage();
    }

    @Deprecated
    public static ComparePackage getPackage() {
        return ComparePackage.eINSTANCE;
    }
}

