/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.git.framework.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.compare.ide.ui.tests.framework.AbstractCompareTestCaseJUnitBlock;
import org.eclipse.emf.compare.ide.ui.tests.framework.EMFCompareTestConfiguration;
import org.eclipse.emf.compare.ide.ui.tests.framework.ResolutionStrategyID;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.GitMergeStrategyID;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitCherryPick;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitCompare;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitInput;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitMerge;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitRebase;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitTest;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.internal.statements.AbstractGitStatement;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.internal.statements.GitCherryPickStatement;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.internal.statements.GitCompareStatement;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.internal.statements.GitMergeStatement;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.internal.statements.GitRebaseStatement;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.internal.statements.GitTestStatement;
import org.junit.Assert;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class GitTestCaseJUnitBlock
extends AbstractCompareTestCaseJUnitBlock {
    private GitMergeStrategyID mergeStrategy;

    public GitTestCaseJUnitBlock(Class<?> klass, ResolutionStrategyID resolutionStrategy, EMFCompareTestConfiguration configuration, GitMergeStrategyID mergeStrategy) throws InitializationError {
        super(klass, resolutionStrategy, configuration);
        this.mergeStrategy = mergeStrategy;
    }

    protected List<FrameworkMethod> computeTestMethods() {
        ArrayList allMethods = Lists.newArrayList((Iterable)this.getTestClass().getAnnotatedMethods(GitCompare.class));
        allMethods.addAll(this.getTestClass().getAnnotatedMethods(GitMerge.class));
        allMethods.addAll(this.getTestClass().getAnnotatedMethods(GitCherryPick.class));
        allMethods.addAll(this.getTestClass().getAnnotatedMethods(GitRebase.class));
        allMethods.addAll(this.getTestClass().getAnnotatedMethods(GitTest.class));
        return allMethods;
    }

    protected Statement methodBlock(FrameworkMethod method) {
        Object testObject = null;
        try {
            testObject = this.createTest();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        GitInput input = (GitInput)method.getAnnotation(GitInput.class);
        AbstractGitStatement result = null;
        if (input != null) {
            if (method.getAnnotation(GitCompare.class) != null) {
                result = new GitCompareStatement(testObject, method, this.resolutionStrategy, this.configuration, input.value());
            } else if (method.getAnnotation(GitMerge.class) != null) {
                result = new GitMergeStatement(testObject, method, this.resolutionStrategy, this.configuration, this.mergeStrategy, input.value());
            } else if (method.getAnnotation(GitCherryPick.class) != null) {
                result = new GitCherryPickStatement(testObject, method, this.resolutionStrategy, this.configuration, this.mergeStrategy, input.value());
            } else if (method.getAnnotation(GitRebase.class) != null) {
                result = new GitRebaseStatement(testObject, method, this.resolutionStrategy, this.configuration, this.mergeStrategy, input.value());
            } else if (method.getAnnotation(GitTest.class) != null) {
                result = new GitTestStatement(testObject, method, this.resolutionStrategy, this.configuration, input.value());
            }
        }
        return result;
    }
}

