/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.internal.postprocessor;

import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diff.DiffBuilder;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.compare.ide.internal.utils.StoragePathAdapter;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EgitPostProcessor
implements IPostProcessor {
    private IDiffProcessor diffProcessor;

    public EgitPostProcessor() {
        this((IDiffProcessor)new DiffBuilder());
    }

    public EgitPostProcessor(IDiffProcessor processor) {
        this.diffProcessor = processor;
    }

    public void postMatch(Comparison comparison, Monitor monitor) {
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
        for (Match rootMatch : comparison.getMatches()) {
            this.checkForDifferences(rootMatch, monitor);
        }
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
    }

    protected IDiffProcessor getDiffProcessor() {
        return this.diffProcessor;
    }

    protected void checkForDifferences(Match match, Monitor monitor) {
        this.checkResourceAttachment(match, monitor);
        for (Match subMatch : match.getSubmatches()) {
            this.checkForDifferences(subMatch, monitor);
        }
    }

    protected void checkResourceAttachment(Match match, Monitor monitor) {
        Comparison comparison = match.getComparison();
        if (comparison.getMatchedResources().isEmpty()) {
            return;
        }
        EObject left = match.getLeft();
        EObject right = match.getRight();
        boolean threeWay = comparison.isThreeWay();
        if (threeWay) {
            String uri;
            EObject origin = match.getOrigin();
            if (!this.isLocalComparison(left, origin) && !this.haveSameResourceURI(left, origin)) {
                uri = left.eResource().getURI().toString();
                this.getDiffProcessor().resourceAttachmentChange(match, uri, DifferenceKind.MOVE, DifferenceSource.LEFT);
            }
            if (!this.isLocalComparison(right, origin) && !this.haveSameResourceURI(right, origin)) {
                uri = right.eResource().getURI().toString();
                this.getDiffProcessor().resourceAttachmentChange(match, uri, DifferenceKind.MOVE, DifferenceSource.RIGHT);
            }
        } else if (!this.isLocalComparison(left, right) && !this.haveSameResourceURI(left, right)) {
            String uri = right.eResource().getURI().toString();
            this.getDiffProcessor().resourceAttachmentChange(match, uri, DifferenceKind.MOVE, DifferenceSource.LEFT);
        }
    }

    protected boolean isLocalComparison(EObject left, EObject right) {
        Adapter rightAdapter;
        Adapter leftAdapter;
        Resource leftResource = left != null ? left.eResource() : null;
        Resource rightResource = right != null ? right.eResource() : null;
        boolean leftIsLocal = true;
        boolean rightIsLocal = true;
        if (leftResource != null && (leftAdapter = EcoreUtil.getAdapter((List)leftResource.eAdapters(), StoragePathAdapter.class)) instanceof StoragePathAdapter) {
            leftIsLocal = ((StoragePathAdapter)leftAdapter).isLocal();
        }
        if (rightResource != null && (rightAdapter = EcoreUtil.getAdapter((List)rightResource.eAdapters(), StoragePathAdapter.class)) instanceof StoragePathAdapter) {
            rightIsLocal = ((StoragePathAdapter)rightAdapter).isLocal();
        }
        return leftIsLocal && rightIsLocal;
    }

    protected boolean haveSameResourceURI(EObject left, EObject right) {
        URI uri;
        Resource.Internal leftResource = left instanceof InternalEObject ? ((InternalEObject)left).eDirectResource() : null;
        Resource.Internal rightResource = right instanceof InternalEObject ? ((InternalEObject)right).eDirectResource() : null;
        String leftURI = leftResource != null ? ((uri = leftResource.getURI()).isPlatform() ? uri.toPlatformString(true) : (uri.isFile() ? uri.toFileString() : uri.toString())) : null;
        String rightURI = rightResource != null ? ((uri = rightResource.getURI()).isPlatform() ? uri.toPlatformString(true) : (uri.isFile() ? uri.toFileString() : uri.toString())) : null;
        return leftURI == null || rightURI == null || leftURI.equals(rightURI);
    }
}

