/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.CachedResourceVariant;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.ui.IEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamAccessorStorage
implements IStorage {
    private final IStreamContentAccessor accessor;
    private final String fullPath;

    public StreamAccessorStorage(IStreamContentAccessor accessor, String fullPath) {
        this.accessor = accessor;
        this.fullPath = fullPath;
    }

    public static StreamAccessorStorage fromTypedElement(ITypedElement element) throws IllegalArgumentException {
        String fullPath;
        if (!(element instanceof IStreamContentAccessor)) {
            throw new IllegalArgumentException();
        }
        IFile file = StreamAccessorStorage.findFile(element);
        if (file != null) {
            fullPath = file.getFullPath().toString();
        } else {
            IFileRevision revision = StreamAccessorStorage.findFileRevision(element);
            String tmp = null;
            if (revision != null) {
                IResourceVariant variant;
                URI uri = revision.getURI();
                if (uri != null) {
                    tmp = uri.toString();
                } else if (revision instanceof IAdaptable && (variant = (IResourceVariant)((IAdaptable)revision).getAdapter(IResourceVariant.class)) instanceof CachedResourceVariant) {
                    tmp = ((CachedResourceVariant)variant).getDisplayPath().toString();
                }
            }
            fullPath = tmp != null ? tmp : element.getName();
        }
        return new StreamAccessorStorage((IStreamContentAccessor)element, fullPath);
    }

    public Object getAdapter(Class adapter) {
        StreamAccessorStorage adapted = null;
        if (adapter.isInstance(this)) {
            adapted = this;
        } else if (adapter == IStreamContentAccessor.class) {
            adapted = this.accessor;
        } else if (this.accessor instanceof ITypedElement) {
            if (adapter == ITypedElement.class) {
                adapted = this.accessor;
            } else if (adapter.isAssignableFrom(IFile.class)) {
                adapted = StreamAccessorStorage.findFile((ITypedElement)this.accessor);
            }
        }
        return adapted;
    }

    public InputStream getContents() throws CoreException {
        return this.accessor.getContents();
    }

    public IPath getFullPath() {
        return new Path(this.fullPath);
    }

    public String getName() {
        if (this.accessor instanceof ITypedElement) {
            return ((ITypedElement)this.accessor).getName();
        }
        return this.getFullPath().lastSegment();
    }

    public boolean isReadOnly() {
        File file;
        if (this.accessor instanceof ITypedElement && (file = StreamAccessorStorage.findFile((ITypedElement)this.accessor)) != null) {
            return file.isReadOnly();
        }
        file = this.getFullPath().toFile();
        return !file.exists() || !file.canWrite();
    }

    private static IFile findFile(ITypedElement element) {
        if (element == null) {
            return null;
        }
        IResource resource = StreamAccessorStorage.adaptAs(element, IResource.class);
        if (resource == null && element instanceof IResourceProvider) {
            resource = ((IResourceProvider)element).getResource();
        }
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return StreamAccessorStorage.adaptAs(element, IFile.class);
    }

    private static IFileRevision findFileRevision(ITypedElement element) {
        IEditorInput editorInput;
        ISharedDocumentAdapter documentAdapter;
        if (element == null) {
            return null;
        }
        IFileRevision revision = StreamAccessorStorage.adaptAs(element, IFileRevision.class);
        if (revision == null && (documentAdapter = StreamAccessorStorage.adaptAs(element, ISharedDocumentAdapter.class)) != null && (editorInput = documentAdapter.getDocumentKey((Object)element)) != null) {
            revision = StreamAccessorStorage.adaptAs(editorInput, IFileRevision.class);
        }
        if (revision == null) {
            try {
                Method method = element.getClass().getMethod("getFileRevision", new Class[0]);
                Object value = method.invoke((Object)element, new Object[0]);
                if (value instanceof IFileRevision) {
                    revision = (IFileRevision)value;
                }
            }
            catch (Exception exception) {}
        }
        return revision;
    }

    private static <T> T adaptAs(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        Object result = null;
        if (clazz.isInstance(object)) {
            result = object;
        } else if (object instanceof IAdaptable) {
            result = ((IAdaptable)object).getAdapter(clazz);
        }
        if (result == null) {
            result = Platform.getAdapterManager().getAdapter(object, clazz);
        }
        return (T)result;
    }
}

