/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.annotations.Beta;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.IStorageProvider;
import org.eclipse.emf.compare.ide.ui.internal.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.utils.StorageURIConverter;
import org.eclipse.emf.ecore.resource.URIConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class RevisionedURIConverter
extends StorageURIConverter {
    private IStorageProviderAccessor storageAccessor;
    private IStorageProviderAccessor.DiffSide side;

    public RevisionedURIConverter(URIConverter delegate, IStorageProviderAccessor storageAccessor, IStorageProviderAccessor.DiffSide side) {
        super(delegate);
        this.storageAccessor = storageAccessor;
        this.side = side;
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        InputStream stream = null;
        URI normalizedUri = this.normalize(uri);
        if (normalizedUri.isPlatformPlugin() || normalizedUri.toString().matches("(\\.\\./)+?plugins/.*")) {
            stream = super.createInputStream(normalizedUri, options);
        } else {
            IFile targetFile;
            if (normalizedUri.isPlatform()) {
                Path platformString = new Path(normalizedUri.trimFragment().toPlatformString(true));
                IFile temp = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)platformString);
                targetFile = !temp.exists() && normalizedUri.isPlatformResource() && platformString.segmentCount() > 1 ? ResourcesPlugin.getWorkspace().getRoot().getFile(platformString.removeFirstSegments(1)) : temp;
            } else {
                targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(normalizedUri.trimFragment().toString()));
            }
            if (targetFile != null) {
                stream = this.openRevisionStream((IResource)targetFile);
            }
            if (stream == null) {
                return super.createInputStream(uri, options);
            }
        }
        return stream;
    }

    private InputStream openRevisionStream(IResource targetFile) {
        if (this.storageAccessor != null) {
            try {
                IStorageProvider provider = this.storageAccessor.getStorageProvider(targetFile, this.side);
                if (provider != null) {
                    IStorage storage = provider.getStorage((IProgressMonitor)new NullProgressMonitor());
                    this.getLoadedRevisions().add(storage);
                    return storage.getContents();
                }
            }
            catch (CoreException e) {
                RevisionedURIConverter.logError((Exception)((Object)e));
            }
        }
        return null;
    }

    private static void logError(Exception e) {
        Status status = new Status(4, "org.eclipse.emf.compare.ide.ui", e.getMessage(), (Throwable)e);
        EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)status);
    }
}

