/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAttachmentChangeMergeViewerItem
extends MergeViewerItem.Container {
    public ResourceAttachmentChangeMergeViewerItem(Comparison comparison, Diff diff, Resource left, Resource right, Resource ancestor, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
        super(comparison, diff, left, right, ancestor, side, adapterFactory);
    }

    public ResourceAttachmentChangeMergeViewerItem(Comparison comparison, Diff diff, Match match, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
        super(comparison, diff, match, side, adapterFactory);
    }

    @Override
    public IMergeViewerItem[] getChildren() {
        Object sideValue = this.getSideValue(this.getSide());
        Object bestSideValue = this.getBestSideValue();
        ArrayList ret = Lists.newArrayList();
        if (bestSideValue instanceof Resource) {
            List<Object> mergeViewerItems = Lists.newArrayList();
            if (sideValue instanceof Resource) {
                mergeViewerItems = this.createMergeViewerItemFrom((Collection<?>)((Resource)sideValue).getContents());
            }
            if (this.getSide() != IMergeViewer.MergeViewerSide.ANCESTOR) {
                EList differences = this.getComparison().getDifferences();
                ArrayList racs = Lists.newArrayList((Iterable)Iterables.filter((Iterable)differences, ResourceAttachmentChange.class));
                ArrayList resourceAttachmentChanges = Lists.newArrayList((Iterable)racs);
                Object left = this.getLeft();
                Object right = this.getRight();
                Object ancestor = this.getAncestor();
                for (ResourceAttachmentChange resourceAttachmentChange : racs) {
                    if (left != null && (!(left instanceof Resource) || resourceAttachmentChange.getResourceURI().equals(((Resource)left).getURI().toString())) || right != null && (!(right instanceof Resource) || resourceAttachmentChange.getResourceURI().equals(((Resource)right).getURI().toString())) || ancestor != null && (!(ancestor instanceof Resource) || resourceAttachmentChange.getResourceURI().equals(((Resource)ancestor).getURI().toString()))) continue;
                    resourceAttachmentChanges.remove(resourceAttachmentChange);
                }
                ret.addAll(this.createInsertionPoints(mergeViewerItems, resourceAttachmentChanges));
            } else {
                ret.addAll(mergeViewerItems);
            }
        }
        return ret.toArray(ResourceAttachmentChangeMergeViewerItem.getNoItemsArr());
    }

    @Override
    protected IMergeViewerItem createMergeViewerItemFrom(EObject eObject) {
        Match match = this.getComparison().getMatch(eObject);
        if (match != null) {
            ResourceAttachmentChange rac = (ResourceAttachmentChange)Iterables.getFirst((Iterable)Iterables.filter((Iterable)match.getDifferences(), ResourceAttachmentChange.class), null);
            return new MergeViewerItem.Container(this.getComparison(), (Diff)rac, match, this.getSide(), this.getAdapterFactory());
        }
        return null;
    }

    private List<? extends IMergeViewerItem> createInsertionPoints(List<? extends IMergeViewerItem> values, List<ResourceAttachmentChange> racs) {
        ArrayList ret = Lists.newArrayList(values);
        for (ResourceAttachmentChange diff : Lists.reverse(racs)) {
            boolean b5;
            boolean rightToLeft = this.getSide() == IMergeViewer.MergeViewerSide.LEFT;
            Comparison comparison = this.getComparison();
            Object left = MergeViewerUtil.getValueFromResourceAttachmentChange(diff, comparison, IMergeViewer.MergeViewerSide.LEFT);
            Object right = MergeViewerUtil.getValueFromResourceAttachmentChange(diff, comparison, IMergeViewer.MergeViewerSide.RIGHT);
            boolean b1 = diff.getSource() == DifferenceSource.LEFT && diff.getKind() == DifferenceKind.DELETE && this.getSide() == IMergeViewer.MergeViewerSide.LEFT;
            boolean b2 = diff.getSource() == DifferenceSource.LEFT && diff.getKind() == DifferenceKind.ADD && this.getSide() == IMergeViewer.MergeViewerSide.RIGHT;
            boolean b3 = diff.getSource() == DifferenceSource.RIGHT && diff.getKind() == DifferenceKind.ADD && this.getSide() == IMergeViewer.MergeViewerSide.LEFT;
            boolean b4 = diff.getSource() == DifferenceSource.RIGHT && diff.getKind() == DifferenceKind.DELETE && this.getSide() == IMergeViewer.MergeViewerSide.RIGHT;
            boolean bl = b5 = diff.getConflict() == null || diff.getConflict().getKind() != ConflictKind.PSEUDO || diff.getKind() == DifferenceKind.DELETE;
            if (!b1 && !b2 && !b3 && !b4 || !b5) continue;
            Object ancestor = MergeViewerUtil.getValueFromResourceAttachmentChange(diff, comparison, IMergeViewer.MergeViewerSide.ANCESTOR);
            if (left != null && MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.LEFT, (Diff)diff) == null) {
                left = null;
            }
            if (right != null && MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.RIGHT, (Diff)diff) == null) {
                right = null;
            }
            if (ancestor != null && MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.ANCESTOR, (Diff)diff) == null) {
                ancestor = null;
            }
            MergeViewerItem.Container insertionPoint = new MergeViewerItem.Container(comparison, (Diff)diff, left, right, ancestor, this.getSide(), this.getAdapterFactory());
            int insertionIndex = left == null && right == null ? MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.ANCESTOR, (Diff)diff).getContents().indexOf(ancestor) : Math.min(this.findInsertionIndex((Diff)diff, rightToLeft), ret.size());
            int realIndex = 0;
            int index = 0;
            while (index < insertionIndex) {
                if (!((IMergeViewerItem)ret.get(realIndex)).isInsertionPoint()) {
                    ++index;
                }
                ++realIndex;
            }
            ret.add(realIndex, insertionPoint);
        }
        return ret;
    }

    private int findInsertionIndex(Diff diff, boolean rightToLeft) {
        Resource expectedResource;
        Resource initialResource;
        Match valueMatch = diff.getMatch();
        Comparison comparison = this.getComparison();
        EObject expectedValue = valueMatch.getLeft() != null ? valueMatch.getLeft() : valueMatch.getRight();
        if (rightToLeft) {
            initialResource = MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.RIGHT, diff);
            expectedResource = MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.LEFT, diff);
        } else {
            initialResource = MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.LEFT, diff);
            expectedResource = MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.RIGHT, diff);
        }
        if (expectedResource != null) {
            EList sourceList = initialResource.getContents();
            EList targetList = expectedResource.getContents();
            return DiffUtil.findInsertionIndex((Comparison)comparison, (List)sourceList, (List)targetList, (Object)expectedValue);
        }
        return 0;
    }
}

