/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedImage;

public class OverlayImageProvider {
    private final ResourceLocator fResourceLocator;

    public OverlayImageProvider(ResourceLocator resourceLocator) {
        this.fResourceLocator = resourceLocator;
    }

    public Object getComposedImage(Diff diff, Object imageToCompose) {
        String overlay = this.getImageOverlay(diff);
        return this.getComposedImage(imageToCompose, overlay);
    }

    public Object getComposedImage(Match match, Object imageToCompose) {
        String overlay = this.getImageOverlay(match);
        return this.getComposedImage(imageToCompose, overlay);
    }

    private Object getComposedImage(Object imageToCompose, String overlay) {
        ArrayList images = Lists.newArrayList();
        images.add(imageToCompose);
        if (overlay != null) {
            Object image = this.fResourceLocator.getImage(overlay);
            images.add(image);
        }
        return new ComposedImageExtension(images);
    }

    private String getImageOverlay(Diff diff) {
        DifferenceSource source = diff.getSource();
        Match match = diff.getMatch();
        Conflict conflict = diff.getConflict();
        DifferenceKind diffKind = diff.getKind();
        Comparison comparison = match.getComparison();
        String path = "full/ovr16/";
        if (diff.getState() == DifferenceState.MERGED) {
            path = String.valueOf(path) + "merged_ov";
        } else if (diff.getState() == DifferenceState.DISCARDED) {
            path = String.valueOf(path) + "removed_ov";
        } else if (comparison.isThreeWay()) {
            String extension = "";
            if (conflict != null && conflict.getKind() == ConflictKind.REAL) {
                extension = ".png";
                path = String.valueOf(path) + "conf";
                if (source == DifferenceSource.RIGHT) {
                    path = String.valueOf(path) + "r_";
                }
            } else {
                switch (source) {
                    case LEFT: {
                        path = String.valueOf(path) + "r_out";
                        break;
                    }
                    case RIGHT: {
                        path = String.valueOf(path) + "r_in";
                        break;
                    }
                }
            }
            switch (diffKind) {
                case ADD: {
                    path = String.valueOf(path) + "add_ov";
                    break;
                }
                case DELETE: {
                    path = String.valueOf(path) + "del_ov";
                    break;
                }
                case CHANGE: 
                case MOVE: {
                    path = String.valueOf(path) + "chg_ov";
                    break;
                }
            }
            path = String.valueOf(path) + extension;
        } else {
            switch (diffKind) {
                case ADD: {
                    path = String.valueOf(path) + "add_ov";
                    break;
                }
                case DELETE: {
                    path = String.valueOf(path) + "del_ov";
                    break;
                }
                case CHANGE: 
                case MOVE: {
                    path = String.valueOf(path) + "chg_ov";
                    break;
                }
            }
        }
        return path;
    }

    private String getImageOverlay(Match match) {
        String path = null;
        EObject ancestor = match.getOrigin();
        EObject left = match.getLeft();
        EObject right = match.getRight();
        Iterable differences = match.getAllDifferences();
        if (match.getComparison().isThreeWay()) {
            if (Iterables.any((Iterable)differences, (Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}))) {
                path = "confinoutchg_ov.png";
            } else if (ancestor == null) {
                if (right == null) {
                    path = "r_outadd_ov";
                } else if (left == null) {
                    path = "r_inadd_ov";
                }
            } else if (left == null) {
                if (right != null) {
                    path = "r_outdel_ov";
                }
            } else if (right == null) {
                path = "r_indel_ov";
            } else {
                boolean hasLeftDiffs = Iterables.any((Iterable)differences, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
                boolean hasRightDiffs = Iterables.any((Iterable)differences, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
                if (hasLeftDiffs && hasRightDiffs) {
                    path = "r_inoutchg_ov";
                } else if (hasLeftDiffs) {
                    path = "r_outchg_ov";
                } else if (hasRightDiffs) {
                    path = "r_inchg_ov";
                }
            }
        } else if (left == null) {
            path = "del_ov";
        } else if (right == null) {
            path = "add_ov";
        } else if (!Iterables.isEmpty((Iterable)differences)) {
            path = "chg_ov";
        }
        String ret = null;
        if (path != null) {
            ret = "full/ovr16/" + path;
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ComposedImageExtension
    extends ComposedImage {
        ComposedImageExtension(Collection<?> images) {
            super(images);
        }

        public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
            List result = super.getDrawPoints(size);
            if (result.size() > 1) {
                ((ComposedImage.Point)result.get((int)1)).x = 12;
                ((ComposedImage.Point)result.get((int)1)).y = 2;
            }
            return result;
        }

        public ComposedImage.Size getSize(Collection<? extends ComposedImage.Size> sizes) {
            this.imageSizes = Lists.newArrayList(sizes);
            List<ComposedImage.Point> drawPoints = this.getDrawPoints(null);
            ComposedImage.Size result = new ComposedImage.Size();
            int i = 0;
            while (i < sizes.size()) {
                ComposedImage.Size size = (ComposedImage.Size)this.imageSizes.get(i);
                ComposedImage.Point point = drawPoints.get(i);
                result.width = Math.max(result.width, size.width + Math.abs(point.x));
                result.height = Math.max(result.height, size.height + Math.abs(point.y));
                ++i;
            }
            return result;
        }
    }
}

