/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl;

import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.ICompareAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.IStructuralFeatureAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl.ResourceContentsAccessorImpl;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.ICompareColorProvider;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.StructuredMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.InsertionPoint;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableMergeViewer
extends StructuredMergeViewer {
    private final ICompareColorProvider fColorProvider;
    private TableViewer fTableViewer;
    private InfoViewer fInfoViewer;

    public TableMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side, ICompareColorProvider colorProvider) {
        super(parent, side);
        this.fColorProvider = colorProvider;
        this.getStructuredViewer().getTable().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                TableMergeViewer.this.handleEraseItemEvent(event);
            }
        });
        this.getStructuredViewer().getTable().addListener(41, (Listener)new ItemResizeListener());
    }

    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = -1;
        layout.marginRight = -1;
        layout.marginTop = -1;
        layout.marginBottom = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.fInfoViewer = new InfoViewer(composite, this.getSide());
        this.fInfoViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.fTableViewer = new TableViewer(composite, 66306);
        this.fTableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        return composite;
    }

    public final int getVerticalOffset() {
        return this.fInfoViewer.getControl().getSize().y - 2;
    }

    public final TableViewer getStructuredViewer() {
        return this.fTableViewer;
    }

    public void setContentProvider(IContentProvider contentProvider) {
        super.setContentProvider(contentProvider);
        this.fInfoViewer.setContentProvider(contentProvider);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        super.setLabelProvider(labelProvider);
        this.fInfoViewer.setLabelProvider(labelProvider);
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.fTableViewer.setInput(input);
        this.fInfoViewer.setInput(input);
        ((Composite)this.getControl()).layout(true);
    }

    private void handleEraseItemEvent(Event event) {
        Diff diff;
        TableItem tableItem = (TableItem)event.item;
        Object data = tableItem.getData();
        if (data instanceof InsertionPoint) {
            InsertionPoint insertionPoint = (InsertionPoint)data;
            this.paintItemDiffBox(event, insertionPoint.getDiff(), TableMergeViewer.getBoundsForInsertionPoint(event));
        } else if (data instanceof IMergeViewerItem && (diff = ((IMergeViewerItem)data).getDiff()) != null) {
            this.paintItemDiffBox(event, diff, TableMergeViewer.getBounds(event));
        }
    }

    private void paintItemDiffBox(Event event, Diff diff, Rectangle bounds) {
        event.detail &= 0xFFFFFFDF;
        if (diff != null && (diff.getState() == DifferenceState.DISCARDED || diff.getState() == DifferenceState.MERGED)) {
            return;
        }
        GC g = event.gc;
        Color oldBackground = g.getBackground();
        Color oldForeground = g.getForeground();
        this.setDiffColorsToGC(g, diff, TableMergeViewer.isSelected(event));
        g.fillRectangle(bounds);
        g.drawRectangle(bounds);
        if (this.getSide() == IMergeViewer.MergeViewerSide.LEFT) {
            this.drawLineFromBoxToCenter(event, bounds, g);
        } else {
            this.drawLineFromCenterToBox(event, bounds, g);
        }
        if (TableMergeViewer.isSelected(event)) {
            g.setForeground(event.display.getSystemColor(24));
            g.setBackground(event.display.getSystemColor(25));
            event.detail &= 0xFFFFFFFD;
        } else {
            g.setBackground(oldBackground);
            g.setForeground(oldForeground);
        }
    }

    private void drawLineFromCenterToBox(Event event, Rectangle boxBounds, GC g) {
        TableItem tableItem = (TableItem)event.item;
        Rectangle itemBounds = tableItem.getBounds();
        Point from = new Point(0, 0);
        from.y = itemBounds.y + itemBounds.height / 2;
        Point to = new Point(boxBounds.x, from.y);
        g.drawLine(from.x, from.y, to.x, to.y);
    }

    private void drawLineFromBoxToCenter(Event event, Rectangle boxBounds, GC g) {
        TableItem tableItem = (TableItem)event.item;
        Rectangle itemBounds = tableItem.getBounds();
        Rectangle clientArea = tableItem.getParent().getClientArea();
        Point from = new Point(0, 0);
        from.x = boxBounds.x + boxBounds.width;
        from.y = itemBounds.y + itemBounds.height / 2;
        Point to = new Point(0, from.y);
        to.x = clientArea.x + clientArea.width;
        g.drawLine(from.x, from.y, to.x, to.y);
    }

    static boolean isSelected(Event event) {
        return (event.detail & 2) != 0;
    }

    private static Rectangle getBounds(Event event) {
        int width;
        TableItem tableItem = (TableItem)event.item;
        Table table = tableItem.getParent();
        Rectangle tableBounds = table.getClientArea();
        Rectangle itemBounds = tableItem.getBounds();
        Rectangle fill = new Rectangle(0, 0, 0, 0);
        fill.x = 2;
        fill.y = itemBounds.y + 2;
        fill.width = itemBounds.width + itemBounds.x;
        fill.height = itemBounds.height - 3;
        GC g = event.gc;
        int columnCount = table.getColumnCount();
        if ((event.index == columnCount - 1 || columnCount == 0) && (width = tableBounds.x + tableBounds.width - event.x) > 0) {
            Region region = new Region();
            g.getClipping(region);
            region.add(event.x, event.y, width, event.height);
            g.setClipping(region);
            region.dispose();
        }
        g.setAdvanced(true);
        return fill;
    }

    private static Rectangle getBoundsForInsertionPoint(Event event) {
        Rectangle fill = TableMergeViewer.getBounds(event);
        TableItem tableItem = (TableItem)event.item;
        Rectangle tableBounds = tableItem.getParent().getClientArea();
        fill.y += 6;
        fill.width = tableBounds.width / 4;
        fill.height -= 12;
        return fill;
    }

    private void setDiffColorsToGC(GC g, Diff diff, boolean selected) {
        boolean isThreeWay = false;
        if (this.getInput() instanceof ICompareAccessor) {
            Comparison comparison = ((ICompareAccessor)this.getInput()).getComparison();
            isThreeWay = comparison.isThreeWay();
        }
        g.setForeground(this.fColorProvider.getCompareColor().getStrokeColor(diff, isThreeWay, false, selected));
        g.setBackground(this.fColorProvider.getCompareColor().getFillColor(diff, isThreeWay, false, selected));
    }

    public void refresh() {
        this.fInfoViewer.refresh();
        this.fTableViewer.refresh();
    }

    private static class InfoViewer
    extends ContentViewer {
        private final IMergeViewer.MergeViewerSide fSide;
        private final Composite fControl;
        private final Label fEObjectIcon;
        private final Label fEObjectLabel;
        private final Label fFeatureIcon;
        private final Label fFeatureLabel;
        private ISelection fSelection;
        private Object fInput;

        public InfoViewer(Composite parent, IMergeViewer.MergeViewerSide side) {
            this.fControl = new Composite(parent, 2048);
            this.fSide = side;
            this.fControl.setBackground(parent.getDisplay().getSystemColor(25));
            GridLayout layout = new GridLayout(3, false);
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;
            layout.marginLeft = 1;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginBottom = 0;
            this.fControl.setLayout((Layout)layout);
            Composite eObjectComposite = new Composite(this.fControl, 0);
            GridLayout eObjectCompositelayout = new GridLayout(2, false);
            eObjectCompositelayout.verticalSpacing = 0;
            eObjectCompositelayout.horizontalSpacing = 0;
            eObjectCompositelayout.marginLeft = 0;
            eObjectCompositelayout.marginHeight = 0;
            eObjectCompositelayout.marginWidth = 0;
            eObjectCompositelayout.marginBottom = 0;
            eObjectComposite.setLayout((Layout)eObjectCompositelayout);
            this.fEObjectIcon = new Label(eObjectComposite, 0);
            this.fEObjectIcon.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.fEObjectLabel = new Label(eObjectComposite, 0);
            this.fEObjectLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            eObjectComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, true, 3, 1));
            Label lblIn = new Label(this.fControl, 0);
            lblIn.setText("    ");
            this.fFeatureIcon = new Label(this.fControl, 0);
            this.fFeatureIcon.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.fFeatureLabel = new Label(this.fControl, 0);
            this.fFeatureLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.hookControl((Control)this.fControl);
        }

        public Control getControl() {
            return this.fControl;
        }

        protected void inputChanged(Object input, Object oldInput) {
            this.fInput = input;
            this.fControl.setRedraw(false);
            try {
                this.refresh();
            }
            finally {
                this.fControl.setRedraw(true);
            }
        }

        public ISelection getSelection() {
            return this.fSelection;
        }

        public void refresh() {
            if (this.fInput instanceof IStructuralFeatureAccessor) {
                IStructuralFeatureAccessor featureAccessor = (IStructuralFeatureAccessor)this.fInput;
                EObject eObject = featureAccessor.getEObject(this.fSide);
                if (eObject == null) {
                    if (this.fSide != IMergeViewer.MergeViewerSide.ANCESTOR) {
                        eObject = featureAccessor.getEObject(IMergeViewer.MergeViewerSide.ANCESTOR);
                        if (eObject == null) {
                            eObject = featureAccessor.getEObject(this.fSide.opposite());
                        }
                    } else {
                        eObject = featureAccessor.getEObject(IMergeViewer.MergeViewerSide.LEFT);
                        if (eObject == null) {
                            eObject = featureAccessor.getEObject(IMergeViewer.MergeViewerSide.RIGHT);
                        }
                    }
                }
                EStructuralFeature structuralFeature = featureAccessor.getStructuralFeature();
                if (this.getLabelProvider() instanceof ILabelProvider) {
                    ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
                    this.fFeatureIcon.setImage(labelProvider.getImage((Object)structuralFeature));
                    this.fFeatureLabel.setText(labelProvider.getText((Object)structuralFeature));
                    this.fEObjectIcon.setImage(labelProvider.getImage((Object)eObject));
                    this.fEObjectLabel.setText(labelProvider.getText((Object)eObject));
                }
                this.fControl.layout(true);
            } else if (this.fInput instanceof ResourceContentsAccessorImpl) {
                ResourceContentsAccessorImpl resourceContentAccessor = (ResourceContentsAccessorImpl)this.fInput;
                Resource resource = resourceContentAccessor.getResource(this.fSide);
                if (this.getLabelProvider() instanceof ILabelProvider) {
                    ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
                    this.fFeatureLabel.setText("resource contents");
                    this.fEObjectIcon.setImage(labelProvider.getImage((Object)resource));
                    this.fEObjectLabel.setText(labelProvider.getText((Object)resource));
                }
                this.fControl.layout(true);
            }
        }

        public void setSelection(ISelection selection, boolean reveal) {
            this.fSelection = selection;
        }
    }

    private static class ItemResizeListener
    implements Listener {
        private Widget fLastWidget;
        private int fLastHeight;

        private ItemResizeListener() {
        }

        public void handleEvent(Event event) {
            if (event.item == this.fLastWidget && event.height == this.fLastHeight) {
                return;
            }
            this.fLastWidget = event.item;
            this.fLastHeight = event.height;
            int newHeight = (int)((double)event.gc.getFontMetrics().getHeight() * 1.33);
            if ((newHeight & 1) == 1) {
                ++newHeight;
            }
            event.height = newHeight;
        }
    }
}

