/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.logical;

import com.google.common.annotations.Beta;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.utils.StorageURIConverter;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.core.history.IFileRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class RevisionedURIConverter
extends StorageURIConverter {
    private IFileRevision baseRevision;
    private IFile baseFile;
    private long maxTimestamp = -2L;

    public RevisionedURIConverter(URIConverter delegate, IFileRevision baseRevision) {
        super(delegate);
        this.baseRevision = baseRevision;
        this.baseFile = this.findFile(this.getFileURI(baseRevision).toString());
        try {
            this.getLoadedRevisions().add(baseRevision.getStorage((IProgressMonitor)new NullProgressMonitor()));
        }
        catch (CoreException coreException) {}
        RepositoryProvider repositoryProvider = RepositoryProvider.getProvider((IProject)this.baseFile.getProject());
        if (repositoryProvider == null) {
            return;
        }
        IFileHistoryProvider historyProvider = repositoryProvider.getFileHistoryProvider();
        IFileHistory history = historyProvider.getFileHistoryFor((IResource)this.baseFile, 0, (IProgressMonitor)new NullProgressMonitor());
        if (history != null) {
            IFileRevision[] revisions = history.getFileRevisions();
            String baseID = baseRevision.getContentIdentifier();
            int i = 0;
            while (i < revisions.length && this.maxTimestamp == -2L) {
                if (baseID.equals(revisions[i].getContentIdentifier())) {
                    this.maxTimestamp = i == 0 ? -1L : revisions[i - 1].getTimestamp();
                }
                ++i;
            }
        }
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        InputStream stream = null;
        URI normalizedUri = this.normalize(uri);
        if (normalizedUri.isPlatformPlugin() || normalizedUri.toString().matches("(\\.\\./)+?plugins/.*")) {
            stream = super.createInputStream(normalizedUri, options);
        } else {
            IFile targetFile;
            if (normalizedUri.isPlatform()) {
                Path platformString = new Path(normalizedUri.trimFragment().toPlatformString(true));
                IFile temp = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)platformString);
                targetFile = !temp.exists() && normalizedUri.isPlatformResource() && platformString.segmentCount() > 1 ? ResourcesPlugin.getWorkspace().getRoot().getFile(platformString.removeFirstSegments(1)) : temp;
            } else {
                targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(normalizedUri.trimFragment().toString()));
            }
            if (targetFile != null) {
                stream = this.openRevisionStream((IResource)targetFile);
            }
            if (stream == null) {
                return super.createInputStream(uri, options);
            }
        }
        return stream;
    }

    private InputStream openRevisionStream(IResource targetFile) {
        IFileHistoryProvider historyProvider;
        IFileHistory history;
        IResource actualFile = targetFile;
        if (!actualFile.exists() && (actualFile = this.findFile(actualFile.getFullPath().toString())) == null) {
            actualFile = targetFile;
        }
        InputStream stream = null;
        RepositoryProvider repositoryProvider = RepositoryProvider.getProvider((IProject)actualFile.getProject());
        if (repositoryProvider != null && (history = (historyProvider = repositoryProvider.getFileHistoryProvider()).getFileHistoryFor(actualFile, 0, (IProgressMonitor)new NullProgressMonitor())) != null) {
            IFileRevision soughtRevision = null;
            IFileRevision[] revisions = history.getFileRevisions();
            int i = 0;
            while (i < revisions.length && soughtRevision == null) {
                IFileRevision revision = revisions[i];
                if (this.maxTimestamp < 0L || revision.getTimestamp() < this.maxTimestamp) {
                    soughtRevision = revision;
                }
                ++i;
            }
            if (soughtRevision != null) {
                try {
                    IStorage storage = soughtRevision.getStorage((IProgressMonitor)new NullProgressMonitor());
                    this.getLoadedRevisions().add(storage);
                    stream = storage.getContents();
                }
                catch (CoreException e) {
                    RevisionedURIConverter.logError((Exception)((Object)e));
                }
            }
        }
        if (stream == null) {
            try {
                IFileState soughtState = null;
                IFileState[] revisions = ((IFile)actualFile).getHistory((IProgressMonitor)new NullProgressMonitor());
                int i = 0;
                while (i < revisions.length && soughtState == null) {
                    IFileState revision = revisions[i];
                    if (this.maxTimestamp < 0L || revision.getModificationTime() < this.maxTimestamp) {
                        soughtState = revision;
                    }
                    ++i;
                }
                if (soughtState != null) {
                    this.getLoadedRevisions().add(soughtState);
                    stream = soughtState.getContents();
                } else {
                    this.getLoadedRevisions().add((IFile)actualFile);
                    stream = ((IFile)actualFile).getContents();
                }
            }
            catch (CoreException e) {
                RevisionedURIConverter.logError((Exception)((Object)e));
            }
        }
        return stream;
    }

    private IFile findFile(String path) {
        java.net.URI targetURI;
        java.net.URI baseURI = this.getFileURI(this.baseRevision);
        java.net.URI relativizedURI = baseURI.relativize(targetURI = this.convertToURI(path));
        Path relativizedPath = relativizedURI.getPath().length() == 0 ? new Path(targetURI.getPath()) : new Path(relativizedURI.getPath());
        String[] pathSegments = relativizedPath.segments();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject container = null;
        int projectIndex = 0;
        while (!(projectIndex >= pathSegments.length || container != null && container.exists())) {
            container = root.getProject(pathSegments[projectIndex]);
            ++projectIndex;
        }
        IFile file = null;
        if (container != null && container.exists()) {
            IPath filePath = relativizedPath.removeFirstSegments(projectIndex);
            file = container.getFile(filePath);
        }
        return file;
    }

    private java.net.URI getFileURI(IFileRevision revision) {
        java.net.URI baseURI = revision.getURI();
        if (baseURI != null) {
            return baseURI;
        }
        java.net.URI result = null;
        try {
            int nameIndex;
            IStorage storage = revision.getStorage((IProgressMonitor)new NullProgressMonitor());
            String name = revision.getName();
            IPath path = storage.getFullPath();
            String lastSegment = path.lastSegment();
            if (!lastSegment.equals(name) && (nameIndex = lastSegment.indexOf(name)) != -1) {
                path = path.removeLastSegments(1);
                path = path.append(lastSegment.substring(0, nameIndex + name.length()));
            }
            result = new java.net.URI(path.toString());
        }
        catch (CoreException e) {
            RevisionedURIConverter.logError((Exception)((Object)e));
        }
        catch (URISyntaxException e) {
            RevisionedURIConverter.logError(e);
        }
        return result;
    }

    private java.net.URI convertToURI(String path) {
        try {
            return new java.net.URI(path);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private static void logError(Exception e) {
        Status status = new Status(4, "org.eclipse.emf.compare.ide.ui", e.getMessage(), (Throwable)e);
        EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)status);
    }
}

