/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.accessor.IAccessorFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractEDiffNode
extends AdapterImpl
implements ICompareInput {
    private final ListenerList fListener;
    private final AdapterFactory fAdapterFactory;

    public AbstractEDiffNode(AdapterFactory adapterFactory) {
        this.fAdapterFactory = adapterFactory;
        this.fListener = new ListenerList();
    }

    public boolean isAdapterForType(Object type) {
        return type == this.fAdapterFactory;
    }

    protected final AdapterFactory getAdapterFactory() {
        return this.fAdapterFactory;
    }

    public void addCompareInputChangeListener(ICompareInputChangeListener listener) {
        this.fListener.add((Object)listener);
    }

    public void removeCompareInputChangeListener(ICompareInputChangeListener listener) {
        this.fListener.remove((Object)listener);
    }

    protected void fireChange() {
        if (this.fListener != null) {
            Object[] listeners = this.fListener.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final ICompareInputChangeListener listener = (ICompareInputChangeListener)listeners[i];
                SafeRunnable runnable = new SafeRunnable(){

                    public void run() throws Exception {
                        listener.compareInputChanged((ICompareInput)AbstractEDiffNode.this);
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
                ++i;
            }
        }
    }

    public void copy(boolean leftToRight) {
    }

    protected IAccessorFactory getAccessorFactoryForTarget() {
        IAccessorFactory.Registry factoryRegistry = EMFCompareIDEUIPlugin.getDefault().getAccessorFactoryRegistry();
        return factoryRegistry.getHighestRankingFactory(this.getTarget());
    }

    public Image getImage() {
        Image ret = null;
        Adapter adapter = this.getAdapterFactory().adapt(this.target, IItemLabelProvider.class);
        if (adapter instanceof IItemLabelProvider) {
            Object imageObject = ((IItemLabelProvider)adapter).getImage((Object)this.target);
            ret = ExtendedImageRegistry.getInstance().getImage(imageObject);
        }
        return ret;
    }

    public int getKind() {
        return 0;
    }

    public String getName() {
        String ret = null;
        Adapter adapter = this.getAdapterFactory().adapt(this.target, IItemLabelProvider.class);
        if (adapter instanceof IItemLabelProvider) {
            ret = ((IItemLabelProvider)adapter).getText((Object)this.target);
        }
        return ret;
    }

    public ITypedElement getAncestor() {
        IAccessorFactory accessorFactory = this.getAccessorFactoryForTarget();
        if (accessorFactory != null) {
            return accessorFactory.createAncestor(this.getAdapterFactory(), this.getTarget());
        }
        return null;
    }

    public ITypedElement getLeft() {
        IAccessorFactory accessorFactory = this.getAccessorFactoryForTarget();
        if (accessorFactory != null) {
            return accessorFactory.createLeft(this.getAdapterFactory(), this.getTarget());
        }
        return null;
    }

    public ITypedElement getRight() {
        IAccessorFactory accessorFactory = this.getAccessorFactoryForTarget();
        if (accessorFactory != null) {
            return accessorFactory.createRight(this.getAdapterFactory(), this.getTarget());
        }
        return null;
    }
}

