/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.diff.util;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class GMFLabelUtil {
    private static Map<Diagram, DiagramEditPart> DIAGRAM_EDIT_PARTS = Maps.newHashMap();

    private GMFLabelUtil() {
    }

    public static ITextAwareEditPart getTextEditPart(View view) {
        LabelRequestor labelRequestor = new LabelRequestor(view);
        Display.getDefault().syncExec((Runnable)labelRequestor);
        return labelRequestor.getTextEditPart();
    }

    public static IParser getParser(View view) {
        ParserRequestor parserRequestor = new ParserRequestor(view);
        Display.getDefault().syncExec((Runnable)parserRequestor);
        return parserRequestor.getParser();
    }

    public static void setLabel(View view, String label) {
        LabelSetter labelSetter = new LabelSetter(view, label);
        Display.getDefault().syncExec((Runnable)labelSetter);
    }

    public static void cleanup() {
        for (Map.Entry<Diagram, DiagramEditPart> entry : DIAGRAM_EDIT_PARTS.entrySet()) {
            entry.getValue().deactivate();
        }
        DIAGRAM_EDIT_PARTS.clear();
    }

    private static ITextAwareEditPart findTextAwareEditPart(IGraphicalEditPart parent) {
        ITextAwareEditPart result = null;
        if (parent instanceof ITextAwareEditPart) {
            result = (ITextAwareEditPart)parent;
        } else {
            EditPart primaryChildEditPart = parent.getPrimaryChildEditPart();
            if (primaryChildEditPart instanceof ITextAwareEditPart) {
                return (ITextAwareEditPart)primaryChildEditPart;
            }
            for (Object obj : parent.getChildren()) {
                if (!(obj instanceof ITextAwareEditPart)) continue;
                result = (ITextAwareEditPart)obj;
                break;
            }
        }
        return result;
    }

    public static abstract class AbstractLabelHandling
    implements Runnable {
        protected View view;
        protected String label = "";
        protected ITextAwareEditPart mTextEp;

        public AbstractLabelHandling(View pView) {
            this.view = pView;
        }

        public AbstractLabelHandling(View pView, String pLabel) {
            this.view = pView;
            this.label = pLabel;
        }

        public void run() {
            ITextAwareEditPart textEp;
            Object viewEp;
            DiagramEditPart diagramEditPart;
            Diagram diagram = this.view.getDiagram();
            ResourceSet resourceSet = diagram.eResource().getResourceSet();
            TransactionalEditingDomain ted = TransactionalEditingDomain.Factory.INSTANCE.getEditingDomain(resourceSet);
            if (ted == null) {
                TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(resourceSet);
            }
            if ((diagramEditPart = (DiagramEditPart)DIAGRAM_EDIT_PARTS.get(diagram)) == null) {
                Shell shell = null;
                try {
                    shell = new Shell();
                    diagramEditPart = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell);
                    DIAGRAM_EDIT_PARTS.put(diagram, diagramEditPart);
                }
                finally {
                    if (shell != null) {
                        shell.dispose();
                    }
                }
            }
            if (diagramEditPart != null && (viewEp = diagramEditPart.getViewer().getEditPartRegistry().get(this.view)) instanceof IGraphicalEditPart && (textEp = GMFLabelUtil.findTextAwareEditPart((IGraphicalEditPart)viewEp)) != null) {
                this.mTextEp = textEp;
                this.handle(textEp);
            }
        }

        abstract void handle(ITextAwareEditPart var1);

        public ITextAwareEditPart getTextEditPart() {
            return this.mTextEp;
        }
    }

    public static final class LabelRequestor
    extends AbstractLabelHandling {
        public LabelRequestor(View pView) {
            super(pView);
        }

        public String getLabel() {
            return this.label;
        }

        void handle(ITextAwareEditPart editPart) {
            this.label = editPart.getEditText();
        }
    }

    public static final class LabelSetter
    extends AbstractLabelHandling {
        public LabelSetter(View pView, String pLabel) {
            super(pView, pLabel);
        }

        void handle(ITextAwareEditPart editPart) {
            ICommand iCommand = this.getDirectEditCommand(editPart);
            CommandStack stack = editPart.getViewer().getEditDomain().getCommandStack();
            stack.execute((Command)new ICommandProxy(iCommand));
        }

        private ICommand getDirectEditCommand(ITextAwareEditPart textEp) {
            EObject model = (EObject)textEp.getModel();
            EObjectAdapterEx elementAdapter = null;
            if (model instanceof View) {
                View lview = (View)model;
                elementAdapter = new EObjectAdapterEx(ViewUtil.resolveSemanticElement((View)lview), lview);
            } else {
                elementAdapter = new EObjectAdapterEx(model, null);
            }
            return textEp.getParser().getParseCommand((IAdaptable)elementAdapter, this.label, 0);
        }

        class EObjectAdapterEx
        extends EObjectAdapter {
            private View mView;

            public EObjectAdapterEx(EObject element, View pView) {
                super(element);
                this.mView = pView;
            }

            public Object getAdapter(Class adapter) {
                Object result = null;
                Object o = super.getAdapter(adapter);
                if (o != null) {
                    result = o;
                } else if (adapter.equals(View.class)) {
                    result = this.mView;
                }
                return result;
            }
        }
    }

    public static final class ParserRequestor
    extends AbstractLabelHandling {
        private IParser parser;

        public ParserRequestor(View pView) {
            super(pView);
        }

        public IParser getParser() {
            return this.parser;
        }

        void handle(ITextAwareEditPart editPart) {
            this.parser = editPart.getParser();
        }
    }
}

