/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.collect.Iterables;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.actions.group.DifferenceGroup;
import org.eclipse.emf.compare.ide.ui.internal.actions.group.DifferenceGrouper;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.AbstractEDiffContainer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.ComparisonNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class EMFCompareStructureMergeViewerContentProvider
implements ITreeContentProvider {
    private final DifferenceGrouper fDifferenceGrouper;
    private final AdapterFactory fAdapterFactory;

    EMFCompareStructureMergeViewerContentProvider(AdapterFactory adapterFactory, DifferenceGrouper differenceGrouper) {
        this.fAdapterFactory = adapterFactory;
        this.fDifferenceGrouper = differenceGrouper;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object getParent(Object element) {
        Object ret = element instanceof IDiffElement ? ((IDiffElement)element).getParent() : (element instanceof DifferenceGroup ? ((DifferenceGroup)element).getComparison() : null);
        return ret;
    }

    public final boolean hasChildren(Object element) {
        Comparison target;
        Iterable<? extends DifferenceGroup> groups;
        boolean ret = element instanceof ComparisonNode ? (Iterables.isEmpty(groups = this.fDifferenceGrouper.getGroups(target = ((ComparisonNode)((Object)element)).getTarget())) ? this.doHasChildren((ComparisonNode)((Object)element)) : true) : (element instanceof IDiffContainer ? this.doHasChildren((IDiffContainer)element) : (element instanceof DifferenceGroup ? !Iterables.isEmpty(((DifferenceGroup)element).getDifferences()) : false));
        return ret;
    }

    private boolean doHasChildren(IDiffContainer element) {
        return element.hasChildren();
    }

    public final Object[] getChildren(Object element) {
        Object[] ret;
        if (element instanceof ComparisonNode) {
            Comparison target = ((ComparisonNode)((Object)element)).getTarget();
            Iterable<? extends DifferenceGroup> groups = this.fDifferenceGrouper.getGroups(target);
            ret = !Iterables.isEmpty(groups) ? Iterables.toArray(groups, DifferenceGroup.class) : this.doGetChildren((IDiffContainer)element);
        } else if (element instanceof IDiffContainer) {
            ret = this.doGetChildren((IDiffContainer)element);
        } else if (element instanceof DifferenceGroup) {
            Iterable<? extends Diff> differences = ((DifferenceGroup)element).getDifferences();
            Iterable<IDiffElement> diffNodes = AbstractEDiffContainer.adapt(differences, this.fAdapterFactory, IDiffElement.class);
            ret = Iterables.toArray(diffNodes, IDiffElement.class);
        } else {
            ret = new Object[]{};
        }
        return ret;
    }

    private Object[] doGetChildren(IDiffContainer diffContainer) {
        return diffContainer.getChildren();
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }
}

