/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.common.ui.IModelParameterInfo;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.IUriGroup;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.TransformationControls;
import org.eclipse.m2m.internal.qvt.oml.emf.util.StatusUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtValidator;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationSignatureLaunchControl
extends ScrolledComposite {
    private QvtTransformation myTransformation;
    private final ResourceSet myValidationRS;
    private Map<ModelParameterInfo, IUriGroup> myParamGroups = Collections.emptyMap();

    public TransformationSignatureLaunchControl(Composite parent, int style, ResourceSet validationRS) {
        super(parent, style | 0x200);
        this.myValidationRS = validationRS;
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.setAlwaysShowScrollBars(true);
        this.setCompositeLayout((Composite)this);
        this.setTransformation(null, Collections.<IUriGroup.IModifyListener>emptyList());
    }

    public void setTransformation(QvtTransformation transformation, List<IUriGroup.IModifyListener> listeners) {
        this.myTransformation = transformation;
        ArrayList<TargetUriData> oldUriData = new ArrayList<TargetUriData>();
        Control content = this.getContent();
        if (content != null) {
            for (Map.Entry<ModelParameterInfo, IUriGroup> entry : this.myParamGroups.entrySet()) {
                oldUriData.add(entry.getValue().getUriData());
            }
            content.dispose();
        }
        Composite area = new Composite((Composite)this, 0);
        this.setContent((Control)area);
        this.setCompositeLayout(area);
        this.createContents(area, listeners);
        Iterator itrOldUriData = oldUriData.iterator();
        for (Map.Entry<ModelParameterInfo, IUriGroup> entry : this.myParamGroups.entrySet()) {
            if (!itrOldUriData.hasNext()) break;
            entry.getValue().initializeFrom((TargetUriData)itrOldUriData.next());
        }
        Point computeSize = area.computeSize(-1, -1);
        this.setMinSize(computeSize);
        this.setSize(this.getSize().x, computeSize.y);
        area.layout();
        this.getParent().layout();
    }

    public IStatus validate(String moduleName, Shell shell, String traceFilePath, boolean useTrace) {
        for (Map.Entry<ModelParameterInfo, IUriGroup> entry : this.myParamGroups.entrySet()) {
            entry.getValue().update(moduleName, (IModelParameterInfo)entry.getKey(), shell);
        }
        ArrayList<TargetUriData> targetUris = new ArrayList<TargetUriData>(this.myParamGroups.size());
        for (Map.Entry<ModelParameterInfo, IUriGroup> entry : this.myParamGroups.entrySet()) {
            targetUris.add(entry.getValue().getUriData());
        }
        try {
            IStatus status = QvtValidator.validateTransformation((QvtTransformation)this.myTransformation, targetUris, (String)traceFilePath, (boolean)useTrace);
            if (StatusUtil.isError((IStatus)status)) {
                return status;
            }
        }
        catch (Exception e) {
            return StatusUtil.makeErrorStatus((String)e.getMessage(), (Exception)e);
        }
        return StatusUtil.makeOkStatus();
    }

    public void initializeFrom(ILaunchConfiguration configuration) throws CoreException {
        List targetUris = QvtLaunchUtil.getTargetUris((ILaunchConfiguration)configuration);
        int i = 0;
        for (Map.Entry<ModelParameterInfo, IUriGroup> entry : this.myParamGroups.entrySet()) {
            if (i >= targetUris.size()) break;
            entry.getValue().initializeFrom((TargetUriData)targetUris.get(i));
            ++i;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (!this.isTransformationValid()) {
            return;
        }
        configuration.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.elemCount", this.myParamGroups.size());
        int i = 0;
        for (Map.Entry<ModelParameterInfo, IUriGroup> entry : this.myParamGroups.entrySet()) {
            QvtLaunchUtil.saveTargetUriData((ILaunchConfigurationWorkingCopy)configuration, (TargetUriData)entry.getValue().getUriData(), (int)(i + 1));
            ++i;
        }
    }

    private boolean isTransformationValid() {
        if (this.myTransformation == null) {
            return false;
        }
        try {
            return this.myTransformation.getModuleName().length() > 0;
        }
        catch (MdaException e) {
            return false;
        }
    }

    public String getTraceName() {
        for (Map.Entry<ModelParameterInfo, IUriGroup> entry : this.myParamGroups.entrySet()) {
            if (!entry.getKey().isInOutParameter() && !entry.getKey().isOutParameter()) continue;
            return entry.getValue().getUriData().getUriString();
        }
        return "";
    }

    private void createContents(Composite parent, List<IUriGroup.IModifyListener> listeners) {
        try {
            this.myParamGroups = new LinkedHashMap<ModelParameterInfo, IUriGroup>();
            for (ModelParameterInfo paramInfo : this.getTransfParameters()) {
                IUriGroup uriGroup = TransformationControls.createUriGroup((Composite)parent, (IModelParameterInfo)paramInfo, (ResourceSet)this.myValidationRS);
                this.myParamGroups.put(paramInfo, uriGroup);
                for (IUriGroup.IModifyListener listener : listeners) {
                    uriGroup.addModifyListener(listener);
                }
            }
        }
        catch (MdaException e) {
            this.myParamGroups = Collections.emptyMap();
        }
    }

    private void setCompositeLayout(Composite cm) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cm.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        cm.setLayoutData((Object)data);
    }

    private List<ModelParameterInfo> getTransfParameters() throws MdaException {
        if (this.myTransformation == null) {
            return Collections.emptyList();
        }
        ArrayList<ModelParameterInfo> modelParams = new ArrayList<ModelParameterInfo>();
        for (QvtTransformation.TransformationParameter param : this.myTransformation.getParameters()) {
            modelParams.add(this.createModelParamInfo(param));
        }
        return modelParams;
    }

    private ModelParameterInfo createModelParamInfo(QvtTransformation.TransformationParameter param) {
        return new ModelParameterInfo(param);
    }

    private static class ModelParameterInfo
    implements IModelParameterInfo {
        private final QvtTransformation.TransformationParameter myTransfParam;

        ModelParameterInfo(QvtTransformation.TransformationParameter transfParam) {
            this.myTransfParam = transfParam;
        }

        QvtTransformation.TransformationParameter getTransfParam() {
            return this.myTransfParam;
        }

        public IModelParameterInfo.Direction getDirection() {
            if (this.myTransfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.IN) {
                return IModelParameterInfo.Direction.in;
            }
            if (this.myTransfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.OUT) {
                return IModelParameterInfo.Direction.out;
            }
            return IModelParameterInfo.Direction.inout;
        }

        public EClassifier getEntryParamType() {
            return this.myTransfParam.getEntryType();
        }

        public String getEntryParamTypeName() {
            return this.myTransfParam.getEntryName();
        }

        public EPackage getMetamodel() {
            List metamodels = this.myTransfParam.getMetamodels();
            return metamodels.isEmpty() ? null : (EPackage)metamodels.get(0);
        }

        public String getModelTypeName() {
            return this.myTransfParam.getModelTypeName();
        }

        public String getName() {
            return this.myTransfParam.getName();
        }

        public boolean isInOutParameter() {
            return this.getDirection() == IModelParameterInfo.Direction.inout;
        }

        public boolean isInParameter() {
            return this.getDirection() == IModelParameterInfo.Direction.in;
        }

        public boolean isOutParameter() {
            return this.getDirection() == IModelParameterInfo.Direction.out;
        }
    }
}

