/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.view;

import java.awt.Component;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.lsat.timing.util.ChartCsvExporter;
import org.eclipse.lsat.timing.view.XYPlotData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.trace4cps.common.jfreechart.ui.widgets.ChartPanelComposite;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.statushandlers.StatusManager;

public class XYPlotView
extends ViewPart {
    private ChartPanelComposite chartComposite;
    private final ChartCsvExporter exporter = new ChartCsvExporter();
    public static final String ID = "org.eclipse.lsat.timing.view.XYPlotView";
    private static final String SUBMENU_SELECT_PLOT = "Select plot";
    private static final String SUBMENU_SAVE_AS = "Save as";
    private static final String CSV_MENU_ITEM_TEXT = "CSV...";

    public static void showPlots(List<XYPlotData> plotData) {
        XYPlotView[] view = new XYPlotView[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            XYPlotView xYPlotView = XYPlotView.getDefault();
        });
        if (view[0] != null) {
            view[0].setJFreeChart(plotData);
        }
    }

    private static XYPlotView getDefault() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow awbw = wb.getActiveWorkbenchWindow();
        IWorkbenchWindow[] iWorkbenchWindowArray = wb.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IViewReference[] iViewReferenceArray = page.getViewReferences();
                int n5 = iViewReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IViewReference viewRef = iViewReferenceArray[n6];
                    if (ID.equals(viewRef.getId())) {
                        XYPlotView view = (XYPlotView)viewRef.getView(true);
                        awbw.getActivePage().activate((IWorkbenchPart)view);
                        return view;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        try {
            return (XYPlotView)awbw.getActivePage().showView(ID, null, 1);
        }
        catch (PartInitException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.lsat.timing", e.getMessage(), (Throwable)e));
            return null;
        }
    }

    public void createPartControl(Composite parent) {
        this.chartComposite = new ChartPanelComposite(parent, 768);
    }

    public void setFocus() {
        if (this.chartComposite != null) {
            this.chartComposite.setFocus();
        }
    }

    private void setJFreeChart(List<XYPlotData> plotData) {
        if (this.chartComposite == null) {
            System.err.println("Not initialized yet!");
            return;
        }
        this.updatePopupMenu(plotData);
        this.chartComposite.setChart(plotData.get(0).getChart());
    }

    private void updatePopupMenu(List<XYPlotData> plotData) {
        JPopupMenu popup = this.chartComposite.getChartPanel().getPopupMenu();
        JMenu saveMenu = this.findSubmenu(popup, SUBMENU_SAVE_AS);
        if (saveMenu == null) {
            return;
        }
        JMenuItem csvItem = new JMenuItem(CSV_MENU_ITEM_TEXT);
        csvItem.addActionListener(e -> this.exporter.exportChart(this.chartComposite.getChartPanel(), this.chartComposite.getXYPlot().getDatasets(), this.chartComposite.getChart().getTitle().getText()));
        this.removeSaveAsCSVMenu(saveMenu);
        saveMenu.add(csvItem);
        this.removeSelectPlotMenu(popup);
        JMenu submenu = this.buildPlotSelectionMenu(plotData);
        popup.addSeparator();
        popup.add(submenu);
    }

    private void removeSaveAsCSVMenu(JMenu menu) {
        int i = menu.getItemCount() - 1;
        while (i >= 0) {
            JMenuItem item = menu.getItem(i);
            if (item != null && CSV_MENU_ITEM_TEXT.equals(item.getText())) {
                menu.remove(i);
            }
            --i;
        }
    }

    private void removeSelectPlotMenu(JPopupMenu popup) {
        int count = popup.getComponentCount();
        if (count == 0) {
            return;
        }
        Component selectPlotComponent = popup.getComponent(count - 1);
        Component separatorComponent = popup.getComponent(count - 2);
        popup.remove(selectPlotComponent);
        popup.remove(separatorComponent);
    }

    private JMenu buildPlotSelectionMenu(List<XYPlotData> plotData) {
        JMenu submenu = new JMenu(SUBMENU_SELECT_PLOT);
        submenu.setName(SUBMENU_SELECT_PLOT);
        int i = 0;
        while (i < plotData.size()) {
            int index = i++;
            JMenuItem item = new JMenuItem(plotData.get(index).getName());
            item.addActionListener(e -> this.chartComposite.setChart(((XYPlotData)plotData.get(index)).getChart()));
            submenu.add(item);
        }
        return submenu;
    }

    private JMenu findSubmenu(JPopupMenu popup, String text) {
        Component[] componentArray = popup.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            JMenu m;
            Component c = componentArray[n2];
            if (c instanceof JMenu && text.equals((m = (JMenu)c).getText())) {
                return m;
            }
            ++n2;
        }
        return null;
    }
}

