/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.validation;

import activity.ActivitySet;
import activity.Move;
import common.Import;
import common.ImportContainer;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsat.common.emf.common.util.BufferedDiagnosticChain;
import org.eclipse.lsat.common.graph.directed.editable.EditableDirectedGraph;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.timing.calculator.MotionCalculatorExtension;
import org.eclipse.lsat.timing.util.MotionCalculatorHelper;
import org.eclipse.lsat.timing.util.SpecificationException;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import setting.SettingUtil;
import setting.Settings;

public class ActivityEValidator
implements EValidator {
    public static final ActivityEValidator INSTANCE = new ActivityEValidator();
    private final Map<Settings, MotionCalculatorHelper> cache = new WeakHashMap<Settings, MotionCalculatorHelper>();
    private MotionCalculatorExtension motionCalculator;

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return eObject == null ? true : this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        CheckMode checkMode = CheckMode.getCheckMode(context);
        if (!checkMode.shouldCheck(CheckType.NORMAL) || checkMode.shouldCheck(CheckType.EXPENSIVE)) {
            return true;
        }
        if (!(EcoreUtil.getRootContainer((EObject)eObject) instanceof ActivitySet)) {
            return true;
        }
        BufferedDiagnosticChain bufferedDiagnostics = new BufferedDiagnosticChain(diagnostics);
        try {
            if (eObject instanceof Import) {
                MotionCalculatorHelper helper = this.getHelper(eObject);
                ActivityEValidator.validateActivitySet(helper, eObject, bufferedDiagnostics);
            }
            if (eObject instanceof Move) {
                Move move = (Move)eObject;
                MotionCalculatorHelper helper = this.getHelper(eObject);
                ActivityEValidator.validateMove(helper, move, (DiagnosticChain)bufferedDiagnostics);
            }
        }
        catch (IOException | MotionException throwable) {
            // empty catch block
        }
        return bufferedDiagnostics.getMaxSeverity() < 2;
    }

    private static void validateActivitySet(MotionCalculatorHelper helper, EObject eObject, BufferedDiagnosticChain bufferedDiagnostics) {
        ActivitySet activitySet = (ActivitySet)EcoreUtil.getRootContainer((EObject)eObject);
        List moves = activitySet.getActivities().stream().map(EditableDirectedGraph::getNodes).flatMap(Collection::stream).filter(Move.class::isInstance).map(Move.class::cast).collect(Collectors.toList());
        while (moves.size() > 0) {
            List<Move> concatenatedMove = helper.getConcatenatedMove((Move)moves.removeFirst());
            moves.removeAll(concatenatedMove);
            ActivityEValidator.validateConcatenatedMove(helper, concatenatedMove, (DiagnosticChain)bufferedDiagnostics);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void validateConcatenatedMove(MotionCalculatorHelper helper, List<Move> concatenatedMove, DiagnosticChain diagnostics) {
        block3: {
            try {
                helper.validate(concatenatedMove);
                break block3;
            }
            catch (SpecificationException e) {
                var7_4 = e.getEObjects();
                var6_5 = var7_4.length;
                var5_6 = 0;
                ** while (var5_6 < var6_5)
            }
lbl-1000:
            // 1 sources

            {
                eObject = var7_4[var5_6];
                ActivityEValidator.writeDiagnostic(diagnostics, 4, e.getMessage(), new EObject[]{eObject});
                ++var5_6;
                continue;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void validateMove(MotionCalculatorHelper helper, Move move, DiagnosticChain diagnostics) {
        block3: {
            concatenatedMove = helper.getConcatenatedMove(move);
            try {
                helper.validate(concatenatedMove);
                break block3;
            }
            catch (SpecificationException e) {
                var8_5 = e.getEObjects();
                var7_6 = var8_5.length;
                var6_7 = 0;
                ** while (var6_7 < var7_6)
            }
lbl-1000:
            // 1 sources

            {
                eObject = var8_5[var6_7];
                ActivityEValidator.writeDiagnostic(diagnostics, 4, e.getMessage(), new EObject[]{eObject});
                ++var6_7;
                continue;
            }
        }
    }

    private MotionCalculatorHelper getHelper(EObject eObject) throws IOException, MotionException {
        ActivitySet activitySet = (ActivitySet)EcoreUtil.getRootContainer((EObject)eObject);
        Settings settings = SettingUtil.getSettings((ImportContainer)activitySet);
        MotionCalculatorExtension motionCalculator = MotionCalculatorExtension.getSelectedMotionCalculator();
        MotionCalculatorHelper helper = this.cache.get(settings);
        if (helper == null || this.motionCalculator != motionCalculator) {
            this.motionCalculator = motionCalculator;
            helper = new MotionCalculatorHelper(settings, motionCalculator);
            this.cache.put(settings, helper);
        }
        return helper;
    }

    private static void writeDiagnostic(DiagnosticChain diagnostics, int severity, String message, EObject ... data) {
        diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.lsat.machine.dsl", 0, message, (Object[])data));
    }
}

