/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.util;

import activity.Move;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import machine.SetPoint;
import org.eclipse.emf.common.util.EList;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.timing.util.MotionData;
import org.eclipse.lsat.timing.util.SpecificationException;

public interface ITimingCalculator {
    public static final ITimingCalculator ZERO_CALCULATOR = new ITimingCalculator(){

        @Override
        public void reset() {
        }

        @Override
        public Map<SetPoint, BigDecimal> calculateMotionTime(Move move) {
            EList setPoints = move.getPeripheral().getType().getSetPoints();
            LinkedHashMap<SetPoint, BigDecimal> result = new LinkedHashMap<SetPoint, BigDecimal>(setPoints.size());
            for (SetPoint setPoint : setPoints) {
                result.put(setPoint, BigDecimal.ZERO);
            }
            return result;
        }

        @Override
        public Map<String, MotionData> calculateMotionData(Node node) {
            return new LinkedHashMap<String, MotionData>();
        }

        @Override
        public BigDecimal calculateDuration(Node node) {
            return BigDecimal.ZERO;
        }
    };

    public void reset();

    public BigDecimal calculateDuration(Node var1) throws SpecificationException, MotionException;

    public Map<SetPoint, BigDecimal> calculateMotionTime(Move var1) throws SpecificationException, MotionException;

    public Map<String, MotionData> calculateMotionData(Node var1) throws MotionException;
}

