/*
 * Decompiled with CFR 0.152.
 */
package product;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BooleanLiteral implements Enumerator
{
    FALSE(0, "False", "False"),
    TRUE(1, "True", "True");

    public static final int FALSE_VALUE = 0;
    public static final int TRUE_VALUE = 1;
    private static final BooleanLiteral[] VALUES_ARRAY;
    public static final List<BooleanLiteral> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BooleanLiteral[]{FALSE, TRUE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BooleanLiteral get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BooleanLiteral result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BooleanLiteral getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BooleanLiteral result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BooleanLiteral get(int value) {
        switch (value) {
            case 0: {
                return FALSE;
            }
            case 1: {
                return TRUE;
            }
        }
        return null;
    }

    private BooleanLiteral(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

