/**
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.machine.teditor.formatting

import com.google.inject.Inject
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter
import org.eclipse.xtext.formatting.impl.FormattingConfig
import org.eclipse.lsat.machine.teditor.services.MachineGrammarAccess

/**
 * This class contains custom formatting description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation.html#formatting
 * on how and when to use it 
 * 
 * Also see {@link org.eclipse.xtext.xtext.XtextFormattingTokenSerializer} as an example
 */
class MachineFormatter extends AbstractDeclarativeFormatter {
	
	@Inject extension MachineGrammarAccess
	
	override protected configureFormatting(FormattingConfig c) {
	    c.autoLinewrap = 120
		for(pair: findKeywordPairs('{', '}')) {
			c.setIndentation(pair.first, pair.second)
			c.setLinewrap(1).after(pair.first)
			c.setLinewrap(1).before(pair.second)
			c.setLinewrap(1).after(pair.second)
		}
        for(pair: findKeywordPairs('(', ')')) {
            c.setIndentation(pair.first, pair.second)
            c.setNoSpace().after(pair.first)
            c.setNoSpace().before(pair.second)
        }
        for(pair: findKeywordPairs('[', ']')) {
            c.setNoSpace().after(pair.first)
            c.setNoSpace().before(pair.second)
        }
        for(dot: findKeywords('.')) {
            c.setNoLinewrap().around(dot)
            c.setNoSpace().around(dot)
        }
		for(comma: findKeywords(',')) {
			c.setNoLinewrap().before(comma)
			c.setNoSpace().before(comma)
		}
        for(doublecolon: findKeywords(':')) {
            c.setNoLinewrap().before(doublecolon)
            c.setNoSpace().before(doublecolon)
        }
        for(arrow: findKeywords("->")) {
            c.setNoLinewrap().before(arrow)
            c.setNoSpace().before(arrow)
        }
        for(at: findKeywords('@')) {
            c.setNoSpace().after(at)
        }
 
        c.setLinewrap(1).after(importRule)

        c.setLinewrap(2, 2, 2).before(machineAccess.pathAnnotationsKeyword_3_0)
        c.setLinewrap(2, 2, 2).before(peripheralTypeRule)
        c.setLinewrap(2, 2, 2).after(peripheralTypeRule)
        c.setLinewrap(2, 2, 2).before(resourceRule)
        c.setLinewrap(2, 2, 2).after(resourceRule)
        
        c.setLinewrap(1).before(pathAnnotationRule)

        c.setLinewrap(1).before(actionTypeRule)
        c.setLinewrap(1).before(setPointRule)
        c.setLinewrap(1).before(axisRule)

        c.setLinewrap(1).before(peripheralRule)
        c.setLinewrap(1).before(axisPositionsMapEntryRule)
        c.setLinewrap(1).before(symbolicPositionRule)
        c.setLinewrap(1).before(peripheralAccess.pathsKeyword_3_1_8_0)
        c.setLinewrap(1).before(pathRule)
        c.setLinewrap(1).before(fullMeshPathAccess.endPointsAssignment_5)
        c.setLinewrap(1).before(distanceRule)
        c.setLinewrap(1).before(peripheralAccess.distancesKeyword_3_1_7_0)
        
		c.setLinewrap(0, 1, 2).before(SL_COMMENTRule)
		c.setLinewrap(0, 1, 2).before(ML_COMMENTRule)
		c.setLinewrap(0, 1, 1).after(ML_COMMENTRule)
	}
}
