/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.common.scheduler.graph.util;

import java.util.List;
import java.util.stream.Stream;

import org.eclipse.lsat.common.scheduler.graph.Constraint;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.graph.TaskDependencyGraph;

public final class ConstraintsCollector {
    private ConstraintsCollector() {
    }

    public static <T extends Task> List<Constraint> collectAllConstraints(TaskDependencyGraph<T> graph) {
        if (graph == null) {
            return List.of();
        }
        return Stream.concat(
                graph.getConstraints().stream(),
                graph.getSubGraphs().stream()
                    .flatMap(sub -> collectAllConstraints((TaskDependencyGraph<? extends T>)sub).stream())
        ).toList();
    }
}
