/**
 */
package distributions;

import distributions.math.ModeDistribution;

import expressions.Expression;

import java.math.BigDecimal;

import org.apache.commons.math3.random.RandomGenerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Poisson Distribution</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link distributions.PoissonDistribution#getP <em>P</em>}</li>
 *   <li>{@link distributions.PoissonDistribution#getEpsilon <em>Epsilon</em>}</li>
 *   <li>{@link distributions.PoissonDistribution#getPExp <em>PExp</em>}</li>
 *   <li>{@link distributions.PoissonDistribution#getEpsilonExp <em>Epsilon Exp</em>}</li>
 * </ul>
 *
 * @see distributions.DistributionsPackage#getPoissonDistribution()
 * @model
 * @generated
 */
public interface PoissonDistribution extends Distribution
{
    /**
     * Returns the value of the '<em><b>P</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>P</em>' attribute.
     * @see distributions.DistributionsPackage#getPoissonDistribution_P()
     * @model transient="true" changeable="false" volatile="true" derived="true"
     * @generated
     */
    BigDecimal getP();

    /**
     * Returns the value of the '<em><b>Epsilon</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Epsilon</em>' attribute.
     * @see distributions.DistributionsPackage#getPoissonDistribution_Epsilon()
     * @model transient="true" changeable="false" volatile="true" derived="true"
     * @generated
     */
    BigDecimal getEpsilon();

    /**
     * Returns the value of the '<em><b>PExp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>PExp</em>' containment reference.
     * @see #setPExp(Expression)
     * @see distributions.DistributionsPackage#getPoissonDistribution_PExp()
     * @model containment="true" required="true"
     * @generated
     */
    Expression getPExp();

    /**
     * Sets the value of the '{@link distributions.PoissonDistribution#getPExp <em>PExp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>PExp</em>' containment reference.
     * @see #getPExp()
     * @generated
     */
    void setPExp(Expression value);

    /**
     * Returns the value of the '<em><b>Epsilon Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Epsilon Exp</em>' containment reference.
     * @see #setEpsilonExp(Expression)
     * @see distributions.DistributionsPackage#getPoissonDistribution_EpsilonExp()
     * @model containment="true" required="true"
     * @generated
     */
    Expression getEpsilonExp();

    /**
     * Sets the value of the '{@link distributions.PoissonDistribution#getEpsilonExp <em>Epsilon Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Epsilon Exp</em>' containment reference.
     * @see #getEpsilonExp()
     * @generated
     */
    void setEpsilonExp(Expression value);

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @model dataType="distributions.ModeDistribution" required="true" generatorDataType="distributions.RandomGenerator"
     * @generated
     */
    ModeDistribution createModeDistribution(RandomGenerator generator);

} // PoissonDistribution
