/**
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.activity.teditor.scoping

import activity.Activity
import activity.Event
import activity.EventAction
import activity.HasResourceAndItem
import activity.LocationPrerequisite
import activity.ModelTypeDefinitionRef
import activity.PeripheralAction
import activity.ProductChange
import activity.impl.EventImpl
import common.ImportContainer
import java.util.List
import machine.ActionType
import machine.Distance
import machine.IResource
import machine.Machine
import machine.Profile
import machine.Resource
import machine.SymbolicPosition
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EReference
import org.eclipse.lsat.common.graph.directed.editable.EditableDirectedGraph
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.Scopes
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider
import org.eclipse.xtext.scoping.impl.FilteringScope
import product.IProductDefinition
import product.ProductDefinition

import static extension common.util.CommonUtil.collect
import static extension org.eclipse.xtext.EcoreUtil2.getContainerOfType

/**
 * This class contains custom scoping description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation.html#scoping
 * on how and when to use it 
 *
 */
class ActivityScopeProvider extends AbstractDeclarativeScopeProvider {
//    If you want to log the queried scoping rules, just enable this error handler
//    new() {
//        errorHandler = new org.eclipse.xtext.util.PolymorphicDispatcher.ErrorHandler<IScope> {
//            override handle(Object[] params, Throwable throwable) {
//                System.err.println(throwable.message)
//                return null
//            }
//        }
//    }
	
	def IScope scope_ModelTypeDefinitionRef_typeDefinition(ModelTypeDefinitionRef modelTypeDefinition,  EReference ref) {
        return new FilteringScope(delegateGetScope(modelTypeDefinition, ref), [ 
            (EObjectOrProxy instanceof Resource && !EObjectOrProxy.isEvent)  || EObjectOrProxy instanceof ProductDefinition
        ])
	}

    def IScope scope_HasResourceAndItem_resourceDefinition(PeripheralAction action, EReference ref) {
        return new FilteringScope(delegateGetScope(action, ref), [
            !EObjectOrProxy.isEvent
        ])
    }

    def IScope scope_HasResourceAndItem_resourceDefinition(EventAction action, EReference ref) {
        return new FilteringScope(delegateGetScope(action, ref), [
            EObjectOrProxy.isEvent
        ])
    }

    def IScope scope_IResource(Activity activity, EReference ref) {
        return Scopes.scopeFor(activity.parameterDeclarations.flatMap[declarations].filter(ModelTypeDefinitionRef).filter(IResource).filter[resource!==null], delegateGetScope(activity, ref));
    }

    def IScope scope_IProductDefinition(Activity activity, EReference ref) {
        return Scopes.scopeFor(activity.parameterDeclarations.flatMap[declarations].filter(ModelTypeDefinitionRef).filter(IProductDefinition).filter[propertyDefinitions!==null], delegateGetScope(activity, ref));
    }

    /**
     * Scoping for location prerequisites
     */
 
    def IScope scope_Peripheral(LocationPrerequisite prerequisite, EReference ref) {
        if (null === prerequisite.resource) {
            return IScope.NULLSCOPE
        }
        return Scopes.scopeFor(prerequisite.resource.resource.peripherals.filter[!it.positions.isEmpty])
    }

    def IScope scope_SymbolicPosition(LocationPrerequisite prerequisite, EReference ref) {
        if (null === prerequisite.peripheral) {
            return localScope(prerequisite, SymbolicPosition)
        }
        return Scopes.scopeFor(prerequisite.peripheral.positions, localScope(prerequisite, SymbolicPosition))
    }

    /**
     * Scoping for node tree
     */
    def IScope scope_Node(EditableDirectedGraph graph, EReference ref) {
      if (null === graph.nodes) {
          return IScope.NULLSCOPE
      }
      return Scopes.scopeFor(graph.nodes)
    }

    def IScope scope_Peripheral(HasResourceAndItem context, EReference ref) {
        if (null === context.resource) {
            return IScope.NULLSCOPE
        }
        return Scopes.scopeFor(context.resource.resource.peripherals)
    }

    def IScope scope_ResourceItem(HasResourceAndItem context, EReference ref) {
        if (null === context.resourceDefinition) {
            return IScope.NULLSCOPE
        }
        return Scopes.scopeFor(context.resourceDefinition.resource.items)
    }

	def IScope scope_ActionType(PeripheralAction action, EReference ref) {
        if (null === action.peripheral) {
            return localScope(action, ActionType)
        }
		return Scopes.scopeFor(action.peripheral.type.actions, localScope(action, ActionType))
	}

    def IScope scope_SymbolicPosition(PeripheralAction action, EReference ref) {
        if (null === action.peripheral) {
            return localScope(action, SymbolicPosition)
        }
        return  Scopes.scopeFor(action.peripheral.positions, localScope(action, SymbolicPosition))
    }

    def IScope scope_Distance(PeripheralAction action, EReference ref) {
        if (null === action.peripheral) {
            return localScope(action, Distance)
        }
        return  Scopes.scopeFor(action.peripheral.distances, localScope(action, Distance))
    }

    def IScope scope_Profile(PeripheralAction action, EReference ref) {
        if (null === action.peripheral) {
            return localScope(action, Profile)
        }
        return Scopes.scopeFor(action.peripheral.profiles, localScope(action, Profile))
    }

    def IScope scope_ResourceAction(Activity activity, EReference ref) {
      if (null === activity.nodes) {
          return IScope.NULLSCOPE
      }
      return Scopes.scopeFor(activity.nodes)
    }


    def IScope scope_Property_definition(ProductChange change, EReference ref) {
        val machines = change.getContainerOfType(ImportContainer).collect(Machine)
        val defs = machines.flatMap[productDefinitions].toList
        if (defs.size == 1) {
           return Scopes.scopeFor(defs.first.propertyDefinitions)
        }
        if (null === change.product) {
            return IScope.NULLSCOPE
        }
        return Scopes.scopeFor(change.product.propertyDefinitions)
    }

    private def IScope localScope(EObject context, Class<? extends EObject> clazz) {
        val locals = localParameters(context, clazz)
        return Scopes.scopeFor(locals)
    }

    private def <T> List<T> localParameters(EObject context, Class<T> clazz) {
        var activity = (context instanceof Activity) ? context:  getContainerOfType(context, Activity)
        if (activity === null) {
            return List.of()
        }
        return activity.parameterDeclarations.flatMap[declarations].filter(clazz).toList
    }

    private def isEvent(EObject eObject) {
        return (eObject instanceof Event ||  eObject instanceof EventImpl)
    }
}
