/**
 */
package activity.impl;

import activity.Activity;
import activity.ActivityPackage;
import activity.HasResourceAndItem;
import activity.LocationPrerequisite;

import java.lang.reflect.InvocationTargetException;

import machine.HasResourcePeripheral;
import machine.IResource;
import machine.Peripheral;
import machine.ResourceItem;
import machine.SymbolicPosition;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Location Prerequisite</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link activity.impl.LocationPrerequisiteImpl#getResourceDefinition <em>Resource Definition</em>}</li>
 *   <li>{@link activity.impl.LocationPrerequisiteImpl#getResourceItem <em>Resource Item</em>}</li>
 *   <li>{@link activity.impl.LocationPrerequisiteImpl#getResource <em>Resource</em>}</li>
 *   <li>{@link activity.impl.LocationPrerequisiteImpl#getPeripheral <em>Peripheral</em>}</li>
 *   <li>{@link activity.impl.LocationPrerequisiteImpl#getPosition <em>Position</em>}</li>
 *   <li>{@link activity.impl.LocationPrerequisiteImpl#getActivity <em>Activity</em>}</li>
 * </ul>
 *
 * @generated
 */
public class LocationPrerequisiteImpl extends MinimalEObjectImpl.Container implements LocationPrerequisite
{
    /**
     * The cached value of the '{@link #getResourceDefinition() <em>Resource Definition</em>}' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getResourceDefinition()
     * @generated
     * @ordered
     */
    protected IResource resourceDefinition;

    /**
     * The cached value of the '{@link #getResourceItem() <em>Resource Item</em>}' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getResourceItem()
     * @generated
     * @ordered
     */
    protected ResourceItem resourceItem;

    /**
     * The cached value of the '{@link #getPeripheral() <em>Peripheral</em>}' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getPeripheral()
     * @generated
     * @ordered
     */
    protected Peripheral peripheral;

    /**
     * The cached value of the '{@link #getPosition() <em>Position</em>}' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getPosition()
     * @generated
     * @ordered
     */
    protected SymbolicPosition position;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected LocationPrerequisiteImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return ActivityPackage.Literals.LOCATION_PREREQUISITE;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public IResource getResourceDefinition()
    {
        if (resourceDefinition != null && resourceDefinition.eIsProxy())
        {
            InternalEObject oldResourceDefinition = (InternalEObject)resourceDefinition;
            resourceDefinition = (IResource)eResolveProxy(oldResourceDefinition);
            if (resourceDefinition != oldResourceDefinition)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, ActivityPackage.LOCATION_PREREQUISITE__RESOURCE_DEFINITION, oldResourceDefinition, resourceDefinition));
            }
        }
        return resourceDefinition;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public IResource basicGetResourceDefinition()
    {
        return resourceDefinition;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setResourceDefinition(IResource newResourceDefinition)
    {
        IResource oldResourceDefinition = resourceDefinition;
        resourceDefinition = newResourceDefinition;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, ActivityPackage.LOCATION_PREREQUISITE__RESOURCE_DEFINITION, oldResourceDefinition, resourceDefinition));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ResourceItem getResourceItem()
    {
        if (resourceItem != null && resourceItem.eIsProxy())
        {
            InternalEObject oldResourceItem = (InternalEObject)resourceItem;
            resourceItem = (ResourceItem)eResolveProxy(oldResourceItem);
            if (resourceItem != oldResourceItem)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, ActivityPackage.LOCATION_PREREQUISITE__RESOURCE_ITEM, oldResourceItem, resourceItem));
            }
        }
        return resourceItem;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ResourceItem basicGetResourceItem()
    {
        return resourceItem;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setResourceItem(ResourceItem newResourceItem)
    {
        ResourceItem oldResourceItem = resourceItem;
        resourceItem = newResourceItem;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, ActivityPackage.LOCATION_PREREQUISITE__RESOURCE_ITEM, oldResourceItem, resourceItem));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public IResource getResource()
    {
        IResource resource = basicGetResource();
        return resource != null && resource.eIsProxy() ? (IResource)eResolveProxy((InternalEObject)resource) : resource;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public IResource basicGetResource()
    {
        return getResourceItem() instanceof machine.IResource item ? item : getResourceDefinition(); 
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Peripheral getPeripheral()
    {
        if (peripheral != null && peripheral.eIsProxy())
        {
            InternalEObject oldPeripheral = (InternalEObject)peripheral;
            peripheral = (Peripheral)eResolveProxy(oldPeripheral);
            if (peripheral != oldPeripheral)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, ActivityPackage.LOCATION_PREREQUISITE__PERIPHERAL, oldPeripheral, peripheral));
            }
        }
        return peripheral;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Peripheral basicGetPeripheral()
    {
        return peripheral;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setPeripheral(Peripheral newPeripheral)
    {
        Peripheral oldPeripheral = peripheral;
        peripheral = newPeripheral;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, ActivityPackage.LOCATION_PREREQUISITE__PERIPHERAL, oldPeripheral, peripheral));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public SymbolicPosition getPosition()
    {
        if (position != null && position.eIsProxy())
        {
            InternalEObject oldPosition = (InternalEObject)position;
            position = (SymbolicPosition)eResolveProxy(oldPosition);
            if (position != oldPosition)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, ActivityPackage.LOCATION_PREREQUISITE__POSITION, oldPosition, position));
            }
        }
        return position;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public SymbolicPosition basicGetPosition()
    {
        return position;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setPosition(SymbolicPosition newPosition)
    {
        SymbolicPosition oldPosition = position;
        position = newPosition;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, ActivityPackage.LOCATION_PREREQUISITE__POSITION, oldPosition, position));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Activity getActivity()
    {
        if (eContainerFeatureID() != ActivityPackage.LOCATION_PREREQUISITE__ACTIVITY) return null;
        return (Activity)eInternalContainer();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetActivity(Activity newActivity, NotificationChain msgs)
    {
        msgs = eBasicSetContainer((InternalEObject)newActivity, ActivityPackage.LOCATION_PREREQUISITE__ACTIVITY, msgs);
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setActivity(Activity newActivity)
    {
        if (newActivity != eInternalContainer() || (eContainerFeatureID() != ActivityPackage.LOCATION_PREREQUISITE__ACTIVITY && newActivity != null))
        {
            if (EcoreUtil.isAncestor(this, newActivity))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eInternalContainer() != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newActivity != null)
                msgs = ((InternalEObject)newActivity).eInverseAdd(this, ActivityPackage.ACTIVITY__PREREQUISITES, Activity.class, msgs);
            msgs = basicSetActivity(newActivity, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, ActivityPackage.LOCATION_PREREQUISITE__ACTIVITY, newActivity, newActivity));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setResource(final IResource resource)
    {
        if( resource instanceof machine.ResourceItem item )  {
            setResourceItem(item); 
            setResourceDefinition(item.getResource());
        } else if (resource instanceof machine.Resource mResource){
            setResourceDefinition(mResource); 
            if ( !mResource.getItems().contains(getResourceItem())) {
                 setResourceItem(null);
            }
        } else {
            setResourceDefinition(null);
            setResourceItem(null);
        }
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String fqn()
    {
        return (getResource()!=null && getPeripheral() != null) ? getResource().fqn()+"."+getPeripheral().getName():null;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean rpEquals(final HasResourcePeripheral cmp)
    {
        if (cmp ==null) return false; 
        return org.eclipse.emf.ecore.util.EcoreUtil.equals(getResource(),cmp.getResource()) && org.eclipse.emf.ecore.util.EcoreUtil.equals(getPeripheral(),cmp.getPeripheral());
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case ActivityPackage.LOCATION_PREREQUISITE__ACTIVITY:
                if (eInternalContainer() != null)
                    msgs = eBasicRemoveFromContainer(msgs);
                return basicSetActivity((Activity)otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case ActivityPackage.LOCATION_PREREQUISITE__ACTIVITY:
                return basicSetActivity(null, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs)
    {
        switch (eContainerFeatureID())
        {
            case ActivityPackage.LOCATION_PREREQUISITE__ACTIVITY:
                return eInternalContainer().eInverseRemove(this, ActivityPackage.ACTIVITY__PREREQUISITES, Activity.class, msgs);
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case ActivityPackage.LOCATION_PREREQUISITE__RESOURCE_DEFINITION:
                if (resolve) return getResourceDefinition();
                return basicGetResourceDefinition();
            case ActivityPackage.LOCATION_PREREQUISITE__RESOURCE_ITEM:
                if (resolve) return getResourceItem();
                return basicGetResourceItem();
            case ActivityPackage.LOCATION_PREREQUISITE__RESOURCE:
                if (resolve) return getResource();
                return basicGetResource();
            case ActivityPackage.LOCATION_PREREQUISITE__PERIPHERAL:
                if (resolve) return getPeripheral();
                return basicGetPeripheral();
            case ActivityPackage.LOCATION_PREREQUISITE__POSITION:
                if (resolve) return getPosition();
                return basicGetPosition();
            case ActivityPackage.LOCATION_PREREQUISITE__ACTIVITY:
                return getActivity();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case ActivityPackage.LOCATION_PREREQUISITE__RESOURCE_DEFINITION:
                setResourceDefinition((IResource)newValue);
                return;
            case ActivityPackage.LOCATION_PREREQUISITE__RESOURCE_ITEM:
                setResourceItem((ResourceItem)newValue);
                return;
            case ActivityPackage.LOCATION_PREREQUISITE__PERIPHERAL:
                setPeripheral((Peripheral)newValue);
                return;
            case ActivityPackage.LOCATION_PREREQUISITE__POSITION:
                setPosition((SymbolicPosition)newValue);
                return;
            case ActivityPackage.LOCATION_PREREQUISITE__ACTIVITY:
                setActivity((Activity)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case ActivityPackage.LOCATION_PREREQUISITE__RESOURCE_DEFINITION:
                setResourceDefinition((IResource)null);
                return;
            case ActivityPackage.LOCATION_PREREQUISITE__RESOURCE_ITEM:
                setResourceItem((ResourceItem)null);
                return;
            case ActivityPackage.LOCATION_PREREQUISITE__PERIPHERAL:
                setPeripheral((Peripheral)null);
                return;
            case ActivityPackage.LOCATION_PREREQUISITE__POSITION:
                setPosition((SymbolicPosition)null);
                return;
            case ActivityPackage.LOCATION_PREREQUISITE__ACTIVITY:
                setActivity((Activity)null);
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case ActivityPackage.LOCATION_PREREQUISITE__RESOURCE_DEFINITION:
                return resourceDefinition != null;
            case ActivityPackage.LOCATION_PREREQUISITE__RESOURCE_ITEM:
                return resourceItem != null;
            case ActivityPackage.LOCATION_PREREQUISITE__RESOURCE:
                return basicGetResource() != null;
            case ActivityPackage.LOCATION_PREREQUISITE__PERIPHERAL:
                return peripheral != null;
            case ActivityPackage.LOCATION_PREREQUISITE__POSITION:
                return position != null;
            case ActivityPackage.LOCATION_PREREQUISITE__ACTIVITY:
                return getActivity() != null;
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass)
    {
        if (baseClass == HasResourceAndItem.class)
        {
            switch (derivedFeatureID)
            {
                case ActivityPackage.LOCATION_PREREQUISITE__RESOURCE_DEFINITION: return ActivityPackage.HAS_RESOURCE_AND_ITEM__RESOURCE_DEFINITION;
                case ActivityPackage.LOCATION_PREREQUISITE__RESOURCE_ITEM: return ActivityPackage.HAS_RESOURCE_AND_ITEM__RESOURCE_ITEM;
                case ActivityPackage.LOCATION_PREREQUISITE__RESOURCE: return ActivityPackage.HAS_RESOURCE_AND_ITEM__RESOURCE;
                default: return -1;
            }
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass)
    {
        if (baseClass == HasResourceAndItem.class)
        {
            switch (baseFeatureID)
            {
                case ActivityPackage.HAS_RESOURCE_AND_ITEM__RESOURCE_DEFINITION: return ActivityPackage.LOCATION_PREREQUISITE__RESOURCE_DEFINITION;
                case ActivityPackage.HAS_RESOURCE_AND_ITEM__RESOURCE_ITEM: return ActivityPackage.LOCATION_PREREQUISITE__RESOURCE_ITEM;
                case ActivityPackage.HAS_RESOURCE_AND_ITEM__RESOURCE: return ActivityPackage.LOCATION_PREREQUISITE__RESOURCE;
                default: return -1;
            }
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public int eDerivedOperationID(int baseOperationID, Class<?> baseClass)
    {
        if (baseClass == HasResourceAndItem.class)
        {
            switch (baseOperationID)
            {
                case ActivityPackage.HAS_RESOURCE_AND_ITEM___SET_RESOURCE__IRESOURCE: return ActivityPackage.LOCATION_PREREQUISITE___SET_RESOURCE__IRESOURCE;
                default: return -1;
            }
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException
    {
        switch (operationID)
        {
            case ActivityPackage.LOCATION_PREREQUISITE___SET_RESOURCE__IRESOURCE:
                setResource((IResource)arguments.get(0));
                return null;
            case ActivityPackage.LOCATION_PREREQUISITE___FQN:
                return fqn();
            case ActivityPackage.LOCATION_PREREQUISITE___RP_EQUALS__HASRESOURCEPERIPHERAL:
                return rpEquals((HasResourcePeripheral)arguments.get(0));
        }
        return super.eInvoke(operationID, arguments);
    }

} //LocationPrerequisiteImpl
