/**
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.dispatching.teditor.scoping

import activity.Claim
import activity.ResourceAction
import common.Parameter
import common.ParameterReference
import dispatching.Constraint
import dispatching.Dispatch
import dispatching.DispatchGroup
import dispatching.DispatchingPackage
import machine.IResource
import machine.ResourceItem
import org.eclipse.emf.ecore.EReference
import org.eclipse.xtext.EcoreUtil2
import org.eclipse.xtext.resource.EObjectDescription
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.Scopes
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider
import org.eclipse.xtext.scoping.impl.FilteringScope
import org.eclipse.xtext.scoping.impl.SimpleScope

import static org.eclipse.xtext.EcoreUtil2.*

import static extension activity.util.ActivityParametersUtil.*

/**
 * This class contains custom scoping description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation.html#scoping
 * on how and when to use it 
 * 
 */
class DispatchingScopeProvider extends AbstractDeclarativeScopeProvider {
//    If you want to log the queried scoping rules, just enable this error handler
//    new() {
//        errorHandler = new org.eclipse.xtext.util.PolymorphicDispatcher.ErrorHandler<IScope> {
//            override handle(Object[] params, Throwable throwable) {
//                System.err.println("D:" +throwable.message)
//                return null
//            }
//        }
//    }

 
    /** 
     * Allow for shortName (@link ResourceItem name)
     */
    def IScope scope_Parameter_declaration(Parameter par, EReference ref) {
        val dis = getContainerOfType(par, Dispatch)
        val parIndex = dis.parameters.indexOf(par)
        if (dis.activity === null)
            return IScope.NULLSCOPE
        val preceding = dis.parameters.subList(0,parIndex).map[declaration]
        return  new FilteringScope(Scopes.scopeFor(dis.activity.getDeclarations()), [
             !preceding.contains(it.EObjectOrProxy)
        ])
    }
 
 
    def IScope scope_ParameterReference_reference(ParameterReference parRef, EReference ref) {
        val dis = getContainerOfType(parRef, Dispatch)
        val par = getContainerOfType(parRef, Parameter)
        if (dis.activity === null)
            return IScope.NULLSCOPE
        val parIndex = dis.parameters.indexOf(par)
        val refIndex = par.references.indexOf(parRef)
        // it is allowed to skip the declaration and to add parameters on index as 
        // long as there are no parameters with declaration in front of it.
        // this could be user friendly but is also necessary to be backwards compatible with 
        // dispatch files with resource items.
        if (par.declaration === null && dis.parameters.subList(0,parIndex).findFirst[declaration !== null] !== null)
            return IScope.NULLSCOPE

        val decl = (par.declaration !== null) ? par.declaration : dis.activity.declarations.get(parIndex) 
        // the resources to be evaluates are coming either from the parameters or as a concrete resource
        // the local resources are filtered out
        var resourcesFromActivity = dis.activity.nodes.filter(Claim).map[resource].filter[!isDeclaration(it)].toList
        val resourcesFromParameters = dis.parameters.subList(0,parIndex).map[references.last.reference].filter(IResource).flatMap[getResourceOrItems].toList
        var resourceCandidates = (resourcesFromActivity + resourcesFromParameters).toList
        val eligibleItems = findCandidate(dis.activity, resourceCandidates, decl, par.references.subList(0,refIndex).map[reference].toList )
        val validNameItems = eligibleItems.toSet.groupBy[name].values.filter[size == 1].flatten.map[EObjectDescription.create(name, it)]
        return Scopes.scopeFor(eligibleItems, new SimpleScope(validNameItems));
    }

    def IScope scope_Parameter_declaration(Dispatch dis, EReference ref) {
        var par = dis.parameters.findFirst[declaration===null]
        if(par !== null){
            return scope_Parameter_declaration(par, ref)
        }
        if (dis.activity === null)
            return IScope.NULLSCOPE
        return Scopes.scopeFor(dis.activity.declarations)
    }

    def IScope scope_ParameterReference_reference(Dispatch dis, EReference ref) {
        // grab the last parRef
        var parRef = dis.parameters?.flatMap[references].reduce(a,b|b)
        if(parRef !== null){
            return scope_ParameterReference_reference(parRef, ref)
        }
        return delegateGetScope(dis, ref)
    }

    def IScope ResourceYieldMapEntry(DispatchGroup dg, EReference ref) {
        if (dg.dispatches === null)
            return IScope.NULLSCOPE;
        return Scopes.scopeFor(dg.dispatches.flatMap[activity.nodes].filter(ResourceAction).map[resource].toSet)
    }

    def IScope scope_Dispatch(Constraint constraint, EReference ref) {
        var isSrc = (ref == DispatchingPackage.Literals.CONSTRAINT__SOURCE_DISPATCH)
        var dispatchGroup = isSrc ? constraint.sourceDispatchGroup : constraint.targetDispatchGroup
        if (dispatchGroup === null) 
            dispatchGroup = EcoreUtil2.getContainerOfType(constraint, DispatchGroup)
        if (dispatchGroup === null)
            return IScope.NULLSCOPE;
        return Scopes.scopeFor(dispatchGroup.dispatches)
    }

    def IScope scope_Action(Constraint constraint, EReference ref) {
        var isSrc = (ref == DispatchingPackage.Literals.CONSTRAINT__SOURCE_ACTION)
        var dispatch = isSrc ? constraint.sourceDispatch : constraint.targetDispatch
        if (dispatch === null)
            return IScope.NULLSCOPE;
        return Scopes.scopeFor(dispatch.activity.nodes)
    }
}
