/**
 */
package distributions.impl;

import distributions.DistributionsPackage;
import distributions.PoissonDistribution;

import distributions.math.ModeDistribution;

import expressions.Expression;

import expressions.impl.ExpressionImpl;

import java.lang.reflect.InvocationTargetException;

import java.math.BigDecimal;

import org.apache.commons.math3.random.RandomGenerator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Poisson Distribution</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link distributions.impl.PoissonDistributionImpl#getDefault <em>Default</em>}</li>
 *   <li>{@link distributions.impl.PoissonDistributionImpl#getDefaultExp <em>Default Exp</em>}</li>
 *   <li>{@link distributions.impl.PoissonDistributionImpl#getModeDistributionInstance <em>Mode Distribution Instance</em>}</li>
 *   <li>{@link distributions.impl.PoissonDistributionImpl#getP <em>P</em>}</li>
 *   <li>{@link distributions.impl.PoissonDistributionImpl#getEpsilon <em>Epsilon</em>}</li>
 *   <li>{@link distributions.impl.PoissonDistributionImpl#getPExp <em>PExp</em>}</li>
 *   <li>{@link distributions.impl.PoissonDistributionImpl#getEpsilonExp <em>Epsilon Exp</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PoissonDistributionImpl extends ExpressionImpl implements PoissonDistribution
{
    /**
     * The default value of the '{@link #getDefault() <em>Default</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDefault()
     * @generated
     * @ordered
     */
    protected static final BigDecimal DEFAULT_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getDefaultExp() <em>Default Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDefaultExp()
     * @generated
     * @ordered
     */
    protected Expression defaultExp;

    /**
     * The default value of the '{@link #getModeDistributionInstance() <em>Mode Distribution Instance</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getModeDistributionInstance()
     * @generated
     * @ordered
     */
    protected static final ModeDistribution MODE_DISTRIBUTION_INSTANCE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getModeDistributionInstance() <em>Mode Distribution Instance</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getModeDistributionInstance()
     * @generated
     * @ordered
     */
    protected ModeDistribution modeDistributionInstance = MODE_DISTRIBUTION_INSTANCE_EDEFAULT;

    /**
     * The default value of the '{@link #getP() <em>P</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getP()
     * @generated
     * @ordered
     */
    protected static final BigDecimal P_EDEFAULT = null;

    /**
     * The default value of the '{@link #getEpsilon() <em>Epsilon</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getEpsilon()
     * @generated
     * @ordered
     */
    protected static final BigDecimal EPSILON_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getPExp() <em>PExp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getPExp()
     * @generated
     * @ordered
     */
    protected Expression pExp;

    /**
     * The cached value of the '{@link #getEpsilonExp() <em>Epsilon Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getEpsilonExp()
     * @generated
     * @ordered
     */
    protected Expression epsilonExp;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected PoissonDistributionImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return DistributionsPackage.Literals.POISSON_DISTRIBUTION;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getDefault()
    {
        return defaultExp==null ? null:  defaultExp.evaluate();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Expression getDefaultExp()
    {
        return defaultExp;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetDefaultExp(Expression newDefaultExp, NotificationChain msgs)
    {
        Expression oldDefaultExp = defaultExp;
        defaultExp = newDefaultExp;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DistributionsPackage.POISSON_DISTRIBUTION__DEFAULT_EXP, oldDefaultExp, newDefaultExp);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setDefaultExp(Expression newDefaultExp)
    {
        if (newDefaultExp != defaultExp)
        {
            NotificationChain msgs = null;
            if (defaultExp != null)
                msgs = ((InternalEObject)defaultExp).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.POISSON_DISTRIBUTION__DEFAULT_EXP, null, msgs);
            if (newDefaultExp != null)
                msgs = ((InternalEObject)newDefaultExp).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.POISSON_DISTRIBUTION__DEFAULT_EXP, null, msgs);
            msgs = basicSetDefaultExp(newDefaultExp, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.POISSON_DISTRIBUTION__DEFAULT_EXP, newDefaultExp, newDefaultExp));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ModeDistribution getModeDistributionInstance()
    {
        return modeDistributionInstance;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setModeDistributionInstance(ModeDistribution newModeDistributionInstance)
    {
        ModeDistribution oldModeDistributionInstance = modeDistributionInstance;
        modeDistributionInstance = newModeDistributionInstance;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.POISSON_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE, oldModeDistributionInstance, modeDistributionInstance));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getP()
    {
        return pExp==null ? null:  pExp.evaluate();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getEpsilon()
    {
        return epsilonExp==null ? null:  epsilonExp.evaluate();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Expression getPExp()
    {
        return pExp;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetPExp(Expression newPExp, NotificationChain msgs)
    {
        Expression oldPExp = pExp;
        pExp = newPExp;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DistributionsPackage.POISSON_DISTRIBUTION__PEXP, oldPExp, newPExp);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setPExp(Expression newPExp)
    {
        if (newPExp != pExp)
        {
            NotificationChain msgs = null;
            if (pExp != null)
                msgs = ((InternalEObject)pExp).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.POISSON_DISTRIBUTION__PEXP, null, msgs);
            if (newPExp != null)
                msgs = ((InternalEObject)newPExp).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.POISSON_DISTRIBUTION__PEXP, null, msgs);
            msgs = basicSetPExp(newPExp, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.POISSON_DISTRIBUTION__PEXP, newPExp, newPExp));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Expression getEpsilonExp()
    {
        return epsilonExp;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetEpsilonExp(Expression newEpsilonExp, NotificationChain msgs)
    {
        Expression oldEpsilonExp = epsilonExp;
        epsilonExp = newEpsilonExp;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DistributionsPackage.POISSON_DISTRIBUTION__EPSILON_EXP, oldEpsilonExp, newEpsilonExp);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setEpsilonExp(Expression newEpsilonExp)
    {
        if (newEpsilonExp != epsilonExp)
        {
            NotificationChain msgs = null;
            if (epsilonExp != null)
                msgs = ((InternalEObject)epsilonExp).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.POISSON_DISTRIBUTION__EPSILON_EXP, null, msgs);
            if (newEpsilonExp != null)
                msgs = ((InternalEObject)newEpsilonExp).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.POISSON_DISTRIBUTION__EPSILON_EXP, null, msgs);
            msgs = basicSetEpsilonExp(newEpsilonExp, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.POISSON_DISTRIBUTION__EPSILON_EXP, newEpsilonExp, newEpsilonExp));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ModeDistribution createModeDistribution(final RandomGenerator generator)
    {
        var epsilon = getEpsilon();
        return new distributions.math.PoissonModeDistribution(generator, 
            getP().doubleValue(), 
            epsilon == null ? null : epsilon.doubleValue(), 
            null == getDefault() ? null : getDefault().doubleValue()
        );
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal evaluate()
    {
        var adapter =  distributions.DistributionsAdapter.getAdapter(this);
        var mode = adapter.getCalculationMode();
        if( mode == distributions.CalculationMode.DISTRIBUTED ){
            if( adapter.getRandomGenerator() == null ){
                throw new IllegalArgumentException("To use CalculationMode.DISTRIBUTED you'll have to set a RandomGenerator on Distributions");
            }
            return BigDecimal.valueOf(getModeDistribution().nextSample());
        }
        return BigDecimal.valueOf(getModeDistribution().getDefault());
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ModeDistribution getModeDistribution()
    {
        if( modeDistributionInstance == null){
            var adapter = distributions.DistributionsAdapter.getAdapter(this);
            if( adapter.getCalculationMode()==distributions.CalculationMode.DISTRIBUTED && adapter.getRandomGenerator() == null ){
                throw new IllegalArgumentException("To use CalculationMode.DISTRIBUTED you'll have to set a RandomGenerator on DistributionsAdapter");
            }
            setModeDistributionInstance( createModeDistribution(adapter.getRandomGenerator()) );
        }
        return modeDistributionInstance;
        
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case DistributionsPackage.POISSON_DISTRIBUTION__DEFAULT_EXP:
                return basicSetDefaultExp(null, msgs);
            case DistributionsPackage.POISSON_DISTRIBUTION__PEXP:
                return basicSetPExp(null, msgs);
            case DistributionsPackage.POISSON_DISTRIBUTION__EPSILON_EXP:
                return basicSetEpsilonExp(null, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case DistributionsPackage.POISSON_DISTRIBUTION__DEFAULT:
                return getDefault();
            case DistributionsPackage.POISSON_DISTRIBUTION__DEFAULT_EXP:
                return getDefaultExp();
            case DistributionsPackage.POISSON_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                return getModeDistributionInstance();
            case DistributionsPackage.POISSON_DISTRIBUTION__P:
                return getP();
            case DistributionsPackage.POISSON_DISTRIBUTION__EPSILON:
                return getEpsilon();
            case DistributionsPackage.POISSON_DISTRIBUTION__PEXP:
                return getPExp();
            case DistributionsPackage.POISSON_DISTRIBUTION__EPSILON_EXP:
                return getEpsilonExp();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case DistributionsPackage.POISSON_DISTRIBUTION__DEFAULT_EXP:
                setDefaultExp((Expression)newValue);
                return;
            case DistributionsPackage.POISSON_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                setModeDistributionInstance((ModeDistribution)newValue);
                return;
            case DistributionsPackage.POISSON_DISTRIBUTION__PEXP:
                setPExp((Expression)newValue);
                return;
            case DistributionsPackage.POISSON_DISTRIBUTION__EPSILON_EXP:
                setEpsilonExp((Expression)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case DistributionsPackage.POISSON_DISTRIBUTION__DEFAULT_EXP:
                setDefaultExp((Expression)null);
                return;
            case DistributionsPackage.POISSON_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                setModeDistributionInstance(MODE_DISTRIBUTION_INSTANCE_EDEFAULT);
                return;
            case DistributionsPackage.POISSON_DISTRIBUTION__PEXP:
                setPExp((Expression)null);
                return;
            case DistributionsPackage.POISSON_DISTRIBUTION__EPSILON_EXP:
                setEpsilonExp((Expression)null);
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case DistributionsPackage.POISSON_DISTRIBUTION__DEFAULT:
                return DEFAULT_EDEFAULT == null ? getDefault() != null : !DEFAULT_EDEFAULT.equals(getDefault());
            case DistributionsPackage.POISSON_DISTRIBUTION__DEFAULT_EXP:
                return defaultExp != null;
            case DistributionsPackage.POISSON_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                return MODE_DISTRIBUTION_INSTANCE_EDEFAULT == null ? modeDistributionInstance != null : !MODE_DISTRIBUTION_INSTANCE_EDEFAULT.equals(modeDistributionInstance);
            case DistributionsPackage.POISSON_DISTRIBUTION__P:
                return P_EDEFAULT == null ? getP() != null : !P_EDEFAULT.equals(getP());
            case DistributionsPackage.POISSON_DISTRIBUTION__EPSILON:
                return EPSILON_EDEFAULT == null ? getEpsilon() != null : !EPSILON_EDEFAULT.equals(getEpsilon());
            case DistributionsPackage.POISSON_DISTRIBUTION__PEXP:
                return pExp != null;
            case DistributionsPackage.POISSON_DISTRIBUTION__EPSILON_EXP:
                return epsilonExp != null;
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException
    {
        switch (operationID)
        {
            case DistributionsPackage.POISSON_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR:
                return createModeDistribution((RandomGenerator)arguments.get(0));
            case DistributionsPackage.POISSON_DISTRIBUTION___EVALUATE:
                return evaluate();
            case DistributionsPackage.POISSON_DISTRIBUTION___GET_MODE_DISTRIBUTION:
                return getModeDistribution();
        }
        return super.eInvoke(operationID, arguments);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (modeDistributionInstance: ");
        result.append(modeDistributionInstance);
        result.append(')');
        return result.toString();
    }

} //PoissonDistributionImpl
