/**
 */
package lsat_graph;

import org.eclipse.lsat.common.graph.directed.Aspect;

import org.eclipse.lsat.common.scheduler.graph.Task;

import org.eclipse.lsat.common.scheduler.schedule.ScheduledDependency;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledTask;

import java.math.BigDecimal;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Stochastic Annotation</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link lsat_graph.StochasticAnnotation#getCriticality <em>Criticality</em>}</li>
 *   <li>{@link lsat_graph.StochasticAnnotation#getConfidenceInterval <em>Confidence Interval</em>}</li>
 *   <li>{@link lsat_graph.StochasticAnnotation#getStandardDeviation <em>Standard Deviation</em>}</li>
 *   <li>{@link lsat_graph.StochasticAnnotation#getSkewness <em>Skewness</em>}</li>
 *   <li>{@link lsat_graph.StochasticAnnotation#getMax <em>Max</em>}</li>
 *   <li>{@link lsat_graph.StochasticAnnotation#getMin <em>Min</em>}</li>
 *   <li>{@link lsat_graph.StochasticAnnotation#getMean <em>Mean</em>}</li>
 * </ul>
 *
 * @see lsat_graph.lsat_graphPackage#getStochasticAnnotation()
 * @model
 * @generated
 */
public interface StochasticAnnotation extends Aspect<ScheduledTask<Task>, ScheduledDependency> {
	/**
     * Returns the value of the '<em><b>Criticality</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Weight</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Criticality</em>' attribute.
     * @see #setCriticality(BigDecimal)
     * @see lsat_graph.lsat_graphPackage#getStochasticAnnotation_Criticality()
     * @model required="true"
     * @generated
     */
	BigDecimal getCriticality();

	/**
     * Sets the value of the '{@link lsat_graph.StochasticAnnotation#getCriticality <em>Criticality</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Criticality</em>' attribute.
     * @see #getCriticality()
     * @generated
     */
	void setCriticality(BigDecimal value);

    /**
     * Returns the value of the '<em><b>Confidence Interval</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Confidence Interval</em>' containment reference.
     * @see #setConfidenceInterval(Bounds)
     * @see lsat_graph.lsat_graphPackage#getStochasticAnnotation_ConfidenceInterval()
     * @model containment="true" required="true"
     * @generated
     */
    Bounds getConfidenceInterval();

    /**
     * Sets the value of the '{@link lsat_graph.StochasticAnnotation#getConfidenceInterval <em>Confidence Interval</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Confidence Interval</em>' containment reference.
     * @see #getConfidenceInterval()
     * @generated
     */
    void setConfidenceInterval(Bounds value);

    /**
     * Returns the value of the '<em><b>Standard Deviation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Standard Deviation</em>' attribute.
     * @see #setStandardDeviation(BigDecimal)
     * @see lsat_graph.lsat_graphPackage#getStochasticAnnotation_StandardDeviation()
     * @model required="true"
     * @generated
     */
    BigDecimal getStandardDeviation();

    /**
     * Sets the value of the '{@link lsat_graph.StochasticAnnotation#getStandardDeviation <em>Standard Deviation</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Standard Deviation</em>' attribute.
     * @see #getStandardDeviation()
     * @generated
     */
    void setStandardDeviation(BigDecimal value);

    /**
     * Returns the value of the '<em><b>Skewness</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Skewness</em>' attribute.
     * @see #setSkewness(BigDecimal)
     * @see lsat_graph.lsat_graphPackage#getStochasticAnnotation_Skewness()
     * @model required="true"
     * @generated
     */
    BigDecimal getSkewness();

    /**
     * Sets the value of the '{@link lsat_graph.StochasticAnnotation#getSkewness <em>Skewness</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Skewness</em>' attribute.
     * @see #getSkewness()
     * @generated
     */
    void setSkewness(BigDecimal value);

    /**
     * Returns the value of the '<em><b>Max</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Max</em>' attribute.
     * @see #setMax(BigDecimal)
     * @see lsat_graph.lsat_graphPackage#getStochasticAnnotation_Max()
     * @model required="true"
     * @generated
     */
    BigDecimal getMax();

    /**
     * Sets the value of the '{@link lsat_graph.StochasticAnnotation#getMax <em>Max</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Max</em>' attribute.
     * @see #getMax()
     * @generated
     */
    void setMax(BigDecimal value);

    /**
     * Returns the value of the '<em><b>Min</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Min</em>' attribute.
     * @see #setMin(BigDecimal)
     * @see lsat_graph.lsat_graphPackage#getStochasticAnnotation_Min()
     * @model required="true"
     * @generated
     */
    BigDecimal getMin();

    /**
     * Sets the value of the '{@link lsat_graph.StochasticAnnotation#getMin <em>Min</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Min</em>' attribute.
     * @see #getMin()
     * @generated
     */
    void setMin(BigDecimal value);

    /**
     * Returns the value of the '<em><b>Mean</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Mean</em>' attribute.
     * @see #setMean(BigDecimal)
     * @see lsat_graph.lsat_graphPackage#getStochasticAnnotation_Mean()
     * @model required="true"
     * @generated
     */
    BigDecimal getMean();

    /**
     * Sets the value of the '{@link lsat_graph.StochasticAnnotation#getMean <em>Mean</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Mean</em>' attribute.
     * @see #getMean()
     * @generated
     */
    void setMean(BigDecimal value);

} // StochasticAnnotation
