/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.activity.teditor.validation;

import activity.Action;
import activity.Activity;
import activity.ActivityPackage;
import activity.ActivitySet;
import activity.Claim;
import activity.ConstraintEdge;
import activity.Dependency;
import activity.Event;
import activity.EventAction;
import activity.JitBounds;
import activity.LocationPrerequisite;
import activity.ModelTypeDefinitionRef;
import activity.Move;
import activity.PeripheralAction;
import activity.ProductChange;
import activity.RaiseEvent;
import activity.Release;
import activity.RequireEvent;
import activity.ResourceAction;
import activity.SchedulingType;
import activity.SimpleAction;
import activity.SyncBar;
import activity.TimeBounds;
import activity.impl.ActivityQueries;
import activity.util.ActivityParametersUtil;
import activity.util.ActivityUtil;
import com.google.common.collect.Iterables;
import common.CommonPackage;
import common.Import;
import common.ParameterDeclaration;
import common.TypeDefinition;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import machine.Distance;
import machine.HasResourcePeripheral;
import machine.IResource;
import machine.Machine;
import machine.PathTargetReference;
import machine.Peripheral;
import machine.Profile;
import machine.Resource;
import machine.ResourceType;
import machine.SymbolicPosition;
import machine.impl.MachineQueries;
import machine.util.ResourcePeripheralKey;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.lsat.activity.teditor.validation.AbstractActivityValidator;
import org.eclipse.lsat.common.graph.directed.editable.EdgPackage;
import org.eclipse.lsat.common.graph.directed.editable.EdgQueries;
import org.eclipse.lsat.common.graph.directed.editable.EditableDirectedGraph;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.common.util.BranchIterable;
import org.eclipse.lsat.common.xtend.Queries;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import product.ProductPackage;
import product.Property;
import product.PropertyDefinition;
import product.TransferType;

public class ActivityValidator
extends AbstractActivityValidator {
    public static final String ALAP_SCENARIO_1 = "invalidAlapScenario1";
    public static final String ALAP_SCENARIO_2 = "invalidAlapScenario2";
    public static final String ALAP_SCENARIO_3 = "invalidAlapScenario3";
    public static final String ALAP_SCENARIO_4 = "invalidAlapScenario4";
    public static final String INVALID_CLAIM = "invalidClaim";
    public static final String INVALID_PASSIVE_CLAIM = "invalidPassiveClaim";
    public static final String SUGGEST_PASSIVE_CLAIM = "suggestPassiveClaim";
    public static final String INVALID_RELEASE = "invalidRelease";
    public static final String PASSIVE_CLAIM_INCOMING_EDGES = "passiveClaimIncomingEdges";
    public static final String PASSIVE_RELEASE_OUTGOING_EDGES = "passiveReleaseOutgoingEdges";
    public static final String INVALID_SYNC_BAR = "invalidSyncBar";
    public static final String REMOVE_SYNC_BAR = "removeSyncBar";
    public static final String NO_INCOMING_EDGES = "noIncomingEdges";
    public static final String NO_OUTGOING_EDGES = "noOutgoingEdges";
    public static final String DEAD_ACTION = "deadAction";
    public static final String DEAD_EVENT = "deadEvent";
    public static final String MORE_THAN_ONE_INCOMING_EDGE = "moreThanOneIncomingEdge";
    public static final String MORE_THAN_ONE_OUTGOING_EDGE = "moreThanOneOutgoingEdge";
    public static final String ONE_CLAIM_PER_RESOURCE_PER_ACT = "oneClaimPerResourcePerActivity";
    public static final String ONE_EVENT_WITH_SAME_NAME_PER_ACT = "oneEventWithSameNamePerActivity";
    public static final String ONE_RELEASE_PER_RESOURCE_PER_ACT = "oneReleasePerResourcePerActivity";
    public static final String NO_CLAIM_DEFINED_FOR_RESOURCE = "noClaimDefinedForResource";
    public static final String RESOURCE_NOT_PROPERLY_CLAIMED = "resourceNotProperlyClaimed";
    public static final String NO_RELEASE_DEFINED_FOR_RESOURCE = "noReleaseDefinedForResource";
    public static final String RESOURCE_NOT_PROPERLY_RELEASED = "resourceNotProperlyReleased";
    public static final String CYCLE_DETECTED = "cycleDetected";
    public static final String ACTION_IN_PARALLEL_FOR_SAME_PERIPHERAL = "actionInParallelForSamePeripheral";
    public static final String NO_LOC_PREREQUISTIE_FOR_PERIPHERAL_FOR_MOVE = "noLocPrereqForPeripheralForMove";
    public static final String DUPLICATE_ACTIVITY_NAME = "duplicateActivityName";
    public static final String MORE_THAN_ONE_LOCATION_PREREQ_FOR_PERIPHERAL = "moreThanOneLocationPrereqForPeripheral";
    public static final String SAME_SOURCE_TARGET_FOR_PERIPHERAL = "sameSourceTargetForPeripheral";
    public static final String NO_PATH_FOUND_FOR_PROFILE = "noPathFoundForProfile";
    public static final String SETTLING_ALREADY_DEFINED_FOR_PATH = "settlingAlreadyDefinedForPath";
    public static final String SETTLING_ALREADY_DEFINED_FOR_MOVE = "settlingAlreadyDefinedForMove";
    public static final String NO_CONCAT_FOUND_FOR_MOVE = "noConcatFoundForMove";
    public static final String INVALID_IMPORT = "invalidImport";
    public static final String INVALID_RESOURCE = "invalidResource";
    public static final String DUPLICATE_EVENT_RESOURCE_NAME = "duplicateEventResourceName";
    public static final String MIXING_PARAMETERS_AND_INCOMPLETE_RESOURCES = "mixingParametersAndIncompleteResources";
    public static final String RESOURCE_NO_ITEMS = "resourceNoItems";
    public static final String CONSTRAINT_TO_FROM_SYNCBAR = "constraintSyncBar";
    public static final String TIME_CONSTRANT_LIMITS = "timeConstraintLimits";

    @Check
    public void checkUniqueEventAndResourceNames(Event event) {
        EList imports = ((ActivitySet)EcoreUtil2.getContainerOfType((EObject)event, ActivitySet.class)).getImports();
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> it_1.getResources();
            Functions.Function1 _function_2 = it_1 -> {
                String _name = it_1.getName();
                String _name_1 = event.getName();
                return Objects.equals(_name, _name_1);
            };
            return IterableExtensions.exists((Iterable)IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)it.load(), Machine.class), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        };
        Iterable conflictingImports = IterableExtensions.filter((Iterable)imports, (Functions.Function1)_function);
        for (Import conflictingImport : conflictingImports) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Import ");
            String _importURI = conflictingImport.getImportURI();
            _builder.append(_importURI);
            _builder.append(" already defines a resource with name ");
            String _name = event.getName();
            _builder.append(_name);
            _builder.append(". Event and resource names should be unique.");
            this.error(_builder.toString(), (EStructuralFeature)CommonPackage.Literals.HAS_NAME__NAME, MIXING_PARAMETERS_AND_INCOMPLETE_RESOURCES, new String[0]);
        }
    }

    @Check
    public void checkResourceParameterHasNoResourceItems(Activity activity) {
        Functions.Function1 _function = it -> it.getDeclarations();
        Consumer<ModelTypeDefinitionRef> _function_1 = it -> {
            if (it.getResource() != null && it.getResource().getResource().getItems().isEmpty()) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Resource ");
                String _name = it.getResource().getName();
                _builder.append(_name);
                _builder.append(" has no resource items. Add them to the resource or remove this parameter'.");
                this.error(_builder.toString(), (EObject)it, (EStructuralFeature)ActivityPackage.Literals.MODEL_TYPE_DEFINITION_REF__TYPE_DEFINITION, RESOURCE_NO_ITEMS, new String[0]);
            }
        };
        Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)activity.getParameterDeclarations(), (Functions.Function1)_function), ModelTypeDefinitionRef.class).forEach(_function_1);
    }

    @Check
    public void checkParameterNotUsed(Activity activity) {
        Functions.Function1 _function = it -> it.getDeclarations();
        Consumer<TypeDefinition> _function_1 = it -> {
            boolean _not;
            boolean _uses = ActivityParametersUtil.uses((Activity)activity, (TypeDefinition)it);
            boolean bl = _not = !_uses;
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                String _name = it.eClass().getName();
                _builder.append(_name);
                _builder.append(" ");
                String _name_1 = it.getName();
                _builder.append(_name_1);
                _builder.append(" is not used'.");
                this.error(_builder.toString(), (EObject)it, (EStructuralFeature)CommonPackage.Literals.HAS_NAME__NAME);
            }
        };
        IterableExtensions.flatMap((Iterable)activity.getParameterDeclarations(), (Functions.Function1)_function).forEach(_function_1);
    }

    @Check
    public void checkMixingParametersAndIncompleteResources(Activity activity) {
        boolean _not;
        boolean _isEmpty = activity.getParameterDeclarations().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList _resourcesNeedingItem = activity.getResourcesNeedingItem();
            for (Resource resource : _resourcesNeedingItem) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Activity ");
                String _name = activity.getName();
                _builder.append(_name);
                _builder.append(" has incomplete resource items AND parameters. Create parameter for '");
                String _name_1 = resource.getName();
                _builder.append(_name_1);
                _builder.append("'.");
                this.error(_builder.toString(), (EObject)resource, (EStructuralFeature)CommonPackage.Literals.HAS_NAME__NAME, MIXING_PARAMETERS_AND_INCOMPLETE_RESOURCES, new String[0]);
            }
        }
    }

    @Check
    public void checkImportIsValid(Import imp) {
        try {
            boolean isUnderstood;
            boolean isImportUriValid = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
            if (!isImportUriValid) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("The import ");
                String _importURI = imp.getImportURI();
                _builder.append(_importURI);
                _builder.append(" cannot be resolved. Make sure that the name is spelled correctly.");
                this.error(_builder.toString(), (EObject)imp, (EStructuralFeature)CommonPackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
            if (!(isUnderstood = imp.getImportURI().matches(".*\\.(machine|activity)"))) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Importing ");
                String _importURI_1 = imp.getImportURI();
                _builder_1.append(_importURI_1);
                _builder_1.append(" is not allowed. Only 'machine' files are allowed");
                this.error(_builder_1.toString(), (EObject)imp, (EStructuralFeature)CommonPackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("The import ");
                String _importURI_2 = imp.getImportURI();
                _builder_2.append(_importURI_2);
                _builder_2.append(" is not a valid URI.");
                this.error(_builder_2.toString(), (EObject)imp, (EStructuralFeature)CommonPackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public boolean concatenatesASAP(Action action) {
        boolean willDoASAP;
        boolean _switchResult = false;
        boolean _matched = false;
        if (action instanceof PeripheralAction) {
            _matched = true;
            SchedulingType _schedulingType = ((PeripheralAction)action).getSchedulingType();
            _switchResult = Objects.equals(_schedulingType, SchedulingType.ASAP);
        }
        if (!_matched && action instanceof Release) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return (willDoASAP = _switchResult) && IterableExtensions.size((Iterable)EdgQueries.nearestPredecessors((Node)action, Action.class)) <= 1;
    }

    public boolean concatenatesALAP(Action action) {
        boolean willDoALAP;
        boolean _switchResult = false;
        boolean _matched = false;
        if (action instanceof PeripheralAction) {
            _matched = true;
            SchedulingType _schedulingType = ((PeripheralAction)action).getSchedulingType();
            _switchResult = Objects.equals(_schedulingType, SchedulingType.ALAP);
        }
        if (!_matched && action instanceof Claim) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return (willDoALAP = _switchResult) && IterableExtensions.size((Iterable)EdgQueries.nearestSuccessors((Node)action, Action.class)) <= 1;
    }

    @Check
    public void checkActionIsALAPWithSuccessorIsASAP(PeripheralAction action) {
        if (Objects.equals(action.getSchedulingType(), SchedulingType.ALAP) && IterableExtensions.exists((Iterable)EdgQueries.nearestSuccessors((Node)action, Action.class), it -> this.concatenatesASAP((Action)it))) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The ALAP keyword does not have any affect for action ");
            String _name = action.getName();
            _builder.append(_name);
            _builder.append(".");
            this.warning(_builder.toString(), (EStructuralFeature)ActivityPackage.Literals.PERIPHERAL_ACTION__SCHEDULING_TYPE, ALAP_SCENARIO_1, new String[0]);
        }
    }

    @Check
    public void checkConcatenatedMove(Move move) {
        boolean requiresALAP;
        Move predecessorMove;
        boolean isContinuing;
        Move successorMove = move.getSuccessorMove();
        boolean _isStopAtTarget = move.isStopAtTarget();
        boolean bl = isContinuing = !_isStopAtTarget;
        if (isContinuing) {
            boolean _not;
            Set successorPeripheralActions = IterableExtensions.toSet((Iterable)EdgQueries.nearestSuccessors((Node)move, PeripheralAction.class));
            if (successorMove == null) {
                StringConcatenation _builder = new StringConcatenation();
                String _name = move.getName();
                _builder.append(_name);
                _builder.append(" should be concatenated with another move. ");
                this.error(_builder.toString(), (EObject)move, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, NO_CONCAT_FOUND_FOR_MOVE, new String[0]);
                return;
            }
            boolean _contains = successorPeripheralActions.contains(successorMove);
            boolean bl2 = _not = !_contains;
            if (_not) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Failed to concatenate ");
                String _name_1 = move.getName();
                _builder_1.append(_name_1);
                _builder_1.append(" and ");
                String _name_2 = successorMove.getName();
                _builder_1.append(_name_2);
                _builder_1.append(", only sync bars, claims, releases or events are allowed in between.");
                this.error(_builder_1.toString(), (EObject)move, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, NO_CONCAT_FOUND_FOR_MOVE, new String[0]);
                return;
            }
        }
        boolean isContinuated = (predecessorMove = move.getPredecessorMove()) != null && !predecessorMove.isStopAtTarget();
        Functions.Function1 _function = it -> EdgQueries.nearestSuccessors((Node)it, Action.class);
        Functions.Function1 _function_1 = it -> Objects.equals(it, move);
        BranchIterable actionsUntilPredecessorMove = Queries.until((BranchIterable)Queries.closure(Collections.singleton(predecessorMove), (boolean)true, (Functions.Function1)_function), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> EdgQueries.nearestPredecessors((Node)it, Action.class);
        Functions.Function1 _function_3 = it -> Objects.equals(it, move);
        BranchIterable actionsUntilSuccessorMove = Queries.until((BranchIterable)Queries.closure(Collections.singleton(successorMove), (boolean)true, (Functions.Function1)_function_2), (Functions.Function1)_function_3);
        boolean requiresASAP = isContinuated && IterableExtensions.exists((Iterable)actionsUntilPredecessorMove, it -> {
            boolean _concatenatesALAP = this.concatenatesALAP((Action)it);
            return !_concatenatesALAP;
        });
        boolean bl3 = requiresALAP = isContinuing && IterableExtensions.exists((Iterable)actionsUntilSuccessorMove, it -> {
            boolean _concatenatesASAP = this.concatenatesASAP((Action)it);
            return !_concatenatesASAP;
        }) && !IterableExtensions.exists((Iterable)EdgQueries.nearestSuccessors((Node)move, Action.class), it -> this.concatenatesASAP((Action)it));
        if (requiresASAP && requiresALAP) {
            Set predecessors = IterableExtensions.toSet((Iterable)EdgQueries.allPredecessors((Node)successorMove));
            predecessors.remove(move);
            CollectionExtensions.removeAll((Collection)predecessors, (Iterable)EdgQueries.allPredecessors((Node)move));
            Iterable _reject = IterableExtensions.reject((Iterable)IterableExtensions.reject((Iterable)predecessors, Release.class), SyncBar.class);
            for (Node pred : _reject) {
                Activity activity = (Activity)EcoreUtil2.getContainerOfType((EObject)pred, Activity.class);
                int predIndex = activity.getNodes().indexOf((Object)pred);
                StringConcatenation _builder_2 = new StringConcatenation();
                String _name_3 = pred.getName();
                _builder_2.append(_name_3);
                _builder_2.append(" might interrupt concatenated move [");
                String _name_4 = move.getName();
                _builder_2.append(_name_4);
                _builder_2.append("->");
                String _name_5 = successorMove.getName();
                _builder_2.append(_name_5);
                _builder_2.append("]");
                this.warning(_builder_2.toString(), (EObject)activity, (EStructuralFeature)EdgPackage.Literals.EDITABLE_DIRECTED_GRAPH__NODES, predIndex, ALAP_SCENARIO_4, new String[0]);
            }
        } else {
            if (requiresASAP && Objects.equals(move.getSchedulingType(), SchedulingType.ALAP)) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Move ");
                String _name_3 = move.getName();
                _builder_2.append(_name_3);
                _builder_2.append(" must be set to ASAP to guarantee concatenation with predecessor move ");
                String _name_4 = predecessorMove.getName();
                _builder_2.append(_name_4);
                _builder_2.append(".");
                this.error(_builder_2.toString(), (EStructuralFeature)ActivityPackage.Literals.PERIPHERAL_ACTION__SCHEDULING_TYPE, ALAP_SCENARIO_3, new String[0]);
                return;
            }
            if (requiresALAP && Objects.equals(move.getSchedulingType(), SchedulingType.ASAP)) {
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("Move ");
                String _name_5 = move.getName();
                _builder_3.append(_name_5);
                _builder_3.append(" must be set to ALAP to guarantee concatenation with successor move ");
                String _name_6 = successorMove.getName();
                _builder_3.append(_name_6);
                _builder_3.append(".");
                this.error(_builder_3.toString(), (EStructuralFeature)ActivityPackage.Literals.PERIPHERAL_ACTION__SCHEDULING_TYPE, ALAP_SCENARIO_2, new String[0]);
                return;
            }
        }
    }

    @Check
    public void checkIfUsedInActivityFlow(Claim claim) {
        boolean _isEmpty = claim.getOutgoingEdges().isEmpty();
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Claim ");
            String _name = claim.getName();
            _builder.append(_name);
            _builder.append(" has no outgoing edges.");
            this.error(_builder.toString(), (EObject)claim, (EStructuralFeature)EdgPackage.Literals.NODE__OUTGOING_EDGES, INVALID_CLAIM, new String[0]);
        }
    }

    @Check
    public void checkEvent(EventAction event) {
        boolean _tripleNotEquals;
        ResourceType _resourceType = event.getResource().getResource().getResourceType();
        boolean bl = _tripleNotEquals = _resourceType != ResourceType.EVENT;
        if (_tripleNotEquals) {
            String _xifexpression = null;
            _xifexpression = event instanceof RequireEvent ? "Require" : "Raise";
            String name = _xifexpression;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(name);
            _builder.append(" ");
            String _fqn = event.getResource().fqn();
            _builder.append(_fqn);
            _builder.append(" is not an Event");
            this.error(_builder.toString(), (EObject)event, (EStructuralFeature)ActivityPackage.Literals.HAS_RESOURCE_AND_ITEM__RESOURCE_DEFINITION, INVALID_RESOURCE, new String[0]);
        }
    }

    @Check
    public void checkResource(ResourceAction action) {
        ResourceType _resourceType;
        boolean _tripleNotEquals;
        boolean _tripleEquals;
        boolean _isDeclaration;
        if (action instanceof EventAction) {
            return;
        }
        if (action instanceof SimpleAction && (_isDeclaration = ActivityParametersUtil.isDeclaration((EObject)((SimpleAction)action).getType()))) {
            return;
        }
        IResource _resource = action.getResource();
        boolean bl = _tripleEquals = _resource == null;
        if (_tripleEquals) {
            String name = action.getClass().getSimpleName();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(name);
            _builder.append(" ");
            _builder.append((Object)action);
            _builder.append(" resource has not been defined.");
            this.error(_builder.toString(), (EObject)action, (EStructuralFeature)ActivityPackage.Literals.HAS_RESOURCE_AND_ITEM__RESOURCE_DEFINITION, INVALID_RESOURCE, new String[0]);
        }
        boolean bl2 = _tripleNotEquals = (_resourceType = action.getResource().getResource().getResourceType()) != ResourceType.REGULAR;
        if (_tripleNotEquals) {
            String name_1 = action.getClass().getSimpleName();
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(name_1);
            _builder_1.append(" ");
            String _fqn = action.getResource().fqn();
            _builder_1.append(_fqn);
            _builder_1.append(" is not a machine resource.");
            this.error(_builder_1.toString(), (EObject)action, (EStructuralFeature)ActivityPackage.Literals.HAS_RESOURCE_AND_ITEM__RESOURCE_DEFINITION, INVALID_RESOURCE, new String[0]);
        }
    }

    @Check
    public void checkPassiveClaim(Claim claim) {
        boolean _tripleNotEquals;
        ResourceType _resourceType = claim.getResource().getResource().getResourceType();
        boolean bl = _tripleNotEquals = _resourceType != ResourceType.REGULAR;
        if (_tripleNotEquals) {
            return;
        }
        EditableDirectedGraph _graph = claim.getGraph();
        Activity activity = (Activity)_graph;
        Functions.Function1 _function = it -> {
            IResource _resource_1;
            IResource _resource = it.getResource();
            return _resource == (_resource_1 = claim.getResource());
        };
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)activity.getNodes(), PeripheralAction.class), (Functions.Function1)_function));
        boolean hasActions = !_isEmpty;
        boolean isCollisionArea = claim.getResource().getResource().getPeripherals().isEmpty();
        boolean _isPassive = claim.isPassive();
        if (_isPassive) {
            boolean _not;
            if (hasActions) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Claim ");
                String _name = claim.getName();
                _builder.append(_name);
                _builder.append(" cannot be passive. There are actions for resource ");
                String _fqn = claim.getResource().fqn();
                _builder.append(_fqn);
                _builder.append(".");
                this.error(_builder.toString(), (EObject)claim, (EStructuralFeature)ActivityPackage.Literals.CLAIM__PASSIVE, INVALID_PASSIVE_CLAIM, new String[0]);
                return;
            }
            boolean _isEmpty_1 = claim.getIncomingEdges().isEmpty();
            boolean bl2 = _not = !_isEmpty_1;
            if (_not) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Passive claim ");
                String _name_1 = claim.getName();
                _builder_1.append(_name_1);
                _builder_1.append(" should not have incoming edges as they may possibly block other activities.");
                this.warning(_builder_1.toString(), (EObject)claim, (EStructuralFeature)EdgPackage.Literals.NODE__INCOMING_EDGES, PASSIVE_CLAIM_INCOMING_EDGES, new String[0]);
            }
            Functions.Function1 _function_1 = it -> it.getOutgoingEdges().isEmpty();
            Iterable _reject = IterableExtensions.reject((Iterable)ActivityUtil.getReleases((Activity)activity, (IResource)claim.getResource()), (Functions.Function1)_function_1);
            for (Release release : _reject) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Passive release ");
                String _name_2 = release.getName();
                _builder_2.append(_name_2);
                _builder_2.append(" should not have outgoing edges as they may possibly block other activities.");
                this.warning(_builder_2.toString(), (EObject)release, (EStructuralFeature)EdgPackage.Literals.NODE__OUTGOING_EDGES, PASSIVE_RELEASE_OUTGOING_EDGES, new String[0]);
            }
        } else if (!isCollisionArea && !hasActions) {
            Functions.Function1 _function_2 = it -> it.getType();
            boolean noLocalActions = ActivityValidator.noneLocal((EObject[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)Iterables.filter((Iterable)activity.getNodes(), SimpleAction.class), (Functions.Function1)_function_2), EObject.class));
            if (noLocalActions) {
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("Claim ");
                String _name_3 = claim.getName();
                _builder_3.append(_name_3);
                _builder_3.append(" can be made passive. There are no actions for resource ");
                String _fqn_1 = claim.getResource().fqn();
                _builder_3.append(_fqn_1);
                _builder_3.append(".");
                this.info(_builder_3.toString(), (EObject)claim, (EStructuralFeature)ActivityPackage.Literals.CLAIM__PASSIVE, SUGGEST_PASSIVE_CLAIM, new String[0]);
            }
        }
    }

    @Check
    public void checkIfUsedInActivityFlow(Release release) {
        boolean _isEmpty = release.getIncomingEdges().isEmpty();
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Release ");
            String _name = release.getName();
            _builder.append(_name);
            _builder.append(" has no incoming edges.");
            this.error(_builder.toString(), (EObject)release, (EStructuralFeature)EdgPackage.Literals.NODE__INCOMING_EDGES, INVALID_RELEASE, new String[0]);
        }
    }

    @Check
    public void checkHasEdges(SyncBar syncBar) {
        if (syncBar.getOutgoingEdges().size() > 0 && syncBar.getIncomingEdges().isEmpty()) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("SyncBar ");
            String _name = syncBar.getName();
            _builder.append(_name);
            _builder.append(" has no incoming edges.");
            this.error(_builder.toString(), (EObject)syncBar.getOutgoingEdges().get(0), (EStructuralFeature)EdgPackage.Literals.EDGE__SOURCE_NODE, INVALID_SYNC_BAR, new String[0]);
        }
        if (syncBar.getIncomingEdges().size() == 1 && syncBar.getOutgoingEdges().size() == 1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("SyncBar ");
            String _name_1 = syncBar.getName();
            _builder_1.append(_name_1);
            _builder_1.append(" with only 1 incoming and 1 outgoing edge can be removed.");
            this.warning(_builder_1.toString(), (EObject)syncBar.getOutgoingEdges().get(0), (EStructuralFeature)EdgPackage.Literals.EDGE__SOURCE_NODE, REMOVE_SYNC_BAR, new String[0]);
        }
    }

    @Check
    public void checkIfHasPredecessorAction(RaiseEvent event) {
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)EdgQueries.nearestPredecessors((Node)event, Action.class));
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Event '");
            String _name = event.getResource().getName();
            _builder.append(_name);
            _builder.append("' should be preceded with an action.");
            this.error(_builder.toString(), (EObject)event, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, DEAD_EVENT, new String[0]);
        }
    }

    @Check
    public void checkIfHasSuccessorAction(RequireEvent event) {
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)EdgQueries.nearestSuccessors((Node)event, Action.class));
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Event ");
            String _name = event.getResource().getName();
            _builder.append(_name);
            _builder.append(" should be succeeded by an action.");
            this.error(_builder.toString(), (EObject)event, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, DEAD_EVENT, new String[0]);
        }
    }

    @Check
    public void checkEventNameUnique(Activity activity) {
        Functions.Function1 _function = it -> it.getResource().fqn();
        Functions.Function1 _function_1 = it -> {
            int _size = it.size();
            return _size > 2;
        };
        Consumer<EventAction> _function_2 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("One require and/or raise event with name '");
            String _fqn = it.getResource().fqn();
            _builder.append(_fqn);
            _builder.append("' per activity are allowed.");
            this.error(_builder.toString(), (EObject)it, (EStructuralFeature)ActivityPackage.Literals.HAS_RESOURCE_AND_ITEM__RESOURCE_DEFINITION, ONE_EVENT_WITH_SAME_NAME_PER_ACT, new String[0]);
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)Iterables.filter((Iterable)activity.getNodes(), EventAction.class), (Functions.Function1)_function).values(), (Functions.Function1)_function_1)).forEach(_function_2);
    }

    @Check
    public void checkRequireRaise(Activity activity) {
        Functions.Function1 _function = it -> it.getResource().fqn();
        Functions.Function1 _function_1 = it -> {
            int _size = it.size();
            return _size == 2;
        };
        Functions.Function1 _function_2 = it -> !(it.get(0) instanceof RequireEvent) || !(it.get(1) instanceof RaiseEvent);
        Consumer<List> _function_3 = seq -> {
            Consumer<EventAction> _function_4 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Expecting 'require' followed by 'raise' for event '");
                String _fqn = it.getResource().fqn();
                _builder.append(_fqn);
                _builder.append("', not '");
                String _eventType = this.eventType((EventAction)seq.get(0));
                _builder.append(_eventType);
                _builder.append("' followed by '");
                String _eventType_1 = this.eventType((EventAction)seq.get(1));
                _builder.append(_eventType_1);
                _builder.append("' ");
                this.error(_builder.toString(), (EObject)it, (EStructuralFeature)ActivityPackage.Literals.HAS_RESOURCE_AND_ITEM__RESOURCE_DEFINITION, ONE_EVENT_WITH_SAME_NAME_PER_ACT, new String[0]);
            };
            seq.forEach(_function_4);
        };
        IterableExtensions.filter((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)Iterables.filter((Iterable)activity.allNodesInTopologicalOrder(), EventAction.class), (Functions.Function1)_function).values(), (Functions.Function1)_function_1), (Functions.Function1)_function_2).forEach(_function_3);
    }

    public String eventType(EventAction event) {
        String _xifexpression = null;
        _xifexpression = event instanceof RequireEvent ? "require" : "raise";
        return _xifexpression;
    }

    @Check
    public void checkIfUsedInActivityFlow(PeripheralAction action) {
        if (action.getIncomingEdges().isEmpty() && action.getOutgoingEdges().isEmpty()) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = action.getName();
            _builder.append(_name);
            _builder.append(" is a dead action. It has no incoming and no outgoing edges.");
            this.error(_builder.toString(), (EObject)action, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, DEAD_ACTION, new String[0]);
        } else {
            boolean _isEmpty = action.getIncomingEdges().isEmpty();
            if (_isEmpty) {
                StringConcatenation _builder_1 = new StringConcatenation();
                String _name_1 = action.getName();
                _builder_1.append(_name_1);
                _builder_1.append(" is a dead action. It has no incoming edges.");
                this.error(_builder_1.toString(), (EObject)action, (EStructuralFeature)EdgPackage.Literals.NODE__INCOMING_EDGES, NO_INCOMING_EDGES, new String[0]);
            } else {
                boolean _isEmpty_1 = action.getOutgoingEdges().isEmpty();
                if (_isEmpty_1) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    String _name_2 = action.getName();
                    _builder_2.append(_name_2);
                    _builder_2.append(" is a dead action. It has no outgoing edges.");
                    this.error(_builder_2.toString(), (EObject)action, (EStructuralFeature)EdgPackage.Literals.NODE__OUTGOING_EDGES, NO_OUTGOING_EDGES, new String[0]);
                }
            }
        }
    }

    @Check
    public void checkActionHasOneIncomingAndOneOutgoingEdge(Node node) {
        boolean _greaterThan;
        if (node instanceof SyncBar) {
            return;
        }
        int _size = node.getIncomingEdges().size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = node.getName();
            _builder.append(_name);
            _builder.append(" can only have one incoming dependency. Use sync bars instead.");
            this.warning(_builder.toString(), (EObject)node, (EStructuralFeature)EdgPackage.Literals.NODE__INCOMING_EDGES, MORE_THAN_ONE_INCOMING_EDGE, new String[0]);
        } else {
            boolean _greaterThan_1;
            int _size_1 = node.getOutgoingEdges().size();
            boolean bl2 = _greaterThan_1 = _size_1 > 1;
            if (_greaterThan_1) {
                StringConcatenation _builder_1 = new StringConcatenation();
                String _name_1 = node.getName();
                _builder_1.append(_name_1);
                _builder_1.append(" can only have one outgoing dependency. Use sync bars instead.");
                this.warning(_builder_1.toString(), (EObject)node, (EStructuralFeature)EdgPackage.Literals.NODE__OUTGOING_EDGES, MORE_THAN_ONE_OUTGOING_EDGE, new String[0]);
            }
        }
    }

    @Check
    public void checkOneClaimPerResourcePerActivity(Activity activity) {
        Functions.Function1 _function = it -> it.getResource();
        Functions.Function1 _function_1 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<Claim> _function_2 = duplicateClaim -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Only one claim per resource ");
            String _name = duplicateClaim.getResource().getName();
            _builder.append(_name);
            _builder.append(" per activity is allowed.");
            this.error(_builder.toString(), (EObject)duplicateClaim, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, ONE_CLAIM_PER_RESOURCE_PER_ACT, new String[0]);
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)Iterables.filter((Iterable)activity.getNodes(), Claim.class), (Functions.Function1)_function).values(), (Functions.Function1)_function_1)).forEach(_function_2);
    }

    @Check
    public void checkOneReleasePerResourcePerActivity(Activity activity) {
        Functions.Function1 _function = it -> it.getResource();
        Functions.Function1 _function_1 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<Release> _function_2 = duplicateRelease -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Only one release per resource ");
            String _name = duplicateRelease.getResource().getName();
            _builder.append(_name);
            _builder.append(" per activity is allowed.");
            this.error(_builder.toString(), (EObject)duplicateRelease, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, ONE_RELEASE_PER_RESOURCE_PER_ACT, new String[0]);
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)Iterables.filter((Iterable)activity.getNodes(), Release.class), (Functions.Function1)_function).values(), (Functions.Function1)_function_1)).forEach(_function_2);
    }

    @Check
    public void checkActionHasAValidClaimAndResource(PeripheralAction action) {
        Functions.Function1 _function = it -> it.getResource();
        Claim claim = (Claim)IterableExtensions.toMap((Iterable)Queries.objectsOfKind((Iterable)action.getGraph().getNodes(), Claim.class), (Functions.Function1)_function).get(action.getResource());
        if (claim == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No claim defined for resource ");
            String _name = action.getResource().getName();
            _builder.append(_name);
            _builder.append(". It is required before ");
            String _name_1 = action.getName();
            _builder.append(_name_1);
            _builder.append(" can be used.");
            this.error(_builder.toString(), (EObject)claim, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, NO_CLAIM_DEFINED_FOR_RESOURCE, new String[0]);
        } else {
            boolean _not;
            boolean _contains = IterableExtensions.contains((Iterable)EdgQueries.allPredecessors((Node)action), (Object)claim);
            boolean bl = _not = !_contains;
            if (_not) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Resource ");
                String _name_2 = action.getResource().getName();
                _builder_1.append(_name_2);
                _builder_1.append(" is not properly claimed (by ");
                String _name_3 = claim.getName();
                _builder_1.append(_name_3);
                _builder_1.append(") before ");
                String _name_4 = action.getName();
                _builder_1.append(_name_4);
                _builder_1.append(" is used.");
                this.warning(_builder_1.toString(), (EObject)claim, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, RESOURCE_NOT_PROPERLY_CLAIMED, new String[0]);
            }
        }
    }

    @Check
    public void checkActionHasAValidReleaseAndResource(PeripheralAction action) {
        Functions.Function1 _function = it -> it.getResource();
        Release release = (Release)IterableExtensions.toMap((Iterable)Queries.objectsOfKind((Iterable)action.getGraph().getNodes(), Release.class), (Functions.Function1)_function).get(action.getResource());
        if (release == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No release defined for resource ");
            String _name = action.getResource().getName();
            _builder.append(_name);
            _builder.append(". It is required before ");
            String _name_1 = action.getName();
            _builder.append(_name_1);
            _builder.append(" can be used.");
            this.error(_builder.toString(), (EObject)action, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, NO_RELEASE_DEFINED_FOR_RESOURCE, new String[0]);
        } else {
            boolean _not;
            boolean _contains = IterableExtensions.contains((Iterable)EdgQueries.allSuccessors((Node)action), (Object)release);
            boolean bl = _not = !_contains;
            if (_not) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Resource ");
                String _name_2 = action.getResource().getName();
                _builder_1.append(_name_2);
                _builder_1.append(" is not properly released (by ");
                String _name_3 = release.getName();
                _builder_1.append(_name_3);
                _builder_1.append(") before ");
                String _name_4 = action.getName();
                _builder_1.append(_name_4);
                _builder_1.append(" is used.");
                this.warning(_builder_1.toString(), (EObject)action, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, RESOURCE_NOT_PROPERLY_RELEASED, new String[0]);
            }
        }
    }

    @Check
    public void checkForCycles(PeripheralAction action) {
        boolean _not;
        Set cycle = IterableExtensions.toSet((Iterable)EdgQueries.allSuccessors((Node)action));
        cycle.retainAll(IterableExtensions.toSet((Iterable)EdgQueries.allPredecessors((Node)action)));
        boolean _isEmpty = cycle.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Actions ");
            Functions.Function1 _function = it -> it.getName();
            String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)cycle, (Functions.Function1)_function), (CharSequence)",");
            _builder.append(_join);
            _builder.append(" have a cyclic dependency.");
            this.error(_builder.toString(), (EObject)action, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, CYCLE_DETECTED, new String[0]);
        }
    }

    @Check
    public void checkActionInParallelForSamePeripheral(PeripheralAction pAction) {
        boolean _tripleEquals;
        Peripheral _peripheral = pAction.getPeripheral();
        boolean bl = _tripleEquals = _peripheral == null;
        if (_tripleEquals) {
            return;
        }
        EList allNodesInTheGraph = pAction.getGraph().getNodes();
        int indexOfpAction = allNodesInTheGraph.indexOf((Object)pAction);
        QueryableIterable _actionsFor = ActivityQueries.getActionsFor((IResource)pAction.getResource(), (Peripheral)pAction.getPeripheral(), PeripheralAction.class, (Iterable)allNodesInTheGraph.subList(indexOfpAction + 1, allNodesInTheGraph.size()));
        for (PeripheralAction otherAction : _actionsFor) {
            boolean _not;
            boolean bl2 = _not = !IterableExtensions.contains((Iterable)EdgQueries.allSuccessors((Node)pAction), (Object)otherAction) && !IterableExtensions.contains((Iterable)EdgQueries.allPredecessors((Node)pAction), (Object)otherAction);
            if (!_not) continue;
            StringConcatenation _builder = new StringConcatenation();
            String _name = pAction.getName();
            _builder.append(_name);
            _builder.append(" cannot be done in parallel with ");
            String _name_1 = otherAction.getName();
            _builder.append(_name_1);
            _builder.append(", as they share the same peripheral.");
            this.error(_builder.toString(), (EObject)pAction, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, ACTION_IN_PARALLEL_FOR_SAME_PERIPHERAL, new String[0]);
        }
    }

    @Check
    public HashMap<ResourcePeripheralKey, SymbolicPosition> indexPrerequisites(Activity activity) {
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)activity.getPrerequisites());
        if (_isNullOrEmpty) {
            return new HashMap<ResourcePeripheralKey, SymbolicPosition>();
        }
        int _size = activity.getPrerequisites().size();
        HashMap<ResourcePeripheralKey, SymbolicPosition> result = new HashMap<ResourcePeripheralKey, SymbolicPosition>(_size);
        EList _prerequisites = activity.getPrerequisites();
        for (LocationPrerequisite prerequisite : _prerequisites) {
            ResourcePeripheralKey key = ResourcePeripheralKey.createKey((HasResourcePeripheral)prerequisite);
            boolean _containsKey = result.containsKey(key);
            if (_containsKey) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Only one location prerequisite for peripheral ");
                String _fqn = key.fqn();
                _builder.append(_fqn);
                _builder.append(" is allowed.");
                this.error(_builder.toString(), (EObject)prerequisite, (EStructuralFeature)ActivityPackage.Literals.LOCATION_PREREQUISITE__PERIPHERAL, MORE_THAN_ONE_LOCATION_PREREQ_FOR_PERIPHERAL, new String[0]);
            }
            result.put(key, prerequisite.getPosition());
        }
        return result;
    }

    @Check
    public void checkMoveHasLocationPrerequisiteForPeripheral(Move move) {
        boolean _noneLocal;
        SymbolicPosition targetPosition;
        boolean _not;
        boolean _isPositionMove = move.isPositionMove();
        boolean bl = _not = !_isPositionMove;
        if (_not) {
            return;
        }
        Activity moveActivity = (Activity)EcoreUtil2.getContainerOfType((EObject)move, Activity.class);
        HashMap<ResourcePeripheralKey, SymbolicPosition> prerequisites = this.indexPrerequisites(moveActivity);
        Move predecessorMove = move.getPredecessorMove();
        ResourcePeripheralKey key = ResourcePeripheralKey.createKey((HasResourcePeripheral)move);
        if (predecessorMove == null && !prerequisites.containsKey(key)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("This movement requires a location prerequisite for peripheral ");
            String _fqn = ActivityValidator.fqn(move.getPeripheral());
            _builder.append(_fqn);
            _builder.append(".");
            this.error(_builder.toString(), (EStructuralFeature)ActivityPackage.Literals.PERIPHERAL_ACTION__PERIPHERAL, NO_LOC_PREREQUISTIE_FOR_PERIPHERAL_FOR_MOVE, new String[0]);
            return;
        }
        SymbolicPosition _xifexpression = null;
        _xifexpression = predecessorMove == null ? prerequisites.get(key) : predecessorMove.getTargetPosition();
        SymbolicPosition sourcePosition = _xifexpression;
        boolean _equals = Objects.equals(sourcePosition, targetPosition = move.getTargetPosition());
        if (_equals) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Peripheral ");
            String _fqn_1 = move.fqn();
            _builder_1.append(_fqn_1);
            _builder_1.append(" already at ");
            String _name = sourcePosition.getName();
            _builder_1.append(_name);
            _builder_1.append(".");
            this.warning(_builder_1.toString(), (EObject)move, (EStructuralFeature)ActivityPackage.Literals.PERIPHERAL_ACTION__PERIPHERAL, SAME_SOURCE_TARGET_FOR_PERIPHERAL, new String[0]);
        }
        if (_noneLocal = ActivityValidator.noneLocal(new EObject[]{sourcePosition, targetPosition, move.getProfile()})) {
            boolean _isPassing;
            PathTargetReference pathTargetRef = MachineQueries.findPath((SymbolicPosition)sourcePosition, (SymbolicPosition)targetPosition, (Profile)move.getProfile());
            if (pathTargetRef == null) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Don't know how to move peripheral ");
                String _fqn_2 = ActivityValidator.fqn(move.getPeripheral());
                _builder_2.append(_fqn_2);
                _builder_2.append(" from ");
                String _name_1 = sourcePosition.getName();
                _builder_2.append(_name_1);
                _builder_2.append(" to ");
                String _name_2 = targetPosition.getName();
                _builder_2.append(_name_2);
                _builder_2.append(" using speed profile ");
                String _name_3 = move.getProfile().getName();
                _builder_2.append(_name_3);
                _builder_2.append(".");
                this.error(_builder_2.toString(), (EObject)move, (EStructuralFeature)ActivityPackage.Literals.MOVE__PROFILE, NO_PATH_FOUND_FOR_PROFILE, new String[0]);
            }
            if ((_isPassing = move.isPassing()) && pathTargetRef != null && !pathTargetRef.getSettling().isEmpty()) {
                StringConcatenation _builder_3 = new StringConcatenation();
                String _name_4 = move.getName();
                _builder_3.append(_name_4);
                _builder_3.append(" cannot pass symbolic position ");
                String _name_5 = targetPosition.getName();
                _builder_3.append(_name_5);
                _builder_3.append(", as settling is defined for its path.");
                this.error(_builder_3.toString(), (EObject)move, (EStructuralFeature)ActivityPackage.Literals.MOVE__STOP_AT_TARGET, SETTLING_ALREADY_DEFINED_FOR_PATH, new String[0]);
            }
        }
    }

    @Check
    public void checkSettling(Move move) {
        boolean _isContinuing = move.isContinuing();
        if (_isContinuing) {
            boolean _isEmpty;
            Distance _distance = move.getDistance();
            EList _settling = null;
            if (_distance != null) {
                _settling = _distance.getSettling();
            }
            EList settling = _settling;
            boolean _xifexpression = false;
            _xifexpression = settling == null ? false : !(_isEmpty = settling.isEmpty());
            boolean isSettling = _xifexpression;
            if (isSettling) {
                StringConcatenation _builder = new StringConcatenation();
                String _name = move.getName();
                _builder.append(_name);
                _builder.append(" cannot pass ");
                String _name_1 = move.getDistance().getName();
                _builder.append(_name_1);
                _builder.append(", as settling has been defined for axes : ");
                String _join = IterableExtensions.join((Iterable)settling, (CharSequence)",");
                _builder.append(_join);
                this.error(_builder.toString(), (EObject)move, (EStructuralFeature)ActivityPackage.Literals.MOVE__STOP_AT_TARGET, SETTLING_ALREADY_DEFINED_FOR_MOVE, new String[0]);
            }
        }
    }

    @Check
    public void checkPropertyValueMatchesProperty(Property property) {
        boolean _isEqualType;
        boolean _not;
        boolean _tripleNotEquals;
        boolean _and = false;
        PropertyDefinition _definition = property.getDefinition();
        String _name = null;
        if (_definition != null) {
            _name = _definition.getName();
        }
        boolean bl = _tripleNotEquals = _name != null;
        _and = !_tripleNotEquals ? false : (_not = !(_isEqualType = property.getValue().isEqualType(property.getDefinition().getValueType())));
        if (_and) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The property \"");
            String _name_1 = property.getDefinition().getName();
            _builder.append(_name_1);
            _builder.append("\" has the wrong type, should be of type \"");
            String _name_2 = property.getDefinition().getValueType().getName();
            _builder.append(_name_2);
            _builder.append("\"\"");
            this.error(_builder.toString(), (EObject)property, (EStructuralFeature)ProductPackage.Literals.PROPERTY__VALUE);
        }
    }

    @Check
    public void checkMatchingSlot(ProductChange productChange) {
        if (Objects.equals(productChange.getTransferType(), TransferType.IN) && !productChange.getSlot().isEmpty()) {
            ActivitySet activitySet = (ActivitySet)EcoreUtil2.getContainerOfType((EObject)productChange, ActivitySet.class);
            Functions.Function1 _function = it -> it.getNodes();
            Functions.Function1 _function_1 = it -> it.getProductChanges();
            Functions.Function1 _function_2 = it -> {
                String _slot = it.getSlot();
                String _slot_1 = productChange.getSlot();
                return Objects.equals(_slot, _slot_1);
            };
            Functions.Function1 _function_3 = it -> it.getTransferType();
            Functions.Function1 _function_4 = it -> Objects.equals(it, TransferType.OUT);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)activitySet.getActivities(), (Functions.Function1)_function), PeripheralAction.class), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4));
            if (_isEmpty) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("No 'out' counterpart found for slot \"");
                String _slot = productChange.getSlot();
                _builder.append(_slot);
                _builder.append("\"");
                this.warning(_builder.toString(), (EObject)productChange, (EStructuralFeature)ActivityPackage.Literals.PRODUCT_CHANGE__TRANSFER_TYPE);
            }
        }
        if (Objects.equals(productChange.getTransferType(), TransferType.OUT) && !productChange.getSlot().isEmpty()) {
            ActivitySet activitySet_1 = (ActivitySet)EcoreUtil2.getContainerOfType((EObject)productChange, ActivitySet.class);
            Functions.Function1 _function_5 = it -> it.getNodes();
            Functions.Function1 _function_6 = it -> it.getProductChanges();
            Functions.Function1 _function_7 = it -> {
                String _slot_1 = it.getSlot();
                String _slot_2 = productChange.getSlot();
                return Objects.equals(_slot_1, _slot_2);
            };
            Functions.Function1 _function_8 = it -> it.getTransferType();
            Functions.Function1 _function_9 = it -> Objects.equals(it, TransferType.IN);
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)activitySet_1.getActivities(), (Functions.Function1)_function_5), PeripheralAction.class), (Functions.Function1)_function_6), (Functions.Function1)_function_7), (Functions.Function1)_function_8), (Functions.Function1)_function_9));
            if (_isEmpty_1) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("No 'in' counterpart found for slot \"");
                String _slot_1 = productChange.getSlot();
                _builder_1.append(_slot_1);
                _builder_1.append("\"");
                this.warning(_builder_1.toString(), (EObject)productChange, (EStructuralFeature)ActivityPackage.Literals.PRODUCT_CHANGE__TRANSFER_TYPE);
            }
        }
    }

    @Check
    public void checkJitEdge(Dependency dependency) {
        boolean _tripleNotEquals;
        JitBounds _bounds = dependency.getBounds();
        boolean bl = _tripleNotEquals = _bounds != null;
        if (_tripleNotEquals && (dependency.getSourceNode() instanceof SyncBar || dependency.getTargetNode() instanceof SyncBar)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No JIT or time constraints are allowed to/from SyncBars");
            this.error(_builder.toString(), (EObject)dependency, (EStructuralFeature)ActivityPackage.Literals.DEPENDENCY__BOUNDS, CONSTRAINT_TO_FROM_SYNCBAR, new String[0]);
        }
    }

    @Check
    public void checkTimeConstraintEdge(Dependency dependency) {
        JitBounds _bounds = dependency.getBounds();
        if (_bounds instanceof TimeBounds) {
            BigDecimal _upper;
            boolean _greaterThan;
            JitBounds _bounds_1 = dependency.getBounds();
            TimeBounds timeBounds = (TimeBounds)_bounds_1;
            BigDecimal _lower = timeBounds.getLower();
            boolean bl = _greaterThan = _lower.compareTo(_upper = timeBounds.getUpper()) > 0;
            if (_greaterThan) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Time constraint between ");
                String _name = dependency.getSourceNode().getName();
                _builder.append(_name);
                _builder.append(" and ");
                String _name_1 = dependency.getTargetNode().getName();
                _builder.append(_name_1);
                _builder.append(" must have a lower bound less than or equal to the upper bound");
                this.error(_builder.toString(), (EObject)timeBounds, (EStructuralFeature)ActivityPackage.Literals.TIME_BOUNDS__LOWER, TIME_CONSTRANT_LIMITS, new String[0]);
            }
        }
    }

    @Check
    public void checkTimeConstraintConstraintEdge(ConstraintEdge edge) {
        JitBounds _bounds = edge.getBounds();
        if (_bounds instanceof TimeBounds) {
            BigDecimal _upper;
            boolean _greaterThan;
            JitBounds _bounds_1 = edge.getBounds();
            TimeBounds timeBounds = (TimeBounds)_bounds_1;
            BigDecimal _lower = timeBounds.getLower();
            boolean bl = _greaterThan = _lower.compareTo(_upper = timeBounds.getUpper()) > 0;
            if (_greaterThan) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Time constraint between ");
                String _name = edge.getSource().getName();
                _builder.append(_name);
                _builder.append(" and ");
                String _name_1 = edge.getTarget().getName();
                _builder.append(_name_1);
                _builder.append(" must have a lower bound less than or equal to the upper bound");
                this.error(_builder.toString(), (EObject)timeBounds, (EStructuralFeature)ActivityPackage.Literals.TIME_BOUNDS__LOWER, TIME_CONSTRANT_LIMITS, new String[0]);
            }
        }
    }

    @Check
    public void checkActivityParametersUnique(Activity activity) {
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> it_1.getName();
            return ListExtensions.map((List)it.getDeclarations(), (Functions.Function1)_function_1);
        };
        Functions.Function1 _function_1 = it -> it;
        Functions.Function1 _function_2 = it -> {
            int _size = ((List)it.getValue()).size();
            return _size > 1;
        };
        Functions.Function1 _function_3 = it -> (String)it.getKey();
        List duplicates = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)IterableExtensions.flatMap((Iterable)activity.getParameterDeclarations(), (Functions.Function1)_function), (Functions.Function1)_function_1).entrySet(), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
        EList _parameterDeclarations = activity.getParameterDeclarations();
        for (ParameterDeclaration pd : _parameterDeclarations) {
            int index = 0;
            while (index < ((Object[])Conversions.unwrapArray((Object)pd.getDeclarations(), Object.class)).length) {
                TypeDefinition declaration = (TypeDefinition)pd.getDeclarations().get(index);
                boolean _contains = duplicates.contains(declaration.getName());
                if (_contains) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Duplicate parameter name ");
                    String _name = declaration.getName();
                    _builder.append(_name);
                    _builder.append(", change one of them");
                    this.error(_builder.toString(), (EObject)pd, (EStructuralFeature)CommonPackage.Literals.PARAMETER_DECLARATION__DECLARATIONS, index);
                }
                ++index;
            }
        }
    }

    private static String fqn(Peripheral peripheral) {
        boolean _tripleEquals;
        Object _xifexpression = null;
        Resource _resource = peripheral.getResource();
        boolean bl = _tripleEquals = _resource == null;
        if (_tripleEquals) {
            _xifexpression = "<<unknown>>";
        } else {
            String _name = peripheral.getResource().getName();
            String _plus = _name + ".";
            String _name_1 = peripheral.getName();
            _xifexpression = _plus + _name_1;
        }
        return _xifexpression;
    }

    public static String names(Iterable<? extends Node> nodes) {
        boolean _not;
        Iterator<? extends Node> iNodes = nodes.iterator();
        boolean _hasNext = iNodes.hasNext();
        boolean bl = _not = !_hasNext;
        if (_not) {
            return "";
        }
        Node _next = iNodes.next();
        String _name = null;
        if (_next != null) {
            _name = _next.getName();
        }
        StringBuilder result = new StringBuilder(_name);
        while (iNodes.hasNext()) {
            Node _next_1 = iNodes.next();
            String _name_1 = null;
            if (_next_1 != null) {
                _name_1 = _next_1.getName();
            }
            String nextName = _name_1;
            String _xifexpression = null;
            boolean _hasNext_1 = iNodes.hasNext();
            _xifexpression = _hasNext_1 ? ", " : " and ";
            result.append(_xifexpression).append(nextName);
        }
        return result.toString();
    }

    public static String id(Node node) {
        return ActivityValidator.id(node, false);
    }

    public static String id(Node node, boolean capitalize) {
        String _name;
        StringConcatenation _builder;
        if (node == null) {
            return null;
        }
        String _switchResult = null;
        Node it = node;
        boolean _matched = false;
        if (it instanceof Claim) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("claim ");
            _name = ((Claim)it).getName();
            _builder.append(_name);
            _switchResult = _builder.toString();
        }
        if (!_matched && it instanceof Release) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("release ");
            _name = ((Release)it).getName();
            _builder.append(_name);
            _switchResult = _builder.toString();
        }
        if (!_matched && it instanceof SimpleAction) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("action ");
            _name = ((SimpleAction)it).getName();
            _builder.append(_name);
            _switchResult = _builder.toString();
        }
        if (!_matched && it instanceof Move) {
            boolean _not;
            _matched = true;
            _builder = new StringConcatenation();
            boolean _isStopAtTarget = ((Move)it).isStopAtTarget();
            boolean bl = _not = !_isStopAtTarget;
            if (_not) {
                boolean _isPositionMove = ((Move)it).isPositionMove();
                if (_isPositionMove) {
                    _builder.append("passing ");
                } else {
                    _builder.append("continuing ");
                }
            }
            _builder.append("move ");
            _name = ((Move)it).getName();
            _builder.append(_name);
            _switchResult = _builder.toString();
        }
        if (!_matched && it instanceof SyncBar) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("sync-bar ");
            _name = ((SyncBar)it).getName();
            _builder.append(_name);
            _switchResult = _builder.toString();
        }
        String id = _switchResult;
        String _xifexpression = null;
        _xifexpression = capitalize ? StringExtensions.toFirstUpper(id) : id;
        return _xifexpression;
    }

    private static boolean noneLocal(EObject ... object) {
        Functions.Function1 _function = it -> ActivityParametersUtil.isDeclaration((EObject)it);
        return IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)object)), (Functions.Function1)_function));
    }
}

