/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.external.api.impl;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

public class LaunchConfigurationManager {
    private LaunchConfigurationManager() {
    }

    public static void runLaunchConfiguration(String configName, String configTypeId, Map<String, Object> attributes, boolean debug) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType(configTypeId);
        if (configType == null) {
            throw new IllegalArgumentException("Launch configuration type not found: " + configTypeId);
        }
        ILaunchConfiguration config = LaunchConfigurationManager.findLaunchConfiguration(configName, configType);
        if (config == null) {
            config = LaunchConfigurationManager.createLaunchConfiguration(configName, configType, attributes);
            System.out.println("Created new launch configuration: " + configName);
        } else {
            ILaunchConfigurationWorkingCopy workingCopy = config.getWorkingCopy();
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                workingCopy.setAttribute(entry.getKey(), entry.getValue());
            }
            config = workingCopy.doSave();
            System.out.println("Updated existing launch configuration: " + configName);
        }
        config.launch(debug ? "debug" : "run", null);
        System.out.println("Launch configuration '" + configName + "' started successfully.");
    }

    private static ILaunchConfiguration findLaunchConfiguration(String configName, ILaunchConfigurationType configType) throws CoreException {
        ILaunchConfiguration[] configs;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] iLaunchConfigurationArray = configs = launchManager.getLaunchConfigurations(configType);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (config.getName().equals(configName)) {
                return config;
            }
            ++n2;
        }
        return null;
    }

    private static ILaunchConfiguration createLaunchConfiguration(String configName, ILaunchConfigurationType configType, Map<String, Object> attributes) throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = configType.newInstance(null, configName);
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            workingCopy.setAttribute(entry.getKey(), entry.getValue());
        }
        return workingCopy.doSave();
    }
}

