/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.util;

import java.awt.Component;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.lsat.motioncalculator.TimePosition;
import org.jfree.chart.ChartPanel;
import org.jfree.data.xy.XYDataset;

public class ChartCsvExporter {
    public void exportChart(ChartPanel chartPanel, Map<Integer, XYDataset> datasetsMap, String chartTitle) {
        if (datasetsMap == null || datasetsMap.isEmpty()) {
            JOptionPane.showMessageDialog((Component)chartPanel, "No datasets available to export.");
            return;
        }
        List<String> seriesNames = this.getAllSeriesNames(datasetsMap);
        if (seriesNames.isEmpty()) {
            JOptionPane.showMessageDialog((Component)chartPanel, "No series available to export.");
            return;
        }
        List<String> selectedSeries = this.selectSeries(chartPanel, seriesNames);
        if (selectedSeries.isEmpty()) {
            return;
        }
        double autoDt = this.computeDt(selectedSeries, datasetsMap);
        double dt = this.promptForDt(chartPanel, autoDt);
        if (dt <= 0.0) {
            return;
        }
        File file = this.chooseCsvFile(chartPanel, chartTitle);
        if (file == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var12_12 = null;
            try (PrintWriter pw = new PrintWriter(file);){
                this.exportSelectedSeries(pw, selectedSeries, datasetsMap, dt);
                JOptionPane.showMessageDialog((Component)chartPanel, "Export completed:\n" + file.getAbsolutePath());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog((Component)chartPanel, "Error exporting CSV:\n" + ex.getMessage(), "Error", 0);
        }
    }

    private List<String> getAllSeriesNames(Map<Integer, XYDataset> datasetsMap) {
        ArrayList<String> names = new ArrayList<String>();
        for (XYDataset ds : datasetsMap.values()) {
            if (ds == null) continue;
            int i = 0;
            while (i < ds.getSeriesCount()) {
                names.add(ds.getSeriesKey(i).toString());
                ++i;
            }
        }
        return names;
    }

    private List<String> selectSeries(ChartPanel chartPanel, List<String> seriesNames) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        ArrayList<JCheckBox> checkboxes = new ArrayList<JCheckBox>();
        for (String name : seriesNames) {
            JCheckBox cb = new JCheckBox(name, true);
            checkboxes.add(cb);
            panel.add(cb);
        }
        int result = JOptionPane.showConfirmDialog((Component)chartPanel, new JScrollPane(panel), "Select series to export", 2, -1);
        if (result != 0) {
            return Collections.emptyList();
        }
        return checkboxes.stream().filter(AbstractButton::isSelected).map(AbstractButton::getText).collect(Collectors.toList());
    }

    private double computeDt(List<String> selectedSeries, Map<Integer, XYDataset> datasetsMap) {
        double minDeltaT = Double.MAX_VALUE;
        for (XYDataset ds : datasetsMap.values()) {
            if (ds == null) continue;
            int i = 0;
            while (i < ds.getSeriesCount()) {
                String name = ds.getSeriesKey(i).toString();
                if (selectedSeries.contains(name)) {
                    int j = 1;
                    while (j < ds.getItemCount(i)) {
                        double delta = ds.getXValue(i, j) - ds.getXValue(i, j - 1);
                        if (delta > 0.0) {
                            minDeltaT = Math.min(minDeltaT, delta);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return minDeltaT;
    }

    private double promptForDt(ChartPanel chartPanel, double autoDt) {
        String input = JOptionPane.showInputDialog((Component)chartPanel, "Enter export time step (dt):", String.format(Locale.ROOT, "%.6f", autoDt));
        if (input == null) {
            return -1.0;
        }
        try {
            double dt = Double.parseDouble(input);
            if (dt <= 0.0) {
                throw new NumberFormatException();
            }
            return dt;
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog((Component)chartPanel, "Invalid dt value. Using recommended: " + autoDt);
            return autoDt;
        }
    }

    private File chooseCsvFile(ChartPanel chartPanel, String chartTitle) {
        int overwrite;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Save CSV file");
        chooser.setSelectedFile(new File(chartTitle + " export.csv"));
        do {
            int result;
            if ((result = chooser.showSaveDialog((Component)chartPanel)) != 0) {
                return null;
            }
            File file = chooser.getSelectedFile();
            if (file == null) {
                return null;
            }
            if (!(file = new File(file.getParentFile(), file.getName())).exists()) {
                return file;
            }
            overwrite = JOptionPane.showConfirmDialog((Component)chartPanel, "The file already exists:\n" + file.getAbsolutePath() + "\n\nDo you want to overwrite it?", "Confirm overwrite", 1, 2);
            if (overwrite != 0) continue;
            return file;
        } while (overwrite == 1);
        return null;
    }

    private void exportSelectedSeries(PrintWriter pw, List<String> selectedSeries, Map<Integer, XYDataset> datasetsMap, double dt) {
        HashMap axisData = new HashMap();
        double minTime = Double.MAX_VALUE;
        double maxTime = -1.7976931348623157E308;
        for (XYDataset ds : datasetsMap.values()) {
            if (ds == null) continue;
            int i = 0;
            while (i < ds.getSeriesCount()) {
                String name = ds.getSeriesKey(i).toString();
                if (selectedSeries.contains(name)) {
                    ArrayList<TimePosition> list = new ArrayList<TimePosition>();
                    int j = 0;
                    while (j < ds.getItemCount(i)) {
                        list.add(new TimePosition(ds.getXValue(i, j), ds.getYValue(i, j)));
                        ++j;
                    }
                    list.sort(Comparator.comparingDouble(TimePosition::getTime));
                    axisData.put(name, list);
                    if (!list.isEmpty()) {
                        minTime = Math.min(minTime, ((TimePosition)list.get(0)).getTime());
                        maxTime = Math.max(maxTime, ((TimePosition)list.get(list.size() - 1)).getTime());
                    }
                }
                ++i;
            }
        }
        pw.print("Time");
        selectedSeries.forEach(s -> pw.print("," + s));
        pw.println();
        double t = minTime;
        while (t <= maxTime) {
            pw.print(String.format(Locale.ROOT, "%.6f", t));
            for (String s2 : selectedSeries) {
                pw.print("," + String.format(Locale.US, "%.6f", this.interpolate((List)axisData.get(s2), t)));
            }
            pw.println();
            t += dt;
        }
    }

    private double interpolate(List<TimePosition> list, double t) {
        if (list == null || list.isEmpty()) {
            return 0.0;
        }
        if (t <= list.get(0).getTime()) {
            return list.get(0).getPosition();
        }
        if (t >= list.get(list.size() - 1).getTime()) {
            return list.get(list.size() - 1).getPosition();
        }
        int i = 1;
        while (i < list.size()) {
            TimePosition prev = list.get(i - 1);
            TimePosition next = list.get(i);
            if (t <= next.getTime()) {
                double ratio = (t - prev.getTime()) / (next.getTime() - prev.getTime());
                return prev.getPosition() + ratio * (next.getPosition() - prev.getPosition());
            }
            ++i;
        }
        return 0.0;
    }
}

