/*
 * Decompiled with CFR 0.152.
 */
package machine.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import machine.Path;
import machine.PathTargetReference;
import machine.Peripheral;
import machine.Profile;
import machine.SymbolicPosition;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.lsat.common.emf.common.util.BufferedDiagnosticChain;

public class MachineEValidator
implements EValidator {
    public static final MachineEValidator INSTANCE = new MachineEValidator();

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return eObject == null ? true : this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        BufferedDiagnosticChain bufferedDiagnostics = new BufferedDiagnosticChain(diagnostics);
        if (5 == eClass.getClassifierID()) {
            this.validatePeripheral((Peripheral)eObject, (DiagnosticChain)bufferedDiagnostics);
        }
        return bufferedDiagnostics.getMaxSeverity() < 2;
    }

    private void validatePeripheral(Peripheral peripheral, DiagnosticChain diagnostics) {
        int i = 0;
        while (i < peripheral.getPaths().size()) {
            Path p1 = (Path)peripheral.getPaths().get(i);
            int j = i + 1;
            while (j < peripheral.getPaths().size()) {
                Path p2 = (Path)peripheral.getPaths().get(j);
                Set<String> incompatiblePositions = this.getIncompatibleTargetReferences(p1, p2);
                if (!incompatiblePositions.isEmpty()) {
                    this.writeDiagnostic(diagnostics, 4, String.format("Path '%s' is incompatible with path '%s' as settling is different for locations %s", p1.getName(), p2.getName(), incompatiblePositions), new EObject[]{p1, p2});
                }
                ++j;
            }
            ++i;
        }
    }

    private Set<String> getIncompatibleTargetReferences(Path p1, Path p2) {
        HashSet<Profile> profilesIntersection = new HashSet<Profile>((Collection<Profile>)p1.getProfiles());
        profilesIntersection.retainAll((Collection<?>)p2.getProfiles());
        if (profilesIntersection.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<SymbolicPosition> sourcesIntersection = new HashSet<SymbolicPosition>((Collection<SymbolicPosition>)p1.getSources());
        sourcesIntersection.retainAll((Collection<?>)p2.getSources());
        if (sourcesIntersection.isEmpty()) {
            return Collections.emptySet();
        }
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        Map<SymbolicPosition, PathTargetReference> t2 = this.indexPathTargetReferences(p2.getTargets());
        for (PathTargetReference t1 : p1.getTargets()) {
            SymbolicPosition pos = t1.getPosition();
            if (!t2.containsKey(pos) || this.equals(t1, t2.get(pos)) || sourcesIntersection.size() <= (sourcesIntersection.contains(pos) ? 1 : 0)) continue;
            result.add(t1.getPosition().getName());
        }
        return result;
    }

    private Map<SymbolicPosition, PathTargetReference> indexPathTargetReferences(EList<PathTargetReference> targets) {
        HashMap<SymbolicPosition, PathTargetReference> result = new HashMap<SymbolicPosition, PathTargetReference>(targets.size());
        for (PathTargetReference target : targets) {
            result.put(target.getPosition(), target);
        }
        return result;
    }

    private boolean equals(PathTargetReference t1, PathTargetReference t2) {
        if (t1 == t2) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        return t1.getPosition().equals(t2.getPosition()) && t1.getSettling().equals(t2.getSettling());
    }

    private void writeDiagnostic(DiagnosticChain diagnostics, int severity, String message, EObject ... data) {
        diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.lsat.machine.dsl", 0, message, (Object[])data));
    }
}

